/*
 * simple disk fixer
 */

#include "dskdefs.h"
#include <sys/param.h>
#include <sys/stat.h>

static DISK dsk[MAXDISKS], *root;
static int dofix = 1;
static int promptf = 0;
static int rootflg = 1;    /* 1 = don't fix root disk */
static struct badnames baddy, *badp = (&baddy);

main(argc, argv)
int argc;
char *argv[];{

	register FILE *fp;
	register DISK *tmp;
	register int i, ndisks;
	int status;

	setbuf(stdout, NULL);
	dskp = root = &dsk[0];
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') break;
		switch(argv[i][1]) {
			case 'c':
				dofix = 0;
				break;
			case 'r':
				rootflg = 0;
				break;
			case 'p':
				dofix = 0;
				promptf = 1;
				break;
			default:
				bomb("Usage:  dskfix [-c] [-r] [-p] [diskname ...]");
			}
		}
	if ((fp = fopen(DISKLIST, "r")) == NULL)
		bomb("No disk list");
	while (fscanf(fp, "%s%s%d%d", dskp->dskname, dskp->mntname,
	  &(dskp->isize), &(dskp->fsize)) == 4){
		dskp++;
		getc(fp);
		}
	ndisks = dskp-root;
	if (ndisks == 0) bomb("Proto list empty");
	if (ndisks > MAXDISKS) bomb("Proto list too long");
	tmp = dskp-1;

	for (dskp = root; dskp <= tmp; dskp++) {
		if (i < argc) {
			for (ndisks = i; ndisks < argc; ndisks++) {
				if (strcmp(argv[ndisks], dskp->dskname)==0) {
					argv[ndisks] = 0;
					goto chkdsk;
					}
				}
			continue;
			}
	chkdsk:
		dfildes = open(dskp->dskname, 2);
		if (dfildes < 0) {
			if (dskp == root) bomb("Can't open root");
			else printf("cannot open %s\n", dskp->dskname);
			continue;
			}
		check();
		if (dskp->bogus)
			bomb("bad super block for %s", dskp->dskname);
		if (dskp->nbad || dskp->badfree) fix(dskp, 1);
		close(dfildes);
		}
	sync();
	for (ndisks = i; ndisks < argc; ndisks++) {
		if (argv[ndisks])
			printf("'%s' is not a known disk\n", argv[ndisks]);
		}

	/*
	 * report on lost files to news
	 * dependent on where "news/.mail" is
	 */
	if (badp != &baddy) {
		printf("mail news </tmp/dskfix\n");
		fp = fopen("/tmp/dskfix", "w");
		if (fp == NULL) {
			printf("Can't mail to news\n");
			return;
			}
		fprintf(fp, "Lost in last disk fix:\n");
		for (badp = &baddy; badp->badname != 0; badp = badp->badnext) {
			fprintf(fp, "\t%s\n", badp->badname);
			}
		fclose(fp);
		for (dskp = root; dskp <= tmp; dskp++)
			if (strcmp(dskp->mntname, NEWSMNT) == 0)
				break;
		if (dskp > tmp) {
			printf("Cannot find dsklist entry for %s\n", NEWSMNT);
			return;
		}
                if (mount(dskp->dskname, NEWSMNT, 0)) {
			printf("Cannot mount %s\n", dskp->dskname);
			return;
		}
                if ((i = fork()) == -1) {
                        printf("Can't fork to do mail\n");
                        }
                else if (i == 0) {
                        close(0);
                        open("/tmp/dskfix", 0);
                        execl("/bin/mail", "mail", "news", 0);
                        printf("Can't exec mail\n");
                        return;
                        }
                else while (wait(&status) != i);
                umount(dskp->dskname);
                }
	}

/*
 * do a fix on the disk given info from check
 * cases for each bad inode:
 *	dup block(s)
 *	bad block(s)
 *	entries != links or entries == 0
 *	or any combination thereof
 *
 * currently dups are treated as bad
 */

fix(bad, redoflag)
register DISK *bad;
int redoflag;{

	register IINFO *ip;
	register int i;
	int n, dups;

	dups = 0;
	printf("\tfix strategy:\n");
	if ((n = bad->nbad) > 0) {
		mnt(bad, 0);
		for (i = 0; i < n; i++, ip++) {
			ip = bad->badi[i];
			printf("\t\tinode %d, state %s\n", ip->ino, statestr(ip->state));
			switch(ip->state) {
				case DUP:
				case LINKS+DUP:
					dups++;
					if (redoflag) break;

				case BAD:
				case DUP+BAD:
				case LINKS+BAD:
				case LINKS+DUP+BAD:
					if (bad == root && rootflg)
						bomb("Bad root disk");
					if (dir(ip->inames)) return;
					clri(ip->ino);
					remove(ip->inames);
					bad->badfree = 1;
					break;
				case LINKS:
					if (ip->entries > ip->links) {
						if (bad == root && rootflg)
							bomb("Bad root disk");
						if (ip->links == 0) {
							if (dir(ip->inames))
								return;
							clri(ip->ino);
							remove(ip->inames);
							bad->badfree = 1;
							break;
							}
						pokelinks(ip->ino, ip->entries, dofix);
						sync();
						}
					else if (ip->entries == ip->links){
						if (dir(ip->inames)) return;
						clri(ip->ino);
						bad->badfree = 1;
						}
					else {
						pokelinks(ip->ino, ip->entries, dofix);
						if (ip->entries == 0)
							bad->badfree = 1;
						}
					break;
				default:
					bomb("Unknown inode state %d on %s",
						ip->state, dskp->dskname);
				}
			}
		umnt(bad);
		}
	if (bad->badfree) {
		rebuild(bad, dofix);
		}
	if (dups && redoflag) {
		if (!dofix)
			printf("redo %s\n", bad->dskname);
		else {
			for (i = 0; i < bad->nbad; i++)
				cfree(bad->badi[i]);
			bad->nbad = bad->badfree = 0;
			check();
			if (dskp->nbad || dskp->badfree) fix(bad, 0);
			}
		}
	if (!dofix && promptf) {
		printf("OK?\n");
		if ((i = getchar()) == 'x') exit(1);
		else if (i != 'n') {
			dofix = 1;
			fix(bad, redoflag);
			dofix = 0;
			}
		while (i != '\n') i = getchar();
		}
	}

clri(ino)
register int ino;{

	printf("\t\t\tclri %s %d\n", dskp->dskname, ino);
	if (dofix) clear(ino);
	}

mnt(bad, rwflag)
register DISK *bad;
int rwflag;{

	register int retval;
	char *special, *dir;

	if (bad == root) return;
	special = bad->dskname;
	dir = bad->mntname;
	printf("\t\t/etc/mount %s %s\n", special, dir);
	if (dofix) {
		retval = mount(special, dir, rwflag);
		if (retval == -1) printf("\t\t\t-- mount failed\n");
		}
	}

umnt(bad)
register DISK *bad;{

	register int retval;
	char *special;

	if (bad == root) return;
	special = bad->dskname;
	printf("\t\t/etc/umount %s\n", special);
	if (dofix) {
		retval = umount(special);
		if (retval == -1) printf("\t\t\t-- umount failed\n");
		}
	}

/*
 * remove the files name by "name"
 *	files are separated by binary 1's
 */

remove(name)
register char *name;{

	register char *p;
	register int save;

	if (name == 0) {
		printf("\t\t\tno file to remove\n");
		return;
		}
	p = name;
	for (;;) {
		while (*p != '\0' && *p != 1) p++;
		save = *p;
		*p++ = '\0';
		printf("\t\t\trm %s\n", name);
		if (dofix) {
			unlink(name);
			badp->badname = name;
			badp->badnext = calloc(1, sizeof(struct badnames));
			badp = badp->badnext;
			}
		if (save == '\0') break;
		name = p;
		}
	}

/*
 * dir - check if any of the names in "name" are directories
 *	has to be done before remove so the inode won't be cleared
 */

dir(name)
register char *name;{

	extern int errno;
	register char *p;
	register int save;
	struct stat sbuf;

	if (!dofix) return(0);
	if ((p = name) == 0) return(0);
	for (;;) {
		while (*p != '\0' && *p != 1) p++;
		save = *p;
		*p = '\0';
		if (stat(name, &sbuf) < 0)
			bomb("Stat failed (%d) on %s", errno, name);
		if ((sbuf.st_mode&S_IFMT) == S_IFDIR) {
			bomb("%s is a directory", name);
			return(-1);
			}
		if (save == '\0') break;
		*p++ = save;
		name = p;
		}
	return(0);
	}
bomb(arglist){
	printf("fatal error: ");
	printf("%r", &arglist);
	putchar('\n');
	exit(1);
	}

/*
 * Generate a string to be printed indicating state.
 */
statestr(state)
int state;
{
	static char buf[50];

	buf[0] = '\0';
	if (state & DUP)
		strcat(buf, "dup ");
	if (state & BAD)
		strcat(buf, "bad ");
	if (state & LINKS)
		strcat(buf, "links");
	if (state & MISSING)
		strcat(buf, "missing");
	return(buf);
}
