#include        <stdio.h>
#include	"defs.h"
#include	"sym.h"

extern struct   ionod   *inout();
extern int  chkword();
extern int  chksym();
extern union	node    *term();
extern union	node    *makelist();
extern union	node    *list();
extern struct   regnod  *syncase();
extern union	node    *item();
extern int  skipnl();
extern int  prsym();
extern int  synbad();


/* ========	command line decoding	========*/




union	node    *
makefork(flgs, i)
register int	flgs;
register union	node    *i;
{
	register union	node    *f;

	f = (union node *) malloc(NODESIZ);
	f->forknod.type = flgs | TFORK;
	f->forknod.forktre = i;
	f->forknod.forkio = NULL;
	return(f);
}

union	node    *
makelist(type, i, r)
register int	type;
register union	node    *i, *r;
{
	register union	node    *l;

	if (i == NULL || r == NULL) {
		synbad();
	} else {
		l = (union node *) malloc(NODESIZ);
		l->lstnod.type = type;
		l->lstnod.lstlef = i;
		l->lstnod.lstrit = r;
	}
	return(l);
}

/*
 * cmd
 *	empty
 *	list
 *	list & [ cmd ]
 *	list [; cmd ]
 */

union	node    *
cmd(sym, flg)
register int  sym;
register int	flg;
{
	register union	node    *i, *e;

	i = list(flg);

	if (wdval==NL) {	     
		if (flg&NLFLG) {	
			wdval=';'; 
			chkpr(NL);
		}
	} 
	else if (i == NULL && (flg & MTFLG) == 0) {
		synbad();
	}

	switch (wdval) {

	case '&':
		if (i) {	
			i = makefork(FINT|FPRS|FAMP, i);
		} 
		else {    
			synbad();
		}

	case ';':
		if (e=cmd(sym, flg|MTFLG)) {	
			i = makelist(TLST, i, e);
		}
		break;

	case EOFSYM:
		if (sym==NL) {	
			break;
		}

	default:
		if (sym) {	
			chksym(sym);
		}

	}
	return(i);
}

/*
 * list
 *	term
 *	list && term
 *	list || term
 */

union	node    *
list(flg)
{
	register union	node    *r;
	register int  b;

	r = term(flg);
	while (r && ((b=(wdval==ANDFSYM)) || wdval==ORFSYM)) {	
		r = makelist((b ? TAND : TORF), r, term(NLFLG));
	}
	return(r);
}

/*
 * term
 *	item
 *      item | term
 */

union	node    *
term(flg)
register int     flg;
{
	register union	node    *t;

	reserv++;
	if (flg & NLFLG) {
		skipnl();
	} 
	else {	
		word();
	}

	if ((t = item(TRUE)) && wdval == '|') {
		return(makelist(TFIL, makefork(FPOU, t), makefork(FPIN|FPCL, term(NLFLG))));
	} 
	else {	
		return(t);
	}
}

struct   regnod  *
syncase(esym)
register int  esym;
{
	skipnl();
	if (wdval == esym) {
		return(NULL);
	} else {
		register struct regnod  *r;

		r = (struct regnod *) malloc(NODESIZ);
		r->regptr = NULL;
		for (;;) { 
			wdarg->argnxt = r->regptr;
			r->regptr = wdarg;
			if (wdval || (word() != ')' && wdval != '|')) {
				synbad();
			}
			if (wdval == '|') {
				word();
			} 
			else { 
				break;
			}
		}
		r->regcom = cmd(0, NLFLG|MTFLG);
		if (wdval == ECSYM) {
			r->regnxt = syncase(esym);
		} 
		else {	
			chksym(esym);
			r->regnxt = NULL;
		}
		return(r);
	}
}

/*
 * item
 *
 *	(cmd) [ < in  ] [ > out ]
 *	word word* [ < in ] [ > out ]
 *	if ... then ... else ... fi
 *	for ... while ... do ... done
 *	case ... in ... esac
 *	begin ... end
 */

union	node    *
item(flag)
register char	flag;
{
	register union	node    *t;
	register struct ionod   *io = NULL;

	if (flag) {	
		io = inout((struct ionod *) NULL);
	} 

	switch (wdval) {

	case CASYM:
		{
			t = (union node *) malloc(NODESIZ);
			chkword();
			t->swnod.swarg = wdarg->argval;
			skipnl(); 
			chksym(INSYM|BRSYM);
			t->swnod.swlst = syncase(wdval == INSYM? ESSYM: KTSYM);
			t->swnod.type = TSW;
			break;
		}

	case IFSYM:
		{
			register int  w;

			t = (union node *) malloc(NODESIZ);
			t->ifnod.type = TIF;
			t->ifnod.iftre = cmd(THSYM, NLFLG);
			t->ifnod.thtre = cmd(ELSYM|FISYM|EFSYM, NLFLG);
			t->ifnod.eltre = ((w = wdval) == ELSYM? cmd(FISYM, NLFLG):
                                          (w == EFSYM? (wdval = IFSYM, item(0)): NULL));
			if (w == EFSYM) {
				return(t);
			}
			break;
		}

	case FORSYM:
		{
			t = (union node *) malloc(NODESIZ);
			t->fornod.type = TFOR;
			t->fornod.forlst = NULL;
			chkword();
			t->fornod.fornam = wdarg->argval;
			if (skipnl() == INSYM) {
				chkword();
				t->fornod.forlst = item(0);
				if (wdval != NL && wdval != ';') {
					synbad();
				}
				chkpr(wdval); 
				skipnl();
			}
			chksym(DOSYM | BRSYM);
			t->fornod.fortre = cmd(wdval == DOSYM? ODSYM: KTSYM, NLFLG);
			break;
		}

	case WHSYM:
	case UNSYM:
		{
			t = (union node *) malloc(NODESIZ);
			t->whnod.type = (wdval == WHSYM? TWH: TUN);
			t->whnod.whtre = cmd(DOSYM, NLFLG);
			t->whnod.dotre = cmd(ODSYM, NLFLG);
			break;
		}

	case BRSYM:
		t = cmd(KTSYM, NLFLG);
		break;

	case '(':
		{
			register union	node  *p;

			p = (union node *) malloc(NODESIZ);
			p->parnod.partre = cmd(')', NLFLG);
			p->parnod.type = TPAR;
			t = makefork(NULL, p);
			break;
		}

	default:
		if (io == NULL) {
			return(NULL);
		}

	case 0:
		{
			register struct	argnod	*argp;
			register struct	argnod	**argtail;
			register struct argnod  *argset = NULL;
			int  keywd = 1;

			t = (union node *) malloc(NODESIZ);
			t->comnod.comio = io;
			argtail = &(t->comnod.comarg);
			while (wdval == 0) {
				argp = wdarg;
				if (wdset && keywd) {	
					argp->argnxt = argset;
					argset = argp;
				} else {
					*argtail = argp;
					argtail = &(argp->argnxt); 
					keywd = flags & KEYFLG;
				}
				word();
				if (flag) { 
					t->comnod.comio = inout(t->comnod.comio);
				}
			}
			t->comnod.type = TCOM;
			t->comnod.comset = argset;
			*argtail = NULL;
			return(t);
		}

	}
	reserv++; 
	word();
	if ((io = inout(io)) != NULL) {
		t = makefork(0, t);
		t->forknod.forkio = io;
	}
	return(t);
}


skipnl()
{
	while ((reserv++, word() == NL)) {
		chkpr(NL);
	}
	return(wdval);
}

struct   ionod   *
inout(lastio)
register struct  ionod   *lastio;
{
	register int  iof;
	register struct ionod   *iop;
	register char	c;

	iof = wdnum;

	switch (wdval) {

	case DOCSYM:
		iof |= IODOC; 
		break;

	case APPSYM:
	case '>':
		if (wdnum == 0) {
			iof |= 1;
		}
		iof |= IOPUT;
		if (wdval == APPSYM) {
			iof |= IOAPP; 
			break;
		}

	case '<':
		if ((c = nextc(0)) == '&') {
			iof |= IOMOV;
		} else if (c == '>') {
			iof |= IORDW;
		} else {
			peekc = c|MARK;
		}
		break;

	default:
		return(lastio);
	}

	chkword();
	iop = (struct ionod *) malloc(IOSIZ);
	iop->ioname = wdarg->argval;
	iop->iofile = iof;
        iop->iolst = NULL;
	if (iof & IODOC) {
		iop->iolst = iopend;
		iopend = iop;
	}
	word(); 
	iop->ionxt = inout(lastio);
	return(iop);
}

chkword()
{
	if (word()) {    
		synbad();
	}
}

chksym(sym)
{
	register int  x = sym & wdval;

	if (((x & SYMFLG)? x: sym) != wdval) {
		synbad();
	}
}

prsym(sym)
{
	if (sym&SYMFLG) {	
		register struct	sysnod	*sp=reserved;
		while (sp->sysval
		    && sp->sysval!=sym) { 
			sp++;
		}
		fprintf(stderr, "%s", sp->sysnam);
	} 
	else if (sym==EOFSYM) {	
		fprintf(stderr, "%s", endoffile);
	} 
	else {	     
		if (sym&SYMREP) { 
			putc(sym, stderr);
		}
		if (sym==NL) {	
			fprintf(stderr, "newline");
		} 
		else {	
			putc(sym, stderr);
		}
	}
}

synbad()
{
	prp(); 
	fprintf(stderr, "%s", synmsg);
	if ((flags & TTYFLG) == 0) {
		fprintf(stderr, "%s %d", atline, flin);
	}
	fprintf(stderr, ": '", colon);   /* changed ` to ' */
	if (wdval) {	
		prsym(wdval);
	} else {
		fprintf(stderr, "%s", wdarg->argval);
	}
	fprintf(stderr, "'%s\n", unexpected);
	exitsh(SYNBAD);
}
