#include <stdio.h>
#include <sgtty.h>

#define PFLEN 80
#define MINPF 0
#define MAXPF 12

struct sty {
        int     pfn;
        char    *pfk;
}       sty;
 
char    pfbuf[PFLEN + 1];
int     nlf = 1;
int     eflg, rflg;
 
main(argc,argv)
int argc;
char **argv;
{
        register char *p, *q;
	register int i;
        extern  errno;

	if (argc == 1) {
		sty.pfk = pfbuf;
		for (sty.pfn = 0; sty.pfn <= 12; sty.pfn++) {
			ioctl(2, TUBGETPF, &sty);
			if (sty.pfn == 0)
				printf("test req: ");
			else
				printf("pf %2d:    ", sty.pfn);
			switch (pfbuf[0]) {
			case 0376:
				printf("<redisplay - backward>\n");
				break;
			case 0375:
				printf("<redisplay - forward>\n");
				break;
			case 004:
				printf("<EOT>\n");
				break;
			case '\0':
				printf("<empty>\n");
				break;
			default:
				for (p = pfbuf; *p; p++)
					;
				if (*--p == '\n')
					*p = '\0';
				else
					p = 0;
				printf("%s%s\n", pfbuf, p == 0 ? "     <no newline>" : "");
				break;
			}
		}
		exit(0);
	}
        if (*argv[1] == '-') {
		if (argc <= 2) {
			fprintf(stderr, "No pf key number\n");
			exit(1);
		}
		switch (argv[1][1]) {
		case 'n':
		case '\0':  /* for compatibility with earlier versions */
	                nlf = 0;
	                argv++;
	                argc--;
			break;
		case 'r':
			eflg++;
			sty.pfn = getnum(argv[2]);
			if (argv[1][2] == 'f')
			        sty.pfk = -1;
			else
				sty.pfk = 0;
			break;
		case 'e':
			rflg++;
			sty.pfn = getnum(argv[2]);
			sty.pfk = pfbuf;
			pfbuf[0] = '\4';      /* EOT */
			pfbuf[1] = '\0';
			break;
	        }
	}
	if (eflg == 0 && rflg == 0) {
                sty.pfn = getnum(argv[1]);
                sty.pfk = pfbuf;
                p = pfbuf;
		for (i = 2; i < argc; i++) {
	                q = argv[i];
	                while (*p++ = *q++)
			        ;
			*(p -1) = ' ';
		}
                if (nlf) {
                        *(p - 1) = '\n';
                        *p++ = '\0';
                } else
                        *(p - 1) = '\0';

	        if (p > &pfbuf[PFLEN + 1]) {
		        printf("pf: max len is %d\n", PFLEN);
		        exit(1);
	        }
	}
        if (ioctl(2, TUBSETPF, &sty))
		exit(1);
}

getnum(cp)
char    *cp;
{
	int n;

	n = atoi(cp);
	if (*cp < '0' || *cp > '9' || n < MINPF || n > MAXPF) {
		fprintf(stderr, "Invalid pf key number: %s\n", cp);
		exit(1);
	}
	return(n);
}
