#include "dcon.h"

/*
 * mapping of addresses must handle:
 *	addresses to the stack
 *	the fact that shared text is not dumped in a core image
 *	shared text data segment addresses being on the next SEGSIZE boundary
 */

map(x)
int x;{

	register int t;
	if (nomap) return(x);
	if (offset == CORESTART && x > STACKTOP-stacksize)
		return((x & STACKTOP)-STACKTOP+fend-1);
	else if (shared){
		if (x > textsize){
			t = (textsize+SEGSIZE)/SEGSIZE*SEGSIZE;
			if (offset == CORESTART)
				return(x+CORESTART-t);
			else return(x+textsize+offset-t);
			}
		else if (offset == CORESTART && x >= 0)
			return(-(x+AOUTSTART));
		}
	return(x+offset);
	}

peek(x)
int x;{

	int r;

	r = 0;
	if (x < 0){
		if (namelist == NULL){
			error(0, "bad address map");
			return(0);
			}
		if (fseek(namelist, -x, 0) == -1)
			error(0, "seek error on %s", nmname);
		if (fread(&r, BPW, 1, namelist) == NULL)
			if (inpattern) {
			        quitread = 1;
			        error(0, "pattern not found");
			        }
			else error(0, "read error on %s", nmname);
		return(r);
		}
	if (trace) {
		pio(pid, READ, x, &r, BPW);
		return(r);
		}
	if (seek(fildes, x, 0) == -1)
		error(0, "seek error on %s", objname);
	if (read(fildes, &r, BPW) <= 0)
		if (inpattern) {
		        quitread = 1;
		        error(0, "pattern not found");
		        }
		else error(0, "read error on %s", nmname);
	return(r);
	}

poke(x, y)
int x, y;{

	if (prtlen > BPW) prtlen = BPW;
	if (y < 0){
		error(0, "Text segment is shared");
		return(-1);
		}
	if (trace) {
		pio(pid, WRITE, y, &x, prtlen);
		return;
		}
	if (seek(fildes, y, 0) == -1)
		error(0, "seek error on %s", objname);
	x <<= (8*(BPW-prtlen));
	if (x == 0)
		error(0, "print length is 0 - will write 0 bytes");
	if (write(fildes, &x, prtlen) < prtlen)
		error(0, "write error on %s", objname);
	}
