/*
 * header file for debugger
 */

#include <stdio.h>
#include <sys/pstate.h>
#include <a.out.h>
#include <errno.h>

#define NAMESIZE 8
#define SYMSIZ 4000
#define INFINITY 999999
#define MAXNARGS 20
#define MAXPATTERN 128
#define NUMINFIL 10
#define PROLOG 18               /* bytes compiled func. begins after prolog */
#define READ 0
#define WRITE 1
#define PRINST (prtmode=='i' || prtmode=='j')
#define ALL_LOCS (-10)          /* some no. which can't be a real loc   */

#define CNTRLCHAR       '%'             /* for patch file comment file  */
#define DATA            'D'             /* data keyletter               */
#define CMT             'C'             /* comment keyletter            */
#define INFO            'I'             /* information keyletter        */
#define MAXLINE         512

/*
 * implementation dependencies
 */

#define bPB 8
#define bPW 32
#define BPW 4
#define BPL 8
#define BPHW 2
#define CORESTART 4096		/* really size of user structure */
#define PAGESIZE 4096
#define STACKTOP 0xffffff
#define AOUTSTART 8*BPW
#define SEGSIZE 0x10000		/* text-shared round up boundary */

#define LOCAL 037

#define ILC ((state.ps_pgm >> 16)&017)		/* instruction length */

/*
 * storage classes
 */

#define GLOBL 0
#define AUTO 1
#define REGVAR 2
#define MOS 3
#define FUNC 4

#define ARRAY 3

/*
 * data structures
 */

struct symtab {
	char name[NAMESIZE];
	char sclass;
	char type;
	short size;
	int val;
	struct symtab *func;
	struct symtab *next;
	};

struct arrayelt {
	int arrayval;
	struct arrayelt *nexta;
	};

struct bp {
	int bp_addr;
	int bp_val;
	struct tnode *bp_cmd;
	char *bp_comment;
	struct bp *bp_next;
	};

struct longint {
	int high;
	int low;
	};

struct optab {
	int op_val;
	char *op_name;
	int op_type;
	};

struct systab {
	int sys_svcno;
	char *sys_name;
	};

struct tnode {
	int t_op;
	int t_val;
	struct tnode *t_left;
	struct tnode *t_right;
	};

struct mods {
	int loc;
	int initval;
	int currval;
	struct mods *nextm;
	struct mods *prevm;
	};

/*
 * 470 opcode structure
 */

struct op470 {
	int opcode : 8;
	int r1 : 4;
	int r2 : 4;
	int base1 : 4;
	int disp1 : 12;
	};

struct sop {
	int sopcode : 16;
	};

struct ssopend {
	int base2 : 4;
	int disp2 : 12;
	};

typedef struct symtab SYM;
typedef struct bp BP;
typedef struct pstate PSTATE;

extern int dot;
extern int dotdot;
extern int lastbp;
extern int yylval;
extern int offset;
extern int fend;
extern int stacksize;
extern int errflg;
extern int errno;
extern int xlate;
extern int prtlen;
extern int savplen;
extern int prtmode;
extern int instlen;
extern int nomap;
extern int shared;
extern int textsize;
extern int fildes;
extern int nsym;
extern int pid;
extern int dim;
extern int trace;
extern int argsflag;
extern int decl;
extern int inpattern;
extern int quitread;
extern char *objname;
extern char *nmname;
extern char *signame[];
extern char etatab[];
extern char pattern[MAXPATTERN];
extern SYM *hashp[];
extern SYM *valp[];
extern FILE *namelist;
extern FILE *out;
extern FILE *in;
extern FILE *infile[NUMINFIL];
extern int inindex;
extern PSTATE state;
extern BP *bptail;
extern struct optab op[];
extern struct systab sys[];
extern struct optab br[];
extern struct optab *oplookup(), *brlookup();

/*
 * instruction decoding stuff
 */

#define NUMOPS 183
#define NUMSYS 47
#define NUMBRS 30

#define RR 1
#define RX 2
#define RS1 3
#define RS2 4
#define S 5
#define SI1 6
#define SI2 7
#define SS1 8
#define SS2 9
#define SS3 10
#define BRANCH 11
#define BRANCHR 12
 
/*
 * some opcodes
 */
 
#define BC 0x47
#define BCR 0x07
#define SVC 0x0a
#define SPM 0x04
#define BALR 0x05
#define BAL 0x45
