/*
 * These algorithms are not the fastest or the most accurate.
 */

double  sin(x)
double  x;
{
	double  tot;            /* total value of sin so far */
	double  last_tot;       /* previous value of total */
	double  n;              /* summation running variable */
	double  term;           /* (x ** n) / n! */

	last_tot = tot = 0;
	n = 1;
	term = x;
	do {
		last_tot = tot;
		tot += term;
		term *= x * x /((n + 1) * (n + 2));
		n += 2;
		tot -= term;
		term *= x * x /((n + 1) * (n + 2));
		n += 2;
	} while (last_tot != tot);
	return (tot);
}

double  cos(x)
double  x;
{
	double  tot;            /* total value of sin so far */
	double  last_tot;       /* previous value of total */
	double  n;              /* summation running variable */
	double  term;           /* (x ** n)/ n! */

	last_tot = tot = 0;
	n = 0;
	term = 1;
	do {
		last_tot = tot;
		tot += term;
		term *= x * x / ((n + 1) * (n + 2));
		n += 2;
		tot -= term;
		term *= x * x / ((n + 1) * (n + 2));
		n += 2;
	} while (last_tot != tot);
	return (tot);
}

double  atan(x)
double  x;
{
	double  tot;            /* total value of sin so far */
	double  last_tot;       /* previous value of total */
	double  n;              /* summation running variable */
	double  term;           /* case 1: x ** n       */
                                /* case 2: 1 / (x ** n) */

	last_tot = tot = 0;
	if (x * x == 1)
		return(0.785398163397449);  /* pi/4 */
	if (x * x <= 1) {
	        n = 1;
	        term = x;
	        do {
		        last_tot = tot;
		        tot += term / n;
		        term *= x * x;
		        n += 2;
		        tot -= term / n;
		        term *= x * x;
		        n += 2;
	        } while (last_tot != tot);
	        return (tot);
	} else {
	        n = 1;
	        term = 1 / x;
	        do {
		        last_tot = tot;
		        tot -= term / n;
		        term /= x * x;
		        n += 2;
		        tot += term / n;
		        term /= x * x;
		        n += 2;
	        } while (last_tot != tot);
	        return (tot + 1.5707963);
	}
}

double  exp(x)
double  x;
{
	double  tot;            /* total value of sin so far */
	double  last_tot;       /* previous value of total */
	double  n;              /* summation running variable */
	double  term;           /* (x ** n) / n! */

	last_tot = tot = 0;
	n = 0;
	term = 1;
	do {
		last_tot = tot;
		tot += term;
		term *= x / (n + 1);
		n += 1;
	} while (last_tot != tot);
	return (tot);
}

double  log(x)
double  x;
{
	double  tot;            /* total value of sin so far */
	double  last_tot;       /* previous value of total */
	double  n;              /* summation running variable */
	double  y;              /* ((x - 1) / (x + 1)) */
	double  term;           /* ((x - 1) / (x + 1)) ** n */

	last_tot = tot = 0;
	n = 1;
	if ( x <= 0.0) {
		printf("log of %lg does not exist\n", x);
		return(0);
	}
	y = (x - 1) / (x + 1);
	term = y;
	do {
		last_tot = tot;
		tot += term / n;
		term *= y * y;
		n += 2;
	} while (last_tot != tot);
	return (tot * 2.0);
}
