/*  UNIX(R) Regular Expresssion Library
 *
 *  Note: Code is released under the GNU LGPL
 *
 *  Copyright (C) 2001 Caldera International, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to:
 *        Free Software Foundation, Inc.
 *        59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* stubbed-out routines needed to complete the RE libc code */

#include "colldata.h"

struct lc_collate *
_lc_collate(struct lc_collate *cp)
{
	static struct lc_collate curinfo = {0}; /* means CHF_ENCODED */

	return &curinfo;
}

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

int
pfmt(FILE *fp, long flags, const char *fmt, ...)
{
	va_list ap;
	int ret = -1;

	if ((fmt = strchr(fmt, ':')) == 0)
		return -1;
	if ((fmt = strchr(fmt+1, ':')) == 0)
		return -1;
	va_start(ap, fmt);
	if ((ret = vfprintf(fp, fmt+1, ap)) < 0)
		ret = -1;
	va_end(ap);
	return ret;
}
