/*===========================================================================
SOLAR v0.95.2 slrnews :: Module ..\slrnews\newsgrp.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

/* Include Files */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include "newsgrp.h"

/*
 * Function: int write_description(FILE *areas_file)
 * Purpose : Pull newsgroup description from file and add to areas file.
 * Return  : Zero on success, otherwise non-zero.
*/

int write_description(FILE *areas_file)
{
  FILE *desc_file = fopen(newsgroups_path,"rt");
  char descbuf[128];
  char description[128];
  int x = 0, y = 0;

  if (!desc_file) goto ErrorExit;
  strcpy(description,DEFAULT_DESCRIPTION);

  while (fgets(descbuf,128,desc_file) != NULL)
  {
    if (strnicmp(area_name,descbuf,strlen(area_name)) == 0)
    {
      x = 0;
      y = 0;
      while ((descbuf[x] != ' ') && (descbuf[x] != '\0') && (descbuf[x] != '\n')) x++;
      while ((descbuf[x] == ' ') && (descbuf[x] != '\0') && (descbuf[x] != '\n')) x++;
      while ((descbuf[x] != '\0') && (descbuf[x] != '\n'))
      {
        if (descbuf[x] == '\t')
        {
          description[y++] = ' ';
          x++;
        }
        else
        {
          description[y++] = descbuf[x++];
        }
      }
      break;
    }
  }
  description[y] = '\0';
  fprintf(areas_file,"\t%s",description);
  fclose(desc_file);

GoodExit:
  return 0;
ErrorExit:
  return 1;
}
