/*
Function: logit()
Purpose : Write contents of log buffer to log file with time stamp.
Return  : 0 on success, non-zero on error.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dir.h>

extern char log_path[MAXPATH];      /* From config.c         */
extern char _slrerr[80];            /* From config.c         */

char logbuf[128];

int logit(const char *facility)
{
  FILE *log_file = fopen(log_path,"at");
  char *get_tz();
  static char time_string[35];
  struct tm *time_now;
  time_t t;

  if (!log_file)
  {
    sprintf(_slrerr,"logit(): error opening %s for writing.",log_path);
    return -1;
  }

  time(&t);
  time_now = localtime(&t);

  if ((strftime(time_string,35,"%d-%b-%Y %H:%M:%S",time_now)) == 0)
  {
    sprintf(_slrerr,"logit(): error generating time string.");
    return -1;
  }
  fprintf(log_file,"%s %s: %s\n",time_string,facility,logbuf);
  fclose(log_file);
  return 0;
}
