/*===========================================================================
SOLAR :: ..\common\cvt2num.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

/* Header Files */
#include <string.h>   /* strcmp, stricmp */
#include <stdio.h>    /* fprintf         */
#include <stdlib.h>   /* atoi            */
#include "..\common\yesno.h"

#define ONCE                   2

enum SOUP_Types { u, M, m, n, C, c, i, b, B };  /* Supported types    */

/*
 * Function: int convert_to_number(char *argument)
 * Purpose : Convert alpha strings to internal numerical representations.
 * Return  : The number corresponding to the alpha string.
*/

int convert_to_number(char *argument)
{
  /* SOUP Format Types */
  if (strcmp(argument,"u") == 0)
    return u;
  if (strcmp(argument,"M") == 0)
    return M;
  if (strcmp(argument,"m") == 0)
    return m;
  if (strcmp(argument,"n") == 0)
    return n;
  if (strcmp(argument,"C") == 0)
    return C;
  if (strcmp(argument,"c") == 0)
    return c;
  if (strcmp(argument,"i") == 0)
    return i;
  if (strcmp(argument,"b") == 0)
    return b;
  if (strcmp(argument,"B") == 0)
    return B;

  /* Boolean Values */
  if (stricmp(argument,"YES") == 0)
    return YES;
  if (stricmp(argument,"NO") == 0)
    return NO;
  if (stricmp(argument,"ONCE") == 0)
    return ONCE;

  RPrintf("<warning> obsolete configuration value accepted: %s\n",argument);
  return atoi(argument);
}
