/*===========================================================================
SOLAR :: ..\common\batindex.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

/* Header Files */
#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

/* Global Data */
char batch_prefix[10];

/* External Data */
extern char user_path[MAXPATH];
extern char _slrerr[80];

/*
 * Function: get_batch_prefix()
 * Purpose : Read seqno.slr file in user's directory and place value in
 *           file scope storage. Also, re-write an incremented seqno in
 *           seqno.slr for use next time.
 * Return  : 0 on success, 1 on error.
*/

int get_batch_prefix()
{
  FILE  *seqno_file   = NULL;
  char  temp;
  char  seqno_path[MAXPATH];
  int   x     = 0;
  int   seqno = 1;

  strcpy(seqno_path, user_path);
  strcat(seqno_path, "\\SEQNO.SLR");
	if ((seqno_file = fopen(seqno_path, "rt")) == NULL)
	{
    strcpy(batch_prefix,"1");   /* Reset the prefix counter to 1 */
	}
	else
	{
		temp = fgetc(seqno_file);
		while (temp != '\n')
		{
      batch_prefix[x++] = temp;
			temp = fgetc(seqno_file);
		}
    batch_prefix[x] = '\0';
    seqno = atoi(batch_prefix);
    if (seqno > 32000) seqno = 0;
    fclose(seqno_file);
	}
	seqno++;
  if ((seqno_file = fopen(seqno_path, "wt")) == NULL)
  {
    sprintf(_slrerr,"get_batch_prefix(): error opening %s",seqno_path);
    goto ErrorExit;
  }
	fprintf(seqno_file, "%i\n", seqno);
	fclose(seqno_file);
GoodExit:
  return 0;
ErrorExit:
  return 1;
}
