#include <stdio.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>

#define MAXFILENAME 999
extern int verbose;

findmax(basename)
char *basename;
{
   char *filename;
   int i;
   struct stat sbuf;
   
   filename = (char *)calloc(strlen(basename)+4, sizeof(char));
   if (filename == NULL) {
      fprintf(stderr,"explode: findmax - out of memory\n");
      return(-1);
      }
   for (i=1 ; i < MAXFILENAME ; i++) {
      sprintf(filename,"%s.%d", basename, i);
      if (verbose) { printf("looking for %s\r", filename); }
      if (stat(filename,&sbuf) != 0) { break; }
      }
   free(filename);
   return(i);
}
