; EBC2ASC.ASM -- Program to convert an EBCDI file to ASCII

; Usage -- EBC2ASC < input filespec > output filespec

; From PC Mag 10-1-85 ASC2EBC.ASM.
;v1.1	Toad Hall Tweak
;	Using EBCDIC table from EBCDIC.PAS
;	David Kirschbaum, Toad Hall
;	kirsch@usasoc.soc.mil

CSEG	Segment
	Assume  CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG
	Org	0100h
Entry:	jmp	Begin


Table	db	000,001,002,003,	032,009,032,127	;0..7
	db	032,032,032,011,	012,013,014,015	;8..0FH
	db	016,017,018,018,	032,032,008,032	;10H..17H
	db	024,025,032,032,	032,032,032,032	;18H..1FH
	db	032,032,028,032,	032,010,023,027	;20H..27H
	db	032,032,032,032,	032,005,006,007	;28H..2FH
	db	032,032,022,032,	032,030,032,004	;30H..37H
	db	032,032,032,032,	020,021,032,032	;38H..3FH
	db	032,032,032,032,	032,032,032,032	;40H..47H
	db	032,032,155,046,	060,040,043,032	;48H..4FH
	db	038,032,032,032,	032,032,032,032	;50H..57H
	db	032,032,033,036,	042,041,059,191	;58H..5FH
	db	045,047,032,032,	032,032,032,032	;60H..67H
	db	032,032,124,044,	037,095,062,063	;68H..6FH
	db	032,032,032,032,	032,032,032,032	;70H..77H
	db	032,032,058,035,	064,039,061,034	;78H..7FH
	db	032,097,098,099,	100,101,102,103	;80H..87H
	db	104,105,032,032,	032,032,032,032	;88..8FH
	db	032,106,107,108,	109,110,111,112	;91H..97H
	db	113,114,032,032,	032,032,032,032	;98H..9FH
	db	032,126,115,116,	117,118,119,120	;A0H..A7H
	db	121,122,032,032,	032,032,032,032	;A8H..AFH
	db	032,032,032,032,	032,032,032,032	;B0H..B7H
	db	032,032,032,032,	032,032,032,032	;B8H..BFH
	db	123,065,066,067,	068,069,070,071	;C0H..C7H
	db	072,073,032,032,	032,032,032,032	;C8H..CFH
	db	125,074,075,076,	077,078,079,080	;D0H..D7H
	db	081,082,032,032,	032,032,032,032	;D8H..DFH
	db	092,032,083,084,	085,086,087,088	;E0H..E7H
	db	089,090,032,032,	032,032,032,032	;E8H..EFH
	db	048,049,050,051,	052,053,054,055	;F0H..F7H
	db	056,057,032,032,	032,032,032,032	;F8H..FFH

Begin:	cld				; Direction Forward
	mov	DX,Offset EndProg	; Beyone end of program
	mov	CX,SP			; Top of segment
	sub	CX,100h			; Leave foom for stack
	sub	CX,DX			; Number of bytes for buffer

MainLoop:
	xor	bx,bx			; Standard Input		v1.1
	mov	AH,3Fh			; Read Function Call
	int	21h			; Call DOS
	jc	Exit			; Exit if error

	push	CX			; Save requested read bytes
	mov	CX,AX			; Get bytes read
	jcxz	Exit			; Exit if no bytes read

	mov	BX,Offset Table		; Conversion Table
	mov	SI,Offset EndProg	; Beginning of Data
	mov	DI,SI			; Destination is same
	push	CX			; Save bytes actually read

Conversion:
	lodsb				; Get byte
	xlat	Table			; Convert it
	stosb				; Save byte
	loop	Conversion		; For all data

	pop	CX			; Get back bytes read
	mov	BX,1			; Standard Output Handle
	mov	AH,40h			; Write Function Call
	int	21h			; Call DOS
	jc	Exit			; Exit if error

	cmp	AX,CX			; See if all bytes written
	jb	Exit			; Exit if disk is full

	pop	CX			; Get back bytes to read
	jmp	MainLoop		; Do next read

Exit:	int	20h			; Terminate Program

EndProg	Label	Byte			; Buffer Area
CSEG	EndS
	End	Entry
