/******
 * megasort
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

#include "openfile.acf"


void CleanUp(int N)
   {
   int I;
   char S[80];
   for (I=0; I<=N; I++)
      {
      sprintf(S, "mega1.%03d", I);
      unlink(S);
      sprintf(S, "mega2.%03d", I);
      unlink(S);
      }
   unlink("mega3.in");
   unlink("mega3.out");
   }


int SplitFile(char * FileName)
   {
   int C;
   unsigned int I, Count;
   FILE * InFp, *OutFp;
   char OutFileName[80];

   printf("\nSplitting %s into files: ", FileName);

   I= Count= 0;

   /* open input file */
   InFp = OpenFile(FileName, "rt");

   do
      {
      /* make a new output file name */
      sprintf(OutFileName,"mega1.%03d", I);

      /* open new output file */
      OutFp = OpenFile(OutFileName, "w+");

      printf(" %d", I);

      /* read 20.000 character from input to output,
	 then stop at the first '\n' */

      Count = 0;
      while((C=getc(InFp)) != EOF)
	 {
	 putc(C, OutFp);
	 Count++;
	 if ((Count > 20000L) && (C == '\n'))
	    {
	    fclose(OutFp);
	    Count = 0;
	    break;
	    }
	 }
      I++;
      }
   while (C != EOF);

   fclose(OutFp);
   fclose(InFp);

   return I;
   }


int DosSort(int N)
   {
   int I, Status;
   char Command[80];

   printf("\nUsing DOS SORT to sort files: ");

   for (I=0; I<N; I++)
      {
      printf(" %d", I);
      sprintf(Command,"sort < mega1.%03d > mega2.%03d", I, I);

      Status= system(Command);

      if (Status < 0)
	 {
	 printf("\nDOS SORT call failed with file mega2.%03d.",
		I);
	 printf("\nDOS error was: \"%d - %s\"",
		errno,
		sys_errlist[errno]);
	 printf("\nAttempting to clean up the mess and exit in grace.\n");
	 CleanUp(N);
	 exit(3);
	 }

      sprintf(Command,"mega1.%03d", I);

      if (! Status) unlink(Command);
      }
   return Status;
   }

void MergeSort(int N)
   {
   char S1[2048], S2[2048];
   char InFile2[40], Command[80];
   int I, Comp;
   char X1, X2;
   FILE * In1, * In2, * Out;

   printf("\n\nDeleting a temporary file: ");
   system("del mega3.in");

   printf("\nPreparing to merge files: ");

   system("ren mega2.000 mega3.in");	/* infile 1 */

   printf("\nMerging files: 0");

   for (I=1; I< N; I++)
      {
      printf(" %d", I);

      In1 = OpenFile("mega3.in", "rt");

      sprintf(InFile2,"mega2.%03d", I);
      In2 = OpenFile(InFile2, "rt");

      Out = OpenFile("mega3.out", "a");


      X1= (char) fgets(S1, 2048, In1);
      X2= (char) fgets(S2, 2048, In2);

      while ((X1 != NULL) || (X2 != NULL))
	 {
	 if (X1 == NULL)
	    {
	    fclose(In1);
	    fputs(S2, Out);
	    while(X2= (char) fgets(S2, 2048, In2) != NULL) fputs(S2, Out);
	    fclose(In2);
	    fclose(Out);
	    break;
	    }

	 if (X2 == NULL)
	    {
	    fclose(In2);
	    fputs(S1, Out);
	    while(X1= (char) fgets(S1, 2048, In1) != NULL) fputs(S1, Out);
	    fclose(In1);
	    fclose(Out);
	    break;
	    }

	 Comp=strcmp(S1, S2);

	 if (Comp < 0)
	    {
	    fputs(S1, Out);
	    X1= (char) fgets(S1, 2048, In1);
	    continue;
	    }

	 if (Comp == 0)
	    {
	    fputs(S1, Out);
	    X1= (char) fgets(S1, 2048, In1);
	    fputs(S2, Out);
	    X2= (char) fgets(S2, 2048, In2);
	    continue;
	    }

	 if (Comp > 0)
	    {
	    fputs(S2, Out);
	    X2= (char) fgets(S2, 2048, In2);
	    continue;
	    }
	 } /* end while */

      sprintf(Command, "del mega2.%03d", I);
      system(Command);

      system("del mega3.in");
      system("ren mega3.out mega3.in");
      } /* end for */

   system("del megasort.out");
   system("ren mega3.in megasort.out");

   return;
   }


int main(int argc, char ** argv)
   {
   int MaxFile;
   char	FileName[50];

   if (argc < 1)
      {
      puts("Sorts \(merge sort\)big files. Disk intensive.");
      puts("Requires twice the space of the initial file.");
      puts("Use: MEGASORT filename");
      exit(1);
      }

   if (getenv("COMSPEC") == NULL)
      {
      puts("You must set up the COMSPEC environment variable");
      puts("for this program to work. Example:");
      puts("SET COMSPEC=c:\\dos\\command.com");
      exit(1);
      }

   strcpy(FileName, argv[1]);

   /* 1. Split the file in small chunks */

   MaxFile = SplitFile(FileName); /* initial file name   */
	   /* MaxFile is highest extension #
	    * for resulting files */

   if (MaxFile < 2)
      {
      puts("Files created were less than two. Exiting.");
      exit(2);
      }

   printf("\nSplit done into %d files.\n", MaxFile);

   /* 2. Call SORT or use qsort to sort the minifiles */

   DosSort(MaxFile);

   /* 3. Merge-sort the minifiles in pairs */

   MergeSort(MaxFile);

   puts("\n\nDone.");

   return 0;
   }
