NAME
        cmp -- compare two files byte-by-byte.

SYNOPSIS
        cmp [-cls] file1 [file2]

DESCRIPTION
        With no options, cmp compares two files, and if they differ,
        reports the first byte and line number where they differ,
        or that one file is an initial subsequence of the other.
        The file name "-" is always the standard input.  cmp also
        uses the standard input if one file name is omitted.
        An exit status of 0 means no differences were found,
        1 means some differences were found, and 2 means trouble
        (inaccessible or missing file, or system error).

OPTIONS
        Most options have two equivalent names, one of which is
        a single letter preceded by "-", and the other of which
        is a long name preceded by "--".  Multiple single letter
        options (unless they take an argument) can be combined into
        a single command line word: -cl is equivalent to -c -l.

    -c, --print-chars
        Print the differing characters.  Display control characters
        as a ^ followed by a letter of the alphabet and precede
        characters that have the high bit set with M- (which stands
        for ``meta'').

    -l, --verbose
        Print the (decimal) offsets and (octal) values of all
        differing bytes.

    -s, --silent, --quiet
        Do not print anything; only return an exit status
        indicating whether the files differ.

SEE ALSO
	comm(1), diff(1)

NOTES
     1. GNU cmp does not support initial byte offsets into the files.
     2. For more information see ``Comparing and Merging Files''
        by D MacKenzie, P Eggart, and R Stallman.  This manual page
        is derived from section 11 (Invoking cmp) of edition 1.1 for
        diff 2.1 and associated programs (January 1983).
