Program fold;
{ Unix-fold-lookalike: inserts CR/LF after each <n> bytes                    }
{ Optionally removes all CR/LFs already in the file                          }
{ For usage hints, type fold ?                                               }
{ Free Software by TapirSoft Gisbert W.Selke, Apr 1991                       }
{$A+,B-,D+,E+,F-,I-,L+,N-,O-,R-,S-,V- }
{$M 65520,0,16384 }

  Uses Dos;

  Const progname = 'FOLD';
        version  = '1.0';
        copyright = 'Free Software by TapirSoft Gisbert W.Selke, Apr 1991';
        bufsize = 64000;
        LF      = 10;
        CR      = 13;
        crlf : Array [1..2] Of byte = (CR, LF);

  Type iobuffer = Array [1..bufsize] Of byte;

  Var inf, outf : File;
      inbuffer : iobuffer;
      linlen : longint;
      iread, i, k, offset, start : word;
      zstrip : boolean;

  Procedure writerr(s : string);
  { display a string on StdErr                                               }
    Var regs : Registers;
  Begin                                                            { writerr }
    Move(crlf,s[Succ(Length(s))],SizeOf(crlf));
    With regs Do
    Begin
      ah := $40;
      bx := 2;
      cx := Length(s) + SizeOf(crlf);
      ds := Seg(s[1]);
      dx := Ofs(s[1]);
    End;
    MsDos(regs);
  End;                                                             { writerr }

  Procedure abort(errmsg : string; errcode : byte);
  { display error message and die with error code                            }
  Begin                                                              { abort }
    If errmsg <> '' Then writerr(progname+' '+version+': '+errmsg);
    Halt(errcode);
  End;                                                               { abort }

  Procedure usage;
  { show usage info and die                                                  }
    Var temp : string;
  Begin                                                              { usage }
    writerr(progname+' '+version);
    writerr('Filter to fold text file into CR/LF-terminated lines of '+
            'specified length');
    writerr(copyright);
    writerr('');
    writerr('Usage: '+progname+'  [linelength]  [/s]  < infilename  > '+
            'outfilename');
    writerr('');
    Str(bufsize,temp);
    writerr('linelenth must be <= '+temp+'; default is 256. If /s is '+
            'specified,');
    writerr('all CRs and LFs that may already be contained in the file '+
            'are stripped.');
    Halt(1);
  End;                                                               { usage }

  Procedure getargs;
  { process command line                                                     }
    Var temp : string;
        ival : longint;
        icode : integer;
        i : byte;
  Begin                                                            { getargs }
    zstrip := False;
    linlen := 0;
    For i := 1 To ParamCount Do
    Begin
      temp := ParamStr(i);
      If Length(temp) < 2 Then usage;
      If (Length(temp) = 2) And (temp[1] In ['-','/']) Then
      Begin
        If UpCase(temp[2]) = 'S' Then zstrip := True
                                 Else usage;
      End
      Else
      Begin
        If linlen <> 0 Then usage;
        Val(temp,ival,icode);
        If (icode = 0) And (ival > 0) And (ival <= bufsize) Then linlen := ival
                                                            Else usage;
      End;
    End;
    If linlen = 0 Then linlen := 256;
  End;                                                             { getargs }

Begin                                                                 { main }
  getargs;
  i := FileMode;
  FileMode := 0;
  Assign(inf,'');
  Reset(inf,1);
  FileMode := i;
  Assign(outf,'');
  Rewrite(outf,1);
  offset := 1;
  While Not EoF(inf) Do
  Begin
    BlockRead(inf,inbuffer[offset],bufsize-offset+1,iread);
    If IOResult <> 0 Then abort('Error while reading',2);
    iread := iread + offset - 1;
    If zstrip Then
    Begin
      k := 0;
      For i := 1 To iread Do
      Begin
        If (inbuffer[i] <> CR) And (inbuffer[i] <> LF) Then
        Begin
          Inc(k);
          inbuffer[k] := inbuffer[i];
        End;
      End;
      iread := k;
    End;
    start := 1;
    While start+linlen-1 <= iread Do
    Begin
      BlockWrite(outf,inbuffer[start],linlen,i);
      BlockWrite(outf,crlf,2,k);
      If IOResult <> 0 Then abort('Error while writing',3);
      start := start + i;
    End;
    offset := iread - start + 2;
    Move(inbuffer[start],inbuffer[1],Pred(offset));
  End;
  If offset <> 1 Then
  Begin
    BlockWrite(outf,inbuffer,offset-1,i);
    BlockWrite(outf,crlf,2,k);
    If IOResult <> 0 Then abort('Error while writing',3);
  End;
  Close(inf);
  Close(outf);
End.
