/*
 * gnu2src -- convert GNU format "yow.lines" file to fortune(6) *.src format
 *
 * gnu2src converts Zippy the Pinhead sayings from GNU format (ASCII NULL
 * between sayings, to fortune(6) *.src file format (single lines of %%
 * between sayings.  Optionally it will append the author signature
 * "-- Zippy the Pinhead" for incorporation into the fortunes.dat file.
 *
 * usage: gnu2src [-d] [-i] [-a] [in_file] [out_file]
 *
 * -d	issue debugging information
 *
 * -i	issue usage and copyright information
 *
 * -a	append "-- Zippy the Pinhead" after each saying
 */

char *Copyright_Legend[] = {
 " Written by Paul Pomes, University of Illinois, Computing Services Office",
 " Copyright (C) 1987 by Paul Pomes and the University of Illinois Board",
 " of Trustees",
 " ",
 " This program is distributed in the hope that it will be useful,",
 " but without any warranty.  No author or distributor accepts",
 " responsibility to anyone for the consequences of using it or for",
 " whether it serves any particular purpose or works at all, unless",
 " s/he says so in writing.",
 " ",
 " Everyone is granted permission to copy, modify and redistribute",
 " this program under the following conditions:",
 " ",
 "    Permission is granted to anyone to make or distribute copies",
 "    of program source code, either as received or modified, in any",
 "    medium, provided that all copyright notices, permission and",
 "    nonwarranty notices are preserved, and that the distributor",
 "    grants the recipient permission for further redistribution as",
 "    permitted by this document, and gives him and points out to",
 "    him an exact copy of this document to inform him of his rights.",
 " ",
 "    Permission is granted to distribute this program in compiled",
 "    or executable form under the same conditions applying for",
 "    source code, provided that either",
 "    A. it is accompanied by the corresponding machine-readable",
 "       source code, or",
 "    B. it is accompanied by a written offer, with no time limit,",
 "       to give anyone a machine-readable copy of the corresponding",
 "       source code in return for reimbursement of the cost of",
 "       distribution.  This written offer must permit verbatim",
 "       duplication by anyone.",
 "    C. it is distributed by someone who received only the",
 "       executable form, and is accompanied by a copy of the",
 "       written offer of source code which he received along with it.",
 " ",
 " In other words, you are welcome to use, share and improve this",
 " program.  You are forbidden to forbid anyone else to use, share",
 " and improve what you give them.   Help stamp out software-hoarding!",
 " ",
 " UUCP:     {ihnp4,seismo,pur-ee,convex}!uiucdcs!uiucuxc!paul",
 " Internet: paul@uxc.cso.uiuc.edu   BITNET: paul@uiucuxc",
 " MILNET:   paul@uiucuxc.arpa       CSNET:  paul%uxc@uiuc.csnet",
 " US Mail:  Univ of Illinois, CSO, 1304 W Springfield Ave, Urbana, IL  61801",
 0
};

/*
 * $Log$
 */

#ifndef lint
static char	RcsId[] = "@(#)$Header$";
#endif

#include	<stdio.h>
#include	<strings.h>

#define		equal(s1, s2)	(strcmp (s1, s2) == 0)
#define		skipline(f)	while (getc (f) != '\n')

#define		PROC				/* null; easy to find procs */
#define		FALSE		0
#define		TRUE		1
#define		CHNULL		('\0')
#define		CPNULL		((char *) NULL)
#define		FILENULL	((FILE *) NULL)
#define		REG		register
#define		BMASK		0377

#define		INTV		5

/*
 * Miscellaneous global values:
 */

char *usage[] = {
	"usage: %s [-d] [-i] [-n interval] [in_file] [out_file]",
	CPNULL,
};

/* how program was invoked (argv[0]) for error messages */
char		*myname;

/* debug messages printed if set (-d) */
int		dflag = FALSE;

/* append author statement if set (-a) */
int		aflag = FALSE;

PROC main (argc, argv)
int	argc;
char	**argv;
{
	extern int	optind;			/* from getopt () */
	extern char	*optarg;		/* from getopt () */
	int		option;			/* option "letter" */
	int		i, j, k;		/* counters */
	char		*ifname, *ofname;	/* name to use */

	/*
	 * BASENAME:  Full string, or past '/' if any:
	 */

	myname = ((myname = rindex (*argv, '/')) == CPNULL) ? *argv : (myname + 1);

	/*
	 * PARSE ARGUMENTS:
	 */

	while ((option = getopt (argc, argv, "dia")) != EOF) {
		switch (option) {
		    case 'd':
			dflag++;
			fprintf (stderr, "%s: dflag = %d\n", myname, dflag);
			break;

		    case 'a':
			aflag++;
			break;

		    case 'i':
			Usage (1);
			break;

		    default:
			Usage (0);
		}
	}
	argc -= optind;			/* skip options */
	argv += optind;

	/*
	 * READ FROM LIST OF FILES OR STDIN:
	 */

	if (argc >= 1) {		/* read from file, write to stdout */
		ifname = *argv;
		if (freopen (ifname, "r", stdin) == FILENULL)
			Error ("can't open file \"%s\" to read it", ifname);
		argc--; argv++;
	}
	if (argc >= 1) {		/* read from file, write to stdout */
		ofname = *argv;
		if (freopen (ofname, "w", stdout) == FILENULL)
			Error ("can't open file \"%s\" to write it", ofname);
		argc--; argv++;
	}

	/*
	 * Read through the input file replacing each instance of \0 with
	 * \n, the signature string if aflag is set, and %%\n
	 */
	
	while ((i = getchar()) != EOF) {
		if (i != '\0')
			putchar(i);
		else {
			if ((i = getchar ()) != EOF && i != '\n')
				ungetc (i, stdin);
			if (aflag)
				printf ("\n				-- Zippy the Pinhead\n%%%%\n");
			else
				printf ("\n%%%%\n");
		}
	}

	/*
	 * FINISH UP:
	 */
	 exit (0);
} /* main */

/*
 * Usage -- print how to use message
 *
 * Print usage messages (char *usage[]) to stderr and exit nonzero.
 * Each message is followed by a newline.
 *
 *	parameters:
 *		full_text	(IN)	prints the copyright statement if set
 *	returns:
 *		none, exit (1)
 *	side effects:
 *		program terminates
 *	deficiencies:
 */

PROC Usage (full_text)
int	full_text;
{
	REG int		which = 0;		/* current line */

	while (usage[which] != CPNULL) {
		fprintf (stderr, usage[which++], myname);
		putc ('\n', stderr);
	}
	fflush (stdout);
	which = 0;
	if (full_text) {
		while (Copyright_Legend[which] != CPNULL)
			printf ("%s\n", Copyright_Legend[which++]);
	}
	exit (1);
} /* Usage */

/*
 * Error -- print error message with program name
 *
 * Print an error message to stderr and exit nonzero.  Message is preceded
 * by "<myname>: " using global char *myname, and followed by a newline.
 *
 *	parameters:
 *		message (IN)	printf format string
 *		arg1-4	(IN)	printf arguments
 *	returns:
 *		none, exit (1)
 *	side effects:
 *		program terminates
 *	deficiencies:
 */

/* VARARGS */
PROC Error (message, arg1, arg2, arg3, arg4)
char	*message;
long	arg1, arg2, arg3, arg4;
{
	fprintf (stderr, "%s: ", myname);
	fprintf (stderr, message, arg1, arg2, arg3, arg4);
	putc ('\n', stderr);
	exit (1);
} /* Error */

/*
 * Malloc -- a malloc with error checking
 *
 *	parameters:
 *		size	(IN)	number of bytes to get
 *	returns:
 *		(char *) of first char of block, or
 *		calls Error() upon error
 *	side effects:
 *		none
 *	deficiencies:
 */

char	*malloc ();
char	*Malloc ();

PROC char * Malloc (size)
unsigned	size;	/* bytes to get */
{
	char	*cp;	/* pointer to memory */

	if ((cp = malloc (size)) == CPNULL)
	    Error ("malloc %d bytes failed", size);
	return (cp);
} /* Malloc */
