PAGE 55,130
;			        UNIQ
;
;
 
codeseg		segment
		assume	cs:codeseg, ds:codeseg
 
 
		org	100h
 
uniq		proc	far
 
start:		jmp	short Main

in_count	dw	0		; store char counts
out_count	dw	0

Main:		call	get_line	; input a line of chars
		jc	Exit		; exit cf=1 on error
		call	copy_line	; copy line to hold

Main_1:		call	get_line	; input another line
		jc	Main_2		; quit if error or eof
		call	compare		; else compare the lines
		jz	Main_1		; if lines are eq, skip output
		call	put_line	; lines not eq, output line
		call	copy_line	; copy line for next compare
		jmp	short Main_1	; repeat until error or eof

Main_2:		call	put_line	; output last line.
Exit:		int	020h		; program termination
 
uniq		endp
 

;		SUBROUTINE
;		compare the current and previous lines
 
compare		proc	near
		mov	si,offset in_buffer	; reset si
		mov	di,offset hold_buffer	; set di
		mov	cx,in_count		; input char count in cx
		cmp	cx,out_count		; compare with out char count
		jne	comp_ret		; if not eq, return
		cld				; set direction
		repe	cmpsb			; compare until zf=0 or cx=0
comp_ret:	ret				; zf=1 if lines identical

compare		endp
 
 
;			       SUBROUTINE
;
 
copy_line	proc	near
		mov	si,offset in_buffer	; move chars from in to hold
		mov	di,offset hold_buffer
		mov	cx,in_count		; char count
		mov	out_count,cx
		cld				; set direction
		rep	movsb			; copy it (until cx=0)
		ret
copy_line	endp
 
 
;
;			       SUBROUTINE
;
 
put_line	proc	near
		mov	si,offset hold_buffer	; output from hold
		mov	dx,si			; point dx to hold_buffer
		mov	cx,out_count		; put char count in cx
		mov	bx,1			; std output
		mov	ah,40h
		int	21h
		ret				; cf=1 if error

put_line	endp
 

;			       SUBROUTINE
;
 
get_line	proc	near
		mov	si,offset in_buffer	; point si
		mov	in_count,0		; set input count to 0
in_put:		clc
		mov	dx,si			; point dx
		mov	cx,1			; input 1 char from
		mov	bx,0			; std input
		mov	ah,03Fh
		int	021h
		jc	get_line_ret		; error ocurred
		inc	in_count		; add 1 to char count
		cmp	byte ptr [si],0Ah	; eoln, exit cf=0
		je	get_line_ret
		or	ax,ax
		stc
		jz	get_line_ret		; 0 char input, exit cf=1
		cmp	byte ptr [si],1Ah	; eof, exit cf=1
		stc
		jz	get_line_ret
		inc	si			; incr for next char
		cmp	si,offset hold_buffer	; check for overrun
		stc
		jge	get_line_ret		; exit cf=1 if overrun
		jmp	short in_put
get_line_ret:	ret

get_line	endp
 

in_buffer	db	256 dup (0)	; input line buffer.
hold_buffer	db	0		; run off end of program.
 

codeseg		ends
 
		end	start

