{$G+,E-,S-}
Program Test;
Uses Crt, XGraph, XFonts;

var
    Ibuf:array[0..1535] of Byte;

procedure OutCentered(S:String);
begin
    SetWin(0, 0, 319, 239);
    SetFont8x8; SetColor($FF);
    OutStr(160 - (Length(S) * 4), 0, S);
    SetWin(0, 10, 319, 239);
end;

procedure Adjust(X1, Y1, X2, Y2, X, Y:Integer);
var
    C, D:Integer;
begin
    D := ((X2 - X1) + (Y2 - Y1)) * 3;
    C := (GetPixel(X1, Y1) + GetPixel(X2, Y2)) div 2;
    C := C + Random(D) - (D div 2);
    if C < 1 then C := 1; if C > 254 then C := 254;
    if GetPixel(X, Y) = 0 then PutPixelC(X, Y, C);
end;

procedure PlasmaX(X1, Y1, X2, Y2:Integer);
var
    X, Y:Integer;
begin
    if (X2 - X1 > 1) or (Y2 - Y1 > 1) then begin
        X := (X1 + X2) div 2; Y := (Y1 + Y2) div 2;
        Adjust(X1, Y1, X2, Y1, X, Y1);
        Adjust(X1, Y2, X2, Y2, X, Y2);
        Adjust(X1, Y1, X1, Y2, X1, Y);
        Adjust(X2, Y1, X2, Y2, X2, Y);

        if GetPixel(X, Y) = 0 then begin
            PutPixelC(X, Y, (GetPixel(X1, Y1) + GetPixel(X2, Y2) +
                             GetPixel(X1, Y2) + GetPixel(X2, Y1)) div 4);
        end;

        PlasmaX(X1, Y1, X, Y);
        PlasmaX(X, Y1, X2, Y);
        PlasmaX(X, Y, X2, Y2);
        PlasmaX(X1, Y, X, Y2);
    end;
end;

procedure Plasma;
var
    I, J, C:Integer;
begin
    for I := 0 to 63 do begin
        J := 63 - I;
        Ibuf[I*3 +   0] :=63; Ibuf[I*3 +   1] := I; Ibuf[I*3 +   2] := 0;
        Ibuf[I*3 + 192] := J; Ibuf[I*3 + 193] := J; Ibuf[I*3 + 194] := I;
        Ibuf[I*3 + 384] := 0; Ibuf[I*3 + 385] := I; Ibuf[I*3 + 386] := J;
        Ibuf[I*3 + 576] := I; Ibuf[I*3 + 577] := J; Ibuf[I*3 + 578] := 0;
    end;

    for I := 0 to 761 do Ibuf[I] := Ibuf[I + 3];
    for I := 0 to 761 do Ibuf[I + 762] := Ibuf[I];
    SetPals(1, 254, Ibuf);

    PutPixelC(  0,  10, Random(254) + 1);
    PutPixelC(  0, 239, Random(254) + 1);
    PutPixelC(319,  10, Random(254) + 1);
    PutPixelC(319, 239, Random(254) + 1);

    PlasmaX(0, 10, 319, 239);

    I := 0;
    while not KeyPressed do begin
        I := (I + 3) mod 762;
        SetPals(1, 254, Ibuf[I]);
    end;

    SetPage(0);
end;

{--------------------------------------------------------------------}

var
    I, J, X, Y, B:Integer;
    Str1, Str2:String;
begin
    InitGraph;
    Randomize;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  (colors)');

    for I := 0 to 32 do begin
        for J := 0 to 7 do begin
            X := J shl 5 + I;
            SetColor(X);
            FRect(I * 10, J * 28 + 13, I * 10 + 9, J * 28 + 40);
        end;
    end;

    while not KeyPressed do;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  PutPixel');
    while not KeyPressed do begin
        for I := 1 to 100 do begin
            PutPixelC(Random(320), Random(240), Random(256));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  Line');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            Line(Random(320), Random(240),
                 Random(320), Random(240));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  Rect');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            Rect(Random(320), Random(240),
                 Random(320), Random(240));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  FRect');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            FRect(Random(320), Random(240),
                 Random(320), Random(240));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  Circle');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            Circle(Random(320), Random(240), Random(50));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  FCircle');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            FCircle(Random(320), Random(240), Random(50));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  OutStr');
    while not KeyPressed do begin
        for I := 1 to 20 do begin
            SetColor(Random(256));
            OutStr(Random(192), Random(232), 'This is a string');
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  OutStr/SetFont');
    SetColor($34);

    SetFont(Font5x6);
    OutStr(20, 20, 'This is the 5x6 font:');
    OutStr(20, 26, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 32, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font5x8);
    OutStr(20, 42, 'This is the 5x8 font:');
    OutStr(20, 50, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 58, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font6x8);
    OutStr(20, 70, 'This is the 6x8 font:');
    OutStr(20, 78, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 86, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font7x8);
    OutStr(20, 98, 'This is the 7x8 font:');
    OutStr(20, 106, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 114, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font8x8);
    OutStr(20, 126, 'This is the 8x8 font:');
    OutStr(20, 134, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 142, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font7x12);
    OutStr(20, 154, 'This is the 7x12 font:');
    OutStr(20, 166, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 178, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');
    SetFont(Font8x12);
    OutStr(20, 194, 'This is the 8x12 font:');
    OutStr(20, 206, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789');
    OutStr(20, 218, 'abcdefghijklmnopqrstuvwxyz+-*/(){}?!');

    while not KeyPressed do;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  OutBigStr');
    SetColor($34);

    SetFont(Font7x12);
    OutBigStr(0, 20, 'This is a string of text at 1x2', 1, 2, 0);
    OutBigStr(0, 44, 'This string is at 2x2', 2, 2, 0);
    OutBigStr(0, 68, 'This string is at 2x3', 2, 3, 0);
    OutBigStr(0, 104, 'This string is at 2x4', 2, 4, 1);
    OutBigStr(0, 152, 'This is at 3x3', 3, 3, 1);
    OutBigStr(0, 188, 'This is at 3x4', 3, 4, 1);

    while not KeyPressed do;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  SetPals');

    Plasma; ResetPals;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  GetImage/PutImage');

    SetColor($34); FRect(10, 10, 53, 25);
    SetColor($03); Rect(10, 10, 53, 25);
    SetFont(Font8x12); SetColor($0C);
    OutStr(12, 12, 'Image');
    GetImage(Ibuf, 10, 10, 53, 25);

    while not KeyPressed do begin
        for I := 1 to 20 do begin
            PutImage(Ibuf, Random(276), Random(224));
        end;
    end;

    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  PutSprite');

    SetColor($34); FCircle(25, 25, 15);
    SetColor($03); Circle(25, 25, 15);
    SetFont(Font5x8); SetColor($0C);
    OutStr(11, 22, 'Sprite');
    GetImage(Ibuf, 10, 10, 40, 40);

    while not KeyPressed do begin
        for I := 1 to 20 do begin
            PutSprite(Ibuf, Random(290), Random(210));
        end;
    end;


    while KeyPressed do ReadKey; Cls;
    OutCentered('XGRAPH Demo:  Mouse');

    SetColor($2A);
    FRect(130, 100, 190, 160);

    SetColor($15);
    FRect(130, 70, 156, 92);
    FRect(164, 70, 190, 92);

    if InitMouse then begin
        ShowMouse;
    
        while not KeyPressed do begin
            B := GetMouse(X, Y);
    
            if (X >= 99) and (X <= 209) and
               (Y >= 55) and (Y <= 177) then HideMouse;

            if B mod 2 = 1 then SetColor($3F) else SetColor($15);
            FRect(130, 70, 156, 92);
    
            if B mod 4 > 1 then SetColor($3F) else SetColor($15);
            FRect(164, 70, 190, 92);
    
            SetColor($3F);
            Str(X:4, Str1); Str(Y:4, Str2);
            OutSolidStr(114, 170, '(' + Str1 + ', ' + Str2 + ')');
    
            ShowMouse;
            Delay(60);
        end;
    
        HideMouse;
        CloseMouse;
    end;

    while KeyPressed do ReadKey;
    CloseGraph;
end.
