unit Bitmap;

{ Unit Bitmap, Copr. 1994 Matthias Kppe

  Translate a device-independent bitmap, loaded by LoadBitmap or
  LoadBitmapFile, into an image, which can be drawn by PutImage.

  Supported are 16-color video modes, and monochrome and 16-color
  bitmaps. Monochrome bitmaps use ForeColor and BakColor.

  Instead of Graph's PutImage procedure, we recommend using the
  one implemented in our VgaMem unit: It performs correct clipping.
}

interface

uses WinRes;

var
  ForeColor, BakColor: Byte;

function BitmapToImage(Bitmap: PBitmap): pointer;

implementation

uses Graph;	{ for ImageSize }

procedure DoBitmapToImage_16(Bitmap: PBitmap; Image: pointer;
  Color: Word); near; external;

{$L bmp.obj (bmp.asm) }

function BitmapToImage(Bitmap: PBitmap): pointer;
var
  Image: pointer;
Begin
  with Bitmap^ do Begin
    GetMem(Image, ImageSize(0, 0, bmWidth-1, bmHeight-1));
    If Image <> nil then
      DoBitmapToImage_16(Bitmap, Image, ForeColor + 256 * BakColor)
  End;
  BitmapToImage := Image
End;

end.
