unit keydef;

{ This unit contains all the constants and transformations for
  the xcrt unit function ReadAllKeys }

interface

const
  { These are the constants for readallkeys }
  enter=#13; esc=#27; tab=#9;
  backsp=#8;
  CtrlEnter=#10; CtrlBacksp=#127;
  CtrlF1=#138; CtrlF2=#139; CtrlF3=#140; CtrlF4=#141;
  CtrlF5=#142; CtrlF6=#143; CtrlF7=#144; CtrlF8=#145;
  CtrlF9=#146; CtrlF10=#147;
  ShftF1=#148; ShftF2=#149; ShftF3=#150; ShftF4=#151;
  ShftF5=#152; ShftF6=#153; ShftF7=#154; ShftF8=#155;
  ShftF9=#156; ShftF10=#157;
  AltF1=#158; AltF2=#159; AltF3=#160; AltF4=#161;
  AltF5=#162; AltF6=#163; AltF7=#164; AltF8=#165;
  AltF9=#166; AltF10=#167;
  AltA=#168; AltB=#169; AltC=#170; AltD=#171;
  AltE=#172; AltF=#173; AltG=#174; AltH=#175;
  AltI=#176; AltJ=#177; AltK=#178; AltL=#179;
  AltM=#180; AltN=#181; AltO=#182; AltP=#183;
  AltQ=#184; AltR=#185; AltS=#186; AltT=#187;
  AltU=#188; AltV=#189; AltW=#190; AltX=#191;
  AltY=#192; AltZ=#193;
  Ins=#194; Home=#195; PgUp=#196; Del=#197;
  EndKey=#198; PgDn=#199; UpArrow=#200; LeftArrow=#201;
  RightArrow=#202; DownArrow=#203;
  CtrlLeftArrow=#204; CtrlRightArrow=#205;
  F1=#206; F2=#207; F3=#208; F4=#209; F5=#210;
  F6=#211; F7=#212; F8=#213; F9=#214; F10=#215;
  Alt1=#216; Alt2=#217; Alt3=#218; Alt4=#219;
  Alt5=#220; Alt6=#221; Alt7=#222; Alt8=#223;
  Alt9=#224; Alt0=#225;
  CtrlHome=#226; CtrlEnd=#227; CtrlPgUp=#228;
  CtrlPgDn=#229; ShiftTab=#230;
  Ctrl255=#231;
  Ctrl2=#232;
  CtrlAsterisk=#233;
  AltEqual=#234;
  AltMinus=#235;

function transformedkey(c:char):char;

implementation

function transformedkey(c:char):char;
begin
 case ord(c) of
   15: transformedkey:=shifttab;
   59..68:transformedkey:=chr(ord(c)+ord(F1)-59);       { F1-F10 }
   94..103:transformedkey:=chr(ord(c)-94+ord(CtrlF1));  { CtrlF1-CtrlF10 }
   84..93:transformedkey:=chr(ord(c)-84+ord(ShftF1));   { ShftF1-ShftF10 }
   104..113:transformedkey:=chr(ord(c)-104+ord(AltF1)); { AltF1-AltF10 }
   30:transformedkey:=AltA; 48:transformedkey:=AltB; 46:transformedkey:=AltC;
   32:transformedkey:=AltD; 18:transformedkey:=AltE; 33:transformedkey:=AltF;
   44:transformedkey:=AltG; 35:transformedkey:=AltH; 23:transformedkey:=AltI;
   36:transformedkey:=AltJ; 37:transformedkey:=AltK; 38:transformedkey:=AltL;
   50:transformedkey:=AltM; 49:transformedkey:=AltN; 24:transformedkey:=AltO;
   25:transformedkey:=AltP; 16:transformedkey:=AltQ; 19:transformedkey:=AltR;
   31:transformedkey:=AltS; 20:transformedkey:=AltT; 22:transformedkey:=AltU;
   47:transformedkey:=AltV; 17:transformedkey:=AltW; 45:transformedkey:=AltX;
   21:transformedkey:=AltY; 44:transformedkey:=AltZ;
   120..129:transformedkey:=chr(ord(c)-120+ord(Alt1));  { Alt1-Alt0 }
   72:transformedkey:=UpArrow;
   75:transformedkey:=LeftArrow;
   77:transformedkey:=RightArrow;
   80:transformedkey:=DownArrow;
   115:transformedkey:=CtrlLeftArrow;
   116:transformedkey:=CtrlRightArrow;
   82:transformedkey:=Ins;
   71:transformedkey:=Home;
   73:transformedkey:=PgUp;
   83:transformedkey:=Del;
   79:transformedkey:=EndKey;
   81:transformedkey:=PgDn;
   119:transformedkey:=CtrlHome;
   117:transformedkey:=CtrlEnd;
   132:transformedkey:=CtrlPgUp;
   118:transformedkey:=CtrlPgDn;
   255:transformedkey:=Ctrl255;
   3:transformedkey:=Ctrl2;
   114:transformedkey:=CtrlAsterisk;
   131:transformedkey:=AltEqual;
   130:transformedkey:=AltMinus;
   end
end;

end.
