{===========================================================================}
{                                                                           }
{                   Unit LObjects                 }
{                    Release 1.0                  }
{                                                                           }
{               CREATED BY Dr. LUIS  VACA         }        
{                  All Rights Reserved            }
{                                                                           }
{  " Promote Programming ... Register !!!"                                  }
{===========================================================================}

Unit LObjects;

INTERFACE

USES
    Graph, Emouse;


VAR
   CMCommand  : Word;
   
CONST
     CanRotate : Boolean = true;



TYPE
     Call  = Function : Word;


CONST
    CMQuit      = Key_Alt   + Key_X;
    CMSwitch    = Key_Ctrl  + Key_Esc;
    CMRotate    = Key_Shift + Key_Tab;
    CMMenu      = Key_Ctrl  + Key_Space;
    CMPaint     = 1000;
    CMCanClose  = 2000;
    CMClose     = 2001;
    CMMove      = 1001;
    CMResize    = 1002;
    CMMaximize  = 1003;
    CMRestore   = 1004;

{     ALL BEGINS WITH THE BASIC OBJECT ++++++LVIEW++++++++  }
{                                                           }
{                       LVIEW                               }
{                                                          }
{           __________________________                     }
{                                                        }
{        LCONTROL      LDIALOG      LWINDOW                 }
{                                                         }
{                                                         }
{        LBUTTON                    LTTYWINDOW              }
{                                                           }
{ MORE CONTROLS CAN BE DERIVED FROM LCONTROL AND EASILY     }
{ INSERTED IN ANY DESCENDANT OF LDIALOG.                    }
{ MODIFY THE HANDLEEVENT METHOD OF YOUR OBJECT DERIVED FROM }
{ LCONTROL OBJECT TO SUIT YOUR SPECIFIC OBJECT NEEDS.       }






TYPE
             aMaskList              = ARRAY[1..200] of  MaskType;
             aRectList              = ARRAY[1..200] of  Rect;
             aP                     = ARRAY[1..200] of  Point;
             aViewList              = Record
                                            MaskList : aMaskList;
                                            RectList : aRectList;
                                            P        : aP;
                                      end;


    PLView   =   ^LView;
    LView    =   Object
             ID                    : Integer;
             PaintR                : Rect;
             OwnerR                : Rect;
             MinSize               : Point;
             TempR                 : Rect;
             R, WorkR,
             MenuR                 : Rect;
             MinMaxR               : Rect;
             TitleR                : Rect;
             { RectANGLES FOR RESIZING AREAS }
             R1, R2, R3,
             R4, R5, R6,
             R7, R8, R9,
             R10, R11,
             R12                   : Rect;
             RRestore              : Rect;
             Title                 : String;            
             Margin                : Integer;
             IsMaximizable         : Boolean;
             IsResizable           : Boolean;
             IsMoveable            : Boolean;
             IsCloseable           : Boolean;
             Maximized             : Boolean;
             CWinTitle             : Integer;
             CWinWR                : Integer;
             CTitle                : Integer;
             Place                 : Integer;
             ViewList              : aViewList;
             ViewCount             : Word;
        Constructor Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
        Procedure ReportError(n:Integer);                        Virtual;
        Procedure FitR ( VAR RL1, RL2 : Rect);                   Virtual;
        Procedure SetR (anR : Rect);                             Virtual;
        Procedure BevelR(x,y,x1,y1: Integer; topcolor,
                         botcolor,interior,thickness : Word);    Virtual;
        Procedure SetMinMax(VAR P : Point);                      Virtual;
        Procedure CanMaximize (YesNo : Boolean);                 Virtual;
        Procedure CanMove (YesNo : Boolean);                     Virtual;
        Procedure CanResize(YesNo : Boolean);                    Virtual;
        Procedure CanClose(YesNo : Boolean);                     Virtual;
        Procedure Maximize( VAR E : Eventype);                   Virtual;
        Procedure Restore( VAR E : Eventype);                    Virtual;
        Procedure SetAreas;                                      Virtual;
        Procedure Paint;                                         Virtual;
        Procedure MinMaxButton(OnOff : Boolean);                 Virtual;
        Procedure MenuButton(OnOff : Boolean);                   Virtual;
        Procedure Draw;                                          Virtual;
        Procedure GetExtent(VAR Extent: Rect);                   Virtual;
        Procedure GetOwnerR(VAR OwnR : Rect);                    Virtual;
        Procedure FillR (VAR RFill : Rect;
                  color : Integer);                              Virtual;
        Procedure SetFocus(OnOff : Boolean);                     Virtual;
        Procedure Resize(VAR E: Eventype);                       Virtual;
        Procedure Clamp(VAR P : Point);                          Virtual;
        Procedure UnClamp;                                       Virtual;
        Procedure XorBox(VAR RR : Rect);                         Virtual;
        Procedure Move( VAR E : Eventype);                       Virtual;
        Procedure ExplodeR;                                      Virtual;
        Procedure DoMenu( VAR E : EvenType);                     Virtual;
        Procedure HandleEvent(VAR E : Eventype);                 Virtual;
        Procedure Idle;                                          Virtual;
        Procedure MakeLocal(VAR Rin, Rout : Rect);               Virtual;
        Procedure PLine(X, Y, X1, Y1: Integer);                  Virtual;
        Procedure PLineTo(X, Y : Integer);                       Virtual;
        Procedure PBar(X, Y, X1, Y1: Integer);                   Virtual;
        Procedure PMoveto(X, Y: Integer);                        Virtual;
        Procedure PRectangle(X, Y, X1, Y1: Integer);             Virtual;
        Procedure PPutPixel(X, Y: Integer; Pixel: Word);         Virtual;
        Function  PGetPixel(X,Y : Integer): Word;                Virtual;
        Destructor Done;
   END;


    PLWindow   = ^LWindow;
    LWindow    = Object(LView)
     CONSTructor Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string; color,back:Integer);
     Destructor Done;
    END;


    PLTTYWindow   =  ^LTTYWindow;
    LTTYWindow    =  Object (LWindow)
    Xpos, Ypos        : Integer;
    textcolor         : integer;
    textbackground    : integer;
     CONSTructor Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
     Procedure FitCursorPos;                                  Virtual;
     Procedure SetTextColor (Acolor : integer);               Virtual;
     Procedure SetTextBackground(Acolor : integer);           Virtual;
     Procedure HandleEvent(VAR E : Eventype);                 Virtual;
     Destructor Done;
    END;


    PLDialog    =  ^LDialog;
    LDialog     = Object(LView)
      ObjCount : Word;
      Focused  : Word;
      ObjList  : Array[1..30] of PLView;
      TempList : Array[1..30] of PLView;
      Constructor Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
      Procedure Paint;                                          Virtual;
      Procedure Insert(P : Pointer);                            Virtual;
      Procedure Delete(P : PLView);                             Virtual;
      Procedure Maximize( VAR E : Eventype);                    Virtual;
      Procedure Restore( VAR E : Eventype);                     Virtual;
      Procedure Move( VAR E : Eventype);                        Virtual;
      Procedure Resize( VAR E : Eventype);                      Virtual;
      Function GetDC : PLView;                                  Virtual;
      Function GetView(VAR P:Point): Integer;                   Virtual;
      Procedure Clamp(VAR P : Point);                           Virtual;
      Procedure UnClamp;                                        Virtual;
      Procedure Rotatetop (N:Integer);                          Virtual;
      Procedure HandleEvent(VAR E : Eventype);                  Virtual;
      Destructor Done;
    END;


     PLControl =  ^LControl;
     LControl  =  Object (LView)
      OffsetX,
      OffsetY  : Integer;

     CONSTructor  Init(X,Y,X1,Y1 : Integer);
     Procedure Move(VAR E: EvenType);                 Virtual;
     Procedure SetFocus(OnOff : Boolean);             Virtual;
     Destructor Done;
     END;          


    PLButton = ^LButton;
    LButton  = Object (LControl)
      Color    : Integer;
      TColor   : Integer;
      ispushed : Boolean;
      Key      : Word;

      Constructor Init(X,Y,X1,Y1 : Integer; wide : Integer;
                       Atitle : String; Acolor: Integer);
      Procedure Paint;                                  Virtual;
      Procedure Push;                                   Virtual;
      Procedure Move(VAR E: EvenType);                  Virtual;
      Procedure SetFocus(OnOff : Boolean);              Virtual;
      Function GetAKey: Word;                           Virtual;
      Procedure HandleEvent (VAR E : EvenType);         Virtual;
      Destructor Done;
    END;


     PLViewLogo = ^LViewLogo;
     LViewLogo  = Object(LDialog)
     Constructor Init;
     Procedure   Draw;                              Virtual;
     Procedure   Idle;                              Virtual;
     Destructor  Done;
     END;



    PLApp = ^LApp;
    LApp  = Object
     VP       : ViewPortType;
     APColor  : Integer;
     TotalR   :  Rect;
     ClipR    :  Rect;
     DL       : PLDialog;
     B1, B2   : PLButton;
     Logo     : PLViewLogo;
     ObjList  : Array[1..300] of PLView;
     TempList : Array[1..300] of PLView;
     ObjCount : Word;
      CONSTructor Init;
      Procedure Insert(P : PLView);            Virtual;
      Procedure FillR (VAR RFill : Rect;
                  color : Integer);            Virtual;
      Procedure Destroy(P : PLView);           Virtual;
      Procedure SetView( VAR R : Rect);        Virtual;
      Function GetDC : PLView;                 Virtual;
      Procedure Rotatetop (N:Integer);         Virtual;
      Function GetView(VAR P:Point): Integer;  Virtual;
      Procedure Draw;                          Virtual;
      Procedure Paint(VAR R : Rect);           Virtual;
      Procedure Idle;                          Virtual;
      Procedure Switch;                        Virtual;
      Function YesNoMsg (Msg : string): Word;  Virtual;
      Procedure Run;                           Virtual;
      Destructor Done;
    END;


IMPLEMENTATION

Constructor LView.Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
VAR
    DifX, DifY        : Integer;
BEGIN
     MinSize.X        := 100;
     MinSize.Y        := 60;
     ID               := anID;
     R.A.X            := X;
     R.A.Y            := Y;
     R.B.X            := X1;
     R.B.Y            := Y1;
     Title            := Atitle;
     Margin           := 8;
     IsMaximizable    := True;
     IsMoveable       := True;
     IsResizable      := True;
     IsCloseable      := True;
     Maximized        := False;
     CWinTitle        := Red;
     CWinWR           := LightGray;
     Ctitle           := Black;
     Place            := 0;
     ViewCount        := 16;
     DifX:=(R.B.X-R.A.X);
     DifY:=(R.B.Y-R.A.Y);
     If (DifX < MinSize.X) then R.B.X:= R.A.X + MinSize.X;
     If (DifY < MinSize.Y) then R.B.Y:= R.A.Y + MinSize.Y;
     RRestore  := R;
END;

Procedure LView.SetMinMax (VAR P : Point);
BEGIN
    MinSize := P;
END;


Procedure LView.CanMaximize (YesNo : Boolean);
BEGIN
     ISMaximizable := YesNo;
END;



Procedure LView.CanMove (YesNo : Boolean);
BEGIN
     ISMoveable := YesNo;
END;

Procedure LView.CanResize(YesNo : Boolean);
BEGIN
     IsResizable := YesNo;
END;

Procedure LView.CanClose(YesNo : Boolean);
BEGIN
     IsCloseable := YesNo;
END;

Procedure LView.Maximize( VAR E : Eventype);
VAR
    isDone   : Boolean;
    Event    : Boolean;
    Pressed  : Boolean;
BEGIN
     If MAXIMIZED OR (NOT ISMAXIMIZABLE) THEN EXIT ELSE
     MinMaxButton( False);
     Pressed := false;
     IF (E.Mouse.Event = 1) AND (E.Command <> CMMaximize) then
     REPEAT
           Event := GetEvent (E);
           Pressed := true;
           isDone := (E.Mouse.Event = 2) OR (NOT MouseinR(E.Mouse.P, MinMaxR));
     UNTIL isDone;
     MinMaxButton( true);
     If Pressed AND (NOT MouseinR(E.Mouse.P, MinMaxR)) then EXIT ELSE
     RRestore   := R;
     Maximized  := True;
     R.A.X      := 0;
     R.A.Y      := 0;
     R.B.X      := GetMaxX;
     R.B.Y      := GetMaxY;
     CMCommand := CMPaint;
     PaintR := RRestore;
     SetAreas;
END;


Procedure LView.Restore( VAR E : Eventype);
VAR
    isDone   : Boolean;
    Event    : Boolean;
    Pressed  : Boolean;

BEGIN
     If (NOT MAXIMIZED) OR (NOT ISMAXIMIZABLE) THEN EXIT ELSE
     MinMaxButton( False);
     Pressed := false;
     IF (E.Mouse.Event = 1) AND (E.Command <> CMRestore) then
     REPEAT
           Event := GetEvent (E);
           Pressed := true;
           isDone := (E.Mouse.Event = 2) OR (NOT MouseinR(E.Mouse.P, MinMaxR));
     UNTIL isDone;
     MinMaxButton( true);
     If Pressed AND (NOT MouseinR(E.Mouse.P, MinMaxR)) then EXIT ELSE
     PaintR     := R;
     R          := RRestore;
     Maximized  := False;
     CMCommand  := CMPaint;
     SetAreas;
END;



Procedure LView.BevelR(x,y,x1,y1: Integer; topcolor,botcolor,interior,thickness : Word);
VAR
  OldStyle     : LineSettingsType;
  OldColor     : Word;
  OldFill      : FillSettingsType;
  i            : Word;
  anR          : Rect;
BEGIN
     HideMouse;
     GetFillSettings(oldfill);
     SetfillStyle(1,LIGHTGRAY);
     GetlineSettings(Oldstyle);
     SetlineStyle(0,0,1);
     OldColor:=GetColor;

     anR.A.X := X;
     anR.A.Y := Y;
     anR.B.X := X1;
     anR.B.Y := Y1;

     FillR(anR, interior);
     SetColor(black);
     Rectangle(x,y,x1,y1);
     Rectangle(x+thickness,y+thickness,x1-thickness,y1-thickness);

      for i:=1 to thickness-1 do
	 BEGIN
            SetColor(topcolor);
	    Line(x+i,y+i,x1-i,y+i);   { top}
            SetColor(botcolor);
	    Line(x+i,y1-i,x1-i,y1-i); { bottom }
            SetColor(topcolor);
	    Line(x+i,y+i,x+i,y1-i);   { left }
            SetColor(botcolor);
	    Line(x1-i,y+i,x1-i,y1-i); { right }
	 END;
      SetColor(black);
      Line(x,y,x+thickness,y+thickness);	{ upper left }
      Line(x,y1,x+thickness,y1-thickness);	{ lower left }
      Line(x1,y,x1-thickness,y+thickness);	{ upper right }
      Line(x1,y1,x1-thickness,y1-thickness);	{ lower right }

     {restore everything}
     Setcolor(OldColor);
     with OldStyle do
     SetLineStyle(LineStyle, Pattern,
               Thickness);
     with OldFill do
     SetFillStyle(Pattern, Color);
     ShowMouse;
END;




Procedure LView.SetR( anR : Rect);
BEGIN
     R := anR;
END;

Procedure LView.ReportError(n : Integer);
CONST
      ERROR : array [1..5] of string[25] =
      ('No Memory for Operation',
      'Device not Ready',
      'Invalid Pointer',
      'Invalid Object',
      'Message not Found');
VAR
   ErrR              : Rect;
   Difx,len          : Integer;
BEGIN

END;

Procedure LView.Draw;
VAR
    n : Integer;
BEGIN

END;
Procedure LView.GetOwnerR(VAR OwnR : Rect);
BEGIN
     OwnerR := OwnR;
END;



Procedure LView.GetExtent(VAR Extent: Rect);
VAR
   DifX, DifY : Integer;
BEGIN
      Extent.A.X := 0;
      Extent.A.Y := 0;
      DifX := (WorkR.B.X - WorkR.A.X);
      DifY := (WorkR.B.Y - WorkR.A.Y);
      Extent.B.X := DifX;
      Extent.B.Y := DIfY;
END;

Procedure LView.FillR (VAR RFill : Rect; color : Integer);
CONST
    Rarea : array[1..4] of PointType =
   ((X: 0; Y: 0),
    (X: 0; Y: 0),
    (X: 0; Y: 0),
    (X: 0; Y: 0));

VAR
    OldFill      :  FillSettingsType;
    OldColor     :  Integer;
BEGIN
      HideMouse;
      GetFillSettings(OldFill);
      OldColor := GetColor;
      Setfillstyle(1,Color);
      SetColor(Color);
      Rarea[1].X:= RFill.A.X;
      Rarea[1].Y:= RFill.A.Y;
      Rarea[2].X:= RFill.B.X;
      Rarea[2].Y:= RFill.A.Y;
      Rarea[3].X:= RFill.B.X;
      Rarea[3].Y:= RFill.B.Y;
      Rarea[4].X:= RFill.A.X;
      Rarea[4].Y:= RFill.B.Y;
      FillPoly(SizeOf(Rarea) DIV SizeOf(PointType), Rarea);
      With OldFill do
      SetFillStyle(Pattern, Color);
      SetColor(OldColor);
      ShowMouse;
END;


Procedure LView.SetAreas;
CONST
     Step = 3;
VAR
   Difx,dify, pos,st,space, tw,th  : Integer;
   TextInfo                        : TextSettingsType;

BEGIN
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 5);
     SetTextJustify(LeftText, TopText);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');

     TitleR.A.X:=R.A.X + (Margin * 3);
     TitleR.A.Y:=R.A.Y + Margin;
     TitleR.B.X:=R.B.X - (Margin * 3);
     TitleR.B.Y:=R.A.Y + (th * 2) + Margin;
     ViewList.RectList[1] := TitleR;
     ViewList.MaskList[1] := MaskTCROSS;
     ViewList.P[1].X      := 7;
     ViewList.P[1].Y      := 7;

     MenuR.A.X:=R.A.X + Margin;
     MenuR.B.X:=R.A.X + (Margin * 3);
     MenuR.A.Y:=R.A.Y + Margin;
     MenuR.B.Y:=TitleR.B.Y;
     ViewList.RectList[2] := MenuR;
     ViewList.MaskList[2] := Standard;
     ViewList.P[2].X      := 1;
     ViewList.P[2].Y      := 1;

     MinMaxR.A.X:=R.B.X - (Margin * 3);
     MinMaxR.A.Y:=R.A.Y + Margin;
     MinMaxR.B.X:=R.B.X - Margin;
     MinMaxR.B.Y:=TitleR.B.Y;
     ViewList.RectList[3] := MinMaxR;
     ViewList.MaskList[3] := Standard;
     ViewList.P[3].X      := 1;
     ViewList.P[3].Y      := 1;

     WorkR.A.X:=(R.A.X + Margin);
     WorkR.A.Y:=TitleR.B.Y;
     WorkR.B.X:=(R.B.X - Margin);
     WorkR.B.Y:=(R.B.Y - Margin);
     ViewList.RectList[4] := WorkR;
     ViewList.MaskList[4] := Standard;
     ViewList.P[4].X      := 1;
     ViewList.P[4].Y      := 1;


     {============================ ASSIGN RESIZING AREAS =======================}

      {  AREA  }      { MOUSE MASK }

      { R1    }   { MaskResizeBack }
      R1.A.X := R.A.X;
      R1.B.X := R.A.X + MARGIN;
      R1.A.Y := R.A.Y;
      R1.B.Y := R.A.Y + (MARGIN * STEP);
      ViewList.RectList[5] := R1;
      ViewList.MaskList[5] := MaskResizeBack;
     ViewList.P[5].X      := 7;
     ViewList.P[5].Y      := 7;

      { R2    }   { MaskResizeBack }
      R2.A.X := R.A.X;
      R2.B.X := R.A.X + (MARGIN * STEP);
      R2.A.Y := R.A.Y;
      R2.B.Y := R.A.Y + MARGIN;
      ViewList.RectList[6] := R2;
      ViewList.MaskList[6] := MaskResizeBack;
     ViewList.P[6].X      := 7;
     ViewList.P[6].Y      := 7;

      { R3   }   { MaskResizeVer }
      R3.A.X := R2.B.X;
      R3.B.X := R2.B.X + ((R.B.X - R.A.X) - (MARGIN * STEP * 2));
      R3.A.Y := R.A.Y;
      R3.B.Y := R.A.Y + MARGIN;
      ViewList.RectList[7] := R3;
      ViewList.MaskList[7] := MaskResizeVert;
     ViewList.P[7].X      := 7;
     ViewList.P[7].Y      := 7;

      { R4  ͻ  }   { MaskResizeForw }
      R4.A.X := R3.B.X;
      R4.B.X := R.B.X;
      R4.A.Y := R.A.Y;
      R4.B.Y := R.A.Y + MARGIN;
      ViewList.RectList[8] := R4;
      ViewList.MaskList[8] := MaskResizeForw;
     ViewList.P[8].X      := 7;
     ViewList.P[8].Y      := 7;

      { R5  ͻ  }   { MaskResizeForw }
      R5.A.X := R.B.X - MARGIN;
      R5.B.X := R.B.X;
      R5.A.Y := R.A.Y + MARGIN;
      R5.B.Y := R.A.Y + (MARGIN * STEP);
      ViewList.RectList[9] := R5;
      ViewList.MaskList[9] := MaskResizeForw;
     ViewList.P[9].X      := 7;
     ViewList.P[9].Y      := 7;

      { R6     }   { MaskResizeHor }
      R6.A.X := R.B.X - MARGIN;
      R6.B.X := R.B.X;
      R6.A.Y := R5.B.Y;
      R6.B.Y := R.B.Y - (MARGIN * STEP);
      ViewList.RectList[10] := R6;
      ViewList.MaskList[10] := MaskResizeHor;
     ViewList.P[10].X      := 7;
     ViewList.P[10].Y      := 7;

      { R7     }   { MaskResizeBack }
      R7.A.X := R.B.X - MARGIN;
      R7.B.X := R.B.X;
      R7.A.Y := R6.B.Y;
      R7.B.Y := R.B.Y;
      ViewList.RectList[11] := R7;
      ViewList.MaskList[11] := MaskResizeBack;
     ViewList.P[11].X      := 7;
     ViewList.P[11].Y      := 7;

      { R8  ͼ  }   { MaskResizeBack }
      R8.A.X := R.B.X - (MARGIN * STEP);
      R8.B.X := R.B.X;
      R8.A.Y := R.B.Y - MARGIN;
      R8.B.Y := R.B.Y;
      ViewList.RectList[12] := R8;
      ViewList.MaskList[12] := MaskResizeBack;
     ViewList.P[12].X      := 7;
     ViewList.P[12].Y      := 7;

      { R9   }   { MaskResizeVer }
      R9.A.X := R.A.X + (MARGIN * STEP);
      R9.B.X := R8.A.X;
      R9.A.Y := R.B.Y - MARGIN;
      R9.B.Y := R.B.Y;
      ViewList.RectList[13] := R9;
      ViewList.MaskList[13] := MaskResizeVert;
     ViewList.P[13].X      := 7;
     ViewList.P[13].Y      := 7;

      { R10    }   { MaskResizeForw }
      R10.A.X := R.A.X;
      R10.B.X := R.A.X + (MARGIN * STEP);
      R10.A.Y := R.B.Y - MARGIN;
      R10.B.Y := R.B.Y;
      ViewList.RectList[14] := R10;
      ViewList.MaskList[14] := MaskResizeForw;
     ViewList.P[14].X      := 7;
     ViewList.P[14].Y      := 7;

      { R11    }   { MaskResizeForw }
      R11.A.X := R.A.X;
      R11.B.X := R.A.X + MARGIN;
      R11.A.Y := R.B.Y - (MARGIN * STEP);
      R11.B.Y := R.B.Y - MARGIN;
      ViewList.RectList[15] := R11;
      ViewList.MaskList[15] := MaskResizeForw;
     ViewList.P[15].X      := 7;
     ViewList.P[15].Y      := 7;

      { R12    }   { MaskResizeHor }
      R12.A.X := R.A.X;
      R12.B.X := R.A.X + MARGIN;
      R12.A.Y := R1.B.Y;
      R12.B.Y := R11.A.Y;
      ViewList.RectList[16] := R12;
      ViewList.MaskList[16] := MaskResizeHor;
     ViewList.P[16].X      := 7;
     ViewList.P[16].Y      := 7;

     {============================ ASSIGN RESIZING AREAS =======================}


     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
END;

Procedure Lview.MinMaxButton(OnOff : Boolean);
VAR
   TextInfo                        : TextSettingsType;
   OldColor                        : Integer;
BEGIN
     HideMouse;
     GetTextSettings(TextInfo);
     SetTextJustify(LeftText, TopText);
     OldColor:= GetColor;
     SetColor(Black);
     If OnOff then BevelR(MinMaxR.A.X, MinMaxR.A.Y, MinMaxR.B.X, MinMaxR.B.Y, white, 8, lightgray, 2)
     ELSE BevelR(MinMaxR.A.X, MinMaxR.A.Y, MinMaxR.B.X, MinMaxR.B.Y, 8, white, lightgray, 2);
     SetTextStyle(SmallFont, 1, 5);
     OutTextXY(MinMaxR.A.X + 2, MinMaxR.A.Y + 3, '>');
     OutTextXY(MinMaxR.A.X + 2, MinMaxR.B.Y - 13, '<');
     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
     SetColor(OldColor);
     ShowMouse;
END;

Procedure Lview.MenuButton(OnOff : Boolean);
VAR
   OldColor : Integer;
BEGIN
     HideMouse;
     OldColor := GetColor;
     if OnOff then BevelR(MenuR.A.X, MenuR.A.Y, MenuR.B.X, MenuR.B.Y, white, 8, lightgray, 2)
     ELSE BevelR(MenuR.A.X, MenuR.A.Y, MenuR.B.X, MenuR.B.Y, 8, White, lightgray, 2);
     SetColor(Black);
     Rectangle(MenuR.A.X + 4, MenuR.A.Y + 4, MenuR.B.X - 6, MenuR.B.Y - 6);
     Rectangle(MenuR.A.X + 6, MenuR.A.Y + 6, MenuR.B.X - 4, MenuR.B.Y - 4);
     SetColor(OldColor);
     ShowMouse;
END;



Procedure LView.SetFocus(OnOff : Boolean);
VAR
   Difx,dify, pos,st,space, tw,th  : Integer;
   Atitle                          : string;
   TextInfo                        : TextSettingsType;
   OldColor                        : Integer;
BEGIN
     HideMouse;
     GetTextSettings(TextInfo);
     OldColor:=GetColor;
     SetTextStyle(SmallFont, 0, 5);
     DifX:=(R.B.X-R.A.X);
     DifY:=(R.B.Y-R.A.Y);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     SetColor(CTitle);
     Atitle:=Title;
     St:=Length(Atitle) * Tw;
     Space:=(DifX div Tw)-Margin;
     if St > space then Delete(Atitle, Space+1,(St div Tw) - Space);
     St:=length(atitle) * tw;
     Pos:=(R.A.X + (DifX DIV 2)) - (st DIV 2);

     If OnOff then FillR(TitleR,CWinTitle) ELSE FillR(TitleR,White);
     SetColor(Black);
     OutTextXY(pos,R.A.Y + (Th DIV 2) + Margin,atitle);

     MinMaxButton(true);
     MenuButton(true);

     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
     SetColor(OldColor);
     ShowMouse;
END;



Procedure LView.Paint;
VAR
  Oldstyle     : LineSettingsType;
  oldcolor     : Word;
  z            : Integer;
  len          : Integer;
BEGIN
     HideMouse;
     Getlinesettings(Oldstyle);
     Setlinestyle(0,0,1);
     Oldcolor:=Getcolor;
     SetColor(Black);
     SetAreas;
     FillR(WorkR, CWinWR);
     SetFocus(True);
     
     Setcolor(8);
     moveto(R.A.X,R.B.Y);
     lineto(R.A.X,R.A.Y);
     lineto(R.B.X,R.A.Y);

     len:=0;

For z:=0 to 2 do BEGIN
                      Setcolor(white);
                      moveto(R.A.X+len,R.B.Y);
                      lineto(R.A.X+len,R.A.Y+len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
     len:=3;
For z:=0 to 2 do BEGIN
                      Setcolor(lightgray);
                      moveto(R.A.X+len,R.B.Y);
                      lineto(R.A.X+len,R.A.Y+len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
     len:=5;
For z:=0 to 2 do BEGIN
                      Setcolor(8);
                      moveto(R.A.X+len,R.B.Y);
                      lineto(R.A.X+len,R.A.Y+len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
      len:=0;
For z:=0 to 2 do BEGIN
                      Setcolor(8);
                      moveto(R.A.X+len,R.B.Y-len);
                      lineto(R.B.X-len,R.B.Y-len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
     len:=3;
For z:=0 to 2 do BEGIN
                      Setcolor(lightgray);
                      moveto(R.A.X+len,R.B.Y-len);
                      lineto(R.B.X-len,R.B.Y-len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
     len:=5;
For z:=0 to 2 do BEGIN
                      Setcolor(white);
                      moveto(R.A.X+len,R.B.Y-len);
                      lineto(R.B.X-len,R.B.Y-len);
                      lineto(R.B.X-len,R.A.Y+len);
                      inc(len);
                 END;
     Setcolor(8);
     moveto(R.A.X+len,R.B.Y-len);
     lineto(R.B.X-len,R.B.Y-len);
     lineto(R.B.X-len,R.A.Y+len);
     Rectangle(R.A.X,R.A.Y,R.B.X-1,R.B.Y-1);

     {restore everything}
     Setcolor(OldColor);

     With OldStyle do
     SetLineStyle(LineStyle, Pattern,
               Thickness);
 
     Draw;
     ShowMouse;
END;


Procedure LView.Move( VAR E : Eventype);
VAR
    TmpR    : Rect;
    DifP    : Point;
    OldP    : Point;
    TempE   : Eventype;
    isDone  : Boolean;
    DifX,
    DifY    : Integer;
LABEL
     NextStep;
BEGIN
     IF (NOT IsMoveable) OR MAXIMIZED THEN EXIT ELSE
     TmpR   := Self.R;
     DIfP.X := TmpR.B.X - TmpR.A.X;
     DifP.Y := TmpR.B.Y - TmpR.A.Y;
     DifX   := (E.Mouse.P.X - TmpR.A.X);
     DIfY   := (E.Mouse.P.Y - TmpR.A.Y);

     { IF MOVE METHOD CALLED FROM MENU }
     { MOVE VIEW USING KEYBOARD }
     IF E.Command = CMMove THEN
        BEGIN
             DifX := (TitleR.B.X - TItleR.A.X) DIV 2;
             DifY := (TitleR.B.Y - TitleR.A.Y) DIV 2;
             LView.XorBox(TmpR);
             REPEAT
                   Event := GetEvent(TempE);
                   IF TempE.Key.ScanCode <> 0 THEN
                      BEGIN
                           LView.XorBox(TmpR);
                           Case TempE.Key.Scancode OF
                                Key_UpArrow    :  If TmpR.A.Y > 1 then
                                                     BEGIN
                                                          Dec(TmpR.A.Y,1);
                                                          Dec(TmpR.B.Y,1);
                                                     END;
                                Key_DownArrow  :  If TmpR.B.Y < GetMaxY then
                                                     BEGIN
                                                          Inc(TmpR.A.Y,1);
                                                          Inc(TmpR.B.Y,1);
                                                     END;
                                Key_RightArrow :  If TmpR.B.X < GetMaxX THEN
                                                     BEGIN
                                                          Inc(TmpR.A.X,1);
                                                          Inc(TmpR.B.X,1);
                                                     END;
                                Key_LeftArrow  :  If TmpR.A.X > 1 THEN
                                                     BEGIN
                                                          Dec(TmpR.A.X,1);
                                                          Dec(TmpR.B.X,1);
                                                     END;
                           END; { CASES }
                           LView.XorBox(TmpR);
                      END;
                   isDone := (TempE.Key.Scancode = Key_Enter) OR (TempE.Mouse.Event = 1);
             UNTIL isDONE;
             GOTO NextStep;
        END;

     { MOVE VIEW USING MOUSE }
     OldP   := E.Mouse.P;
     MouseCursor(MaskTCROSS, 7,7);
     MouseMinMax(DifX,DifY, GetMaxX - (DIfP.X - DifX),
     GetMaxY - (DIfP.Y - DifY));
     LView.XorBox(TmpR);
     
     Repeat
           Event := GetEvent(TempE);
           If (OldP.X <> TempE.Mouse.P.X) OR
           (OldP.Y <> TempE.Mouse.P.Y)
           THEN
                   BEGIN
                        LView.XorBox(TmpR);
                        TmpR.A.X := (TempE.Mouse.P.X - DifX);
                        TmpR.A.Y := (TempE.Mouse.P.Y - DIfY);
                        TmpR.B.X := (TmpR.A.X + DIfP.X);
                        TmpR.B.Y := (TmpR.A.Y + DIfP.Y);
                        LView.XorBox(TmpR);
                        OldP := TempE.Mouse.P;
                   END;
           isDone:= (TempE.Mouse.Event <> 1) AND (TempE.Mouse.Event <> 5);
     Until isDone;
     MouseMinMax(0,0,GetMaxX,GetMaxY);

     NextStep :
     LView.XorBox(TmpR);
     CMCommand := CMPaint;
     PaintR    := R;
     Self.R    := TmpR;
     SetAreas;
END;

Procedure LView.Resize(VAR E: Eventype);
VAR
    TmpR    : Rect;
    DifP    : Point;
    OldP    : Point;
    TempE   : Eventype;
    isDone  : Boolean;
    X       : Integer;
LABEL
     NextStep;

BEGIN
     IF (NOT IsResizable) OR MAXIMIZED THEN EXIT ELSE
     TmpR   := R;
     DifP.X := E.Mouse.P.X;
     DifP.Y := E.Mouse.P.Y;
     OldP   := E.Mouse.P;

     { IF RESIZE METHOD CALLED FROM MENU }
     { RESIZE VIEW USING KEYBOARD }
     IF E.Command = CMResize THEN
        BEGIN
             LView.XorBox(TmpR);
             REPEAT
                   Event := GetEvent(TempE);
                   IF TempE.Key.ScanCode <> 0 THEN
                      BEGIN
                           LView.XorBox(TmpR);
                           Case TempE.Key.Scancode OF
                                Key_UpArrow    :  If TmpR.B.Y > (TmpR.A.Y + MinSize.Y) THEN
                                                     BEGIN
                                                          Dec(TmpR.B.Y,1);
                                                     END;
                                Key_DownArrow  :  If TmpR.B.Y < GetMaxY then
                                                     BEGIN
                                                          Inc(TmpR.B.Y,1);
                                                     END;
                                Key_RightArrow :  If TmpR.B.X < GetMaxX THEN
                                                     BEGIN
                                                          Inc(TmpR.B.X,1);
                                                     END;
                                Key_LeftArrow  :  If TmpR.B.X > (TmpR.A.X + MinSize.X) THEN
                                                     BEGIN
                                                          Dec(TmpR.B.X,1);
                                                     END;
                           END; { CASES }
                           LView.XorBox(TmpR);
                      END;
                   isDone := (TempE.Key.Scancode = Key_Enter) OR (TempE.Mouse.Event = 1);
             UNTIL isDONE;
             GOTO NextStep;
        END;


     { IF RESIZE USING MOUSE THEN }
     IF MOUSEINR(DIFP, R1) OR MOUSEINR(DIFP, R2) THEN    X:=1;
     IF MOUSEINR(DIFP, R3) THEN                          X:=2;
     IF MOUSEINR(DIFP, R4) OR MOUSEINR(DIFP, R5) THEN    X:=3;
     IF MOUSEINR(DIFP, R6) THEN                          X:=4;
     IF MOUSEINR(DIFP, R7) OR MOUSEINR(DIFP, R8) THEN    X:=5;
     IF MOUSEINR(DIFP, R9) THEN                          X:=6;
     IF MOUSEINR(DIFP, R10) OR MOUSEINR(DIFP, R11) THEN  X:=7;
     IF MOUSEINR(DIFP, R12) THEN                         X:=8;

     Case X OF
             1 : MouseMinMax(0, 0, TmpR.B.X - MinSize.X,TmpR.B.Y - MinSize.Y);
             2 : MouseMinMax(R3.A.X, 0, R3.B.X,TmpR.B.Y - MinSize.Y);
             3 : MouseMinMax(TmpR.A.X + MinSize.X, 0, GeTMaxX, TmpR.B.Y - MinSize.Y);
             4 : MouseMinMax(TmpR.A.X + MinSize.X, R6.A.Y, GetMaxX, R6.B.Y);
             5 : MouseMinMax(TmpR.A.X + MinSize.X,TmpR.A.Y + MinSize.Y, GetMaxX, GetMaxY);
             6 : MouseMinMax(R9.A.X , TmpR.A.Y + MinSize.Y, R3.B.X, GetMaxY);
             7 : MouseMinMax(0, TmpR.A.Y + MinSize.Y, TmpR.B.X - MinSize.X, GetMaxY);
             8 : MouseMinMax(0, R12.A.Y, TmpR.B.X - MinSize.X, R6.B.Y);
     END;

     { SELECT A MOUSE CURSOR DEPENDING ON AREA TO BE RESIZED }
     Case X OF
             1,5     : MouseCursor(MaskResizeBack, 7,7);
             3,7     : MouseCursor(MaskResizeForw, 7,7);
             2,6     : MouseCursor(MaskResizeVert, 7,7);
             4,8     : MouseCursor(MaskResizeHor , 7,7);
     END;

     LView.XorBox(TmpR);
     Repeat
           Event := GetEvent(TempE);
           If (OldP.X <> TempE.Mouse.P.X) OR
              (OldP.Y <> TempE.Mouse.P.Y) OR
              (TempE.Key.Scancode <> 0)
               then
                      BEGIN
                           LView.XorBox(TmpR);
                           IF X = 1 THEN
                                        BEGIN
                                             TmpR.A.X := TempE.Mouse.P.X;
                                             TmpR.A.Y := TempE.Mouse.P.Y;
                                             TmpR.B.X := TmpR.B.X;
                                             TmpR.B.Y := TmpR.B.Y;
                                        END;
                           IF X = 2 THEN
                                        BEGIN
                                             TmpR.A.X := TmpR.A.X;
                                             TmpR.A.Y := TempE.Mouse.P.Y;
                                             TmpR.B.X := TmpR.B.X;
                                             TmpR.B.Y := TmpR.B.Y;
                                        END;
                           IF X = 3 THEN
                                        BEGIN
                                             TmpR.A.X := TmpR.A.X;  
                                             TmpR.A.Y := TempE.Mouse.P.Y;
                                             TmpR.B.X := TempE.Mouse.P.X;
                                             TmpR.B.Y := TmpR.B.Y;
                                        END;
                           IF X = 4 THEN
                                        BEGIN
                                             TmpR.A.X := TmpR.A.X;
                                             TmpR.A.Y := TmpR.A.Y;
                                             TmpR.B.X := TempE.Mouse.P.X;
                                             TmpR.B.Y := TmpR.B.Y;
                                        END;
                           IF X = 5 THEN
                                        BEGIN
                                             TmpR.A.X := TmpR.A.X;
                                             TmpR.A.Y := TmpR.A.Y;
                                             TmpR.B.X := TempE.Mouse.P.X;
                                             TmpR.B.Y := TempE.Mouse.P.Y;
                                        END;
                           IF X = 6 THEN
                                        BEGIN
                                             TmpR.A.X := TmpR.A.X;
                                             TmpR.A.Y := TmpR.A.Y;
                                             TmpR.B.X := TmpR.B.X;
                                             TmpR.B.Y := TempE.Mouse.P.Y;
                                        END;
                           IF X = 7 THEN
                                        BEGIN
                                             TmpR.A.X := TempE.Mouse.P.X;
                                             TmpR.A.Y := TmpR.A.Y;
                                             TmpR.B.X := TmpR.B.X;
                                             TmpR.B.Y := TempE.Mouse.P.Y;
                                        END;
                           IF X = 8 THEN
                                        BEGIN
                                             TmpR.A.X := TempE.Mouse.P.X;
                                             TmpR.A.Y := TmpR.A.Y;
                                             TmpR.B.X := TmpR.B.X;
                                             TmpR.B.Y := TmpR.B.Y;
                                        END;
                           LView.XorBox(TmpR);
                           OldP := TempE.Mouse.P;
                      END;
           isDone:= (TempE.Mouse.Event <> 1) AND (TempE.Mouse.Event <> 5) OR
                    (TempE.Key.Scancode = Key_Enter);
     Until isDone;
     { RESET TO ORIGINAL VALUES ALL MOUSE CONSTANTS }
     MouseMinMax(0,0,GetMaxX,GetMaxY);

     NextStep :
     MouseCursor(Standard, 1,1);
     LView.XorBox(TmpR);
     CMCommand := CMPaint;
     PaintR    := R;
     Self.R    := TmpR;
     SetAreas;
END;


Procedure LView.Clamp(VAR P : Point);
VAR
    DifP  : Point;
BEGIN
     DifP.X := (R.B.X - R.A.X);
     DifP.Y := (R.B.Y - R.A.Y);
     TempR := R;
     R.A.X := (R.A.X - P.X);
     R.A.Y := (R.A.Y - P.Y);
     R.B.X := (R.A.X + DifP.X);
     R.B.Y := (R.A.Y + DifP.Y);
END;

Procedure LView.UnClamp;
BEGIN
     R := TempR;
END;

Procedure LView.XorBox(VAR RR : Rect);
VAR
  Oldstyle: LineSettingsType;
  oldcolor: Word;

BEGIN
     Getlinesettings(Oldstyle);
     Setlinestyle(1,0,3);
                 {^---   CHANGE THIS NUMBER TO 0 IF YOU PREFER A SOLID LINE WHEN MOVING }
     oldcolor:=getcolor;
     Setcolor(White);
     Setwritemode(XORput);
     HideMouse;
     Rectangle(RR.A.X,RR.A.Y,RR.B.X,RR.B.Y);
     ShowMouse;
     {restore everything}
     Setcolor(oldcolor);
     with OldStyle do
     SetLineStyle(LineStyle, Pattern,
               Thickness);
     Setwritemode(Normalput);

END;


Procedure LView.ExplodeR;
CONST
    Step                : Integer = 20;
VAR
  LP, RP, Dif, Center   : Point;
  isDone                : Boolean;
  Counter, Iterator     : Integer;
BEGIN
     HideMouse;
     Center.X:=(R.B.X-R.A.X) DIV 2;
     Center.Y:=(R.B.Y-R.A.Y) DIV 2;
     Dif.X:= (R.B.X-R.A.X);
     Dif.Y:= (R.B.Y-R.A.Y);
     IF Dif.X > Dif.Y THEN Iterator:= Dif.X ELSE Iterator:=Dif.Y;
     LP.X:= Center.X - Step;
     LP.Y:= Center.Y - Step;
     RP.X:= Center.X + Step;
     RP.Y:= Center.Y + Step;
     SetWriteMode(XORPut);
     SetLineStyle(SolidLn,0,ThickWidth);
     Rectangle(LP.X,LP.Y,RP.X,RP.Y);
     Counter:=Step*2;
     REPEAT
           Rectangle(LP.X,LP.Y,RP.X,RP.Y);
           Dec(LP.X,Step);
           Dec(LP.Y,Step);
           Inc(RP.X,Step);
           Inc(RP.Y,Step);
           IF LP.X < R.A.X THEN LP.X :=R.A.X;
           IF LP.Y < R.A.Y THEN LP.Y :=R.A.Y;
           IF RP.X > R.B.X THEN RP.X :=R.B.X;
           IF RP.Y > R.B.Y THEN RP.Y :=R.B.Y;
           Inc(Counter,step*2);
           Rectangle(LP.X,LP.Y,RP.X,RP.Y);
           isDONE:= (Counter >= iterator);
     UNTIL isDONE;
    Rectangle(LP.X,LP.Y,RP.X,RP.Y);
    SetLineStyle(SolidLn,0,NormWidth);
    SetWriteMode(NORmalPut);
    ShowMouse;
END;


Procedure LView.DoMenu( VAR E : EvenType);
VAR
   MR, TPos ,
   TxtR ,
   TmpR      : Rect;
   P         : Pointer;
   Difx,
   Dify      : Integer;
   Size      : Integer;
   Pos       : Integer;
   IsDone    : Boolean;
   Event     : Boolean;
   Selected  : Boolean;
   X, N      : Integer;
   Th, Tw    : Integer;
  TextInfo   : TextSettingsType;
  TextYPos   : Integer;
  OldPos     : Integer;
  AColor     : Integer;
CONST
     MaxPos     : Word = 6;

TYPE
     BoolArray = ARRAY[1..6] of Boolean;
     MenuArray = ARRAY[1..6] of String;
     MenuForm  = RECORD
         CanSelect : BoolArray;
         MenuItem  : MenuArray;
     end;
VAR
    LMenu  : MenuForm;
BEGIN
     MouseCursor(Standard, 1,1);
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 10);
     SetTextJustify(LeftText, TopText);
     { SET UP MENU MATRIX }
     LMenu.MenuItem [1] := 'Restore';
     LMenu.CanSelect[1] := Maximized AND IsMaximizable;
     LMenu.MenuItem [2] := 'Maximize';
     LMenu.CanSelect[2] := (NOT Maximized) AND IsMaximizable;
     LMenu.MenuItem [3] := 'Close';
     LMenu.CanSelect[3] := IsCloseable;
     LMenu.MenuItem [4] := 'Move';
     LMenu.CanSelect[4] := IsMoveable   AND (NOT Maximized);
     LMenu.MenuItem [5] := 'Resize';
     LMenu.CanSelect[5] := IsResizable AND (NOT Maximized);
     LMenu.MenuItem [6] := 'Switch';
     LMenu.CanSelect[6] := True;

     DifX := 80;
     DifY := 110;
     MR.A.X:= MenuR.A.X;
     MR.B.X:= MenuR.A.X + DifX;
     MR.A.Y:= MenuR.B.Y;
     MR.B.Y:= MenuR.B.Y + DifY;

     { CHECK IF MENU WILL FIT INSIDE SCREEN, IF NOT MAKE IT FIT }
     If MR.B.X > GetMaxX then
        BEGIN
             MR.B.X := MenuR.B.X;
             MR.A.X := MR.B.X - DifX;
        END;
     If MR.B.Y > GetMaxY then
        BEGIN
             MR.B.Y := MenuR.A.Y;
             MR.A.Y := MR.B.Y - DifY;
        END;
     { PUSH DOWN THE MENU BUTTON }
     MenuButton(False);
     { DETERMINE THE SIZE OF IMAGE TO BE SAVED,
       !!!!  REMEMBER THE LIMIT IS 64 Kb !!!! }
     Size := ImageSize(MR.A.X, MR.A.Y, MR.B.X, MR.B.Y);
     { GET MEMORY CHUNK FROM HEAP }
     GetMem(P, Size);
     HideMouse;
     { SAVE THE IMAGE UNDER THE MENU }
     GetImage(MR.A.X, MR.A.Y, MR.B.X, MR.B.Y, P^);
     { DRAW A NICE RECTANGLE FOR MENU }
     BevelR (MR.A.X, MR.A.Y, MR.B.X, MR.B.Y, White, White, lightgray, 2);
     TxtR.A.X := MR.A.X+3;
     TxtR.A.Y := MR.A.Y+3;
     TxtR.B.X := MR.B.X-3;
     TxtR.B.Y := MR.B.Y-3;
     { SET FONT AND STUFF }
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 5);
     SetTextJustify(LeftText, TopText);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     DifY := (TxtR.B.Y - TxtR.A.Y);
     TextYPos:= (DifY DIV MaxPos);
     N := TxtR.A.Y;
     { DISPLAY MENU ITEMS IN MENU WINDOW }
     FOR X:=1 TO MaxPos DO
         BEGIN
              If LMenu.CanSelect[X] then AColor := white ELSE AColor := 8;
              SetColor(AColor);
              OutTextXY(TxtR.A.X + 10, N, LMenu.MenuItem [X]);
              N:=(N + TextYPos);
         END;
     { CALCULATE THE RECT TO FOLLOW MENU OPTIONS AND DISPLAY STATUS }
     { THE Y POSITION WILL BE CALCULATED DYNAMICALLY IN LOOP BELOW }
     Pos := 1;
     TPos.A.X := TxtR.A.X;
     TPos.A.Y := TxtR.A.Y;
     TPos.B.X := TxtR.B.X;
     TPos.B.Y := TxtR.A.Y + TextYPos; 
     BevelR(TPos.A.X, TPos.A.Y, TPos.B.X, TPos.B.Y,
            white, 8, lightgray, 2);
     If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
     SetColor(AColor);
     OutTextXY(TPos.A.X + 9, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
     ShowMouse;
     IF E.Mouse.Event = 1 THEN
     { IF MOUSE IS MAINTAINED PRESSED, WAIT FOR RELEASE IN THIS LOOP }
     REPEAT
           Event := GetEvent (E);
           { A MOUSE EVENT = 2 IS LEFT MOUSE RELEASED, CHECK EVENT CODES IN EMOUSE LIBRARY }
     UNTIL (E.Key.ScanCode <> 0) OR (E.Mouse.Event = 2);
     { CLEAR EVENT TO BEGIN NEW MESSAGING }
     ClearEvent(E);
     
     REPEAT
           Event := GetEvent (E);
           { DO THE MENU STUFF HERE }
           {    POS 1 = RESTORE     }
           {    POS 2 = MAXIMIZE    }
           {    POS 3 = CLOSE       }
           {    POS 4 = MOVE        }
           {    POS 5 = RESIZE      }
           {    POS 6 = SWITCH      }
           If MouseinR(E.Mouse.P, TXTR) THEN
              BEGIN
                   TmpR   := Tpos;
                   OldPos := Pos;
                   N := TxtR.A.Y;
                   FOR X :=1 TO MaxPos DO
                       BEGIN
                            { FIND IF MOUSE IN SELECTION AREA }
                            IF (E.Mouse.P.Y > N) AND (E.Mouse.P.Y < N+TextYPos) then Pos := X;
                            Inc(N,TextYPos);
                       END;
                   If Pos < 1 then      Pos := 1;
                   If Pos > MaxPos then Pos := MaxPos;
                   If Pos = 1 then TPos.A.Y := TxtR.A.Y ELSE
                   TPos.A.Y := TxtR.A.Y + (TextYPos * (Pos-1));
                   TPos.B.Y := (TPos.A.Y + TextYPos);
                   { IF MOUSE POSITION HAS CHANGED THEN UPDATE SELECTION }
                   IF (Pos <> OldPos) then
                      BEGIN
                           HideMouse;
                           FillR (TmpR, LightGray);
                           If LMenu.CanSelect[OldPos] then AColor := white ELSE AColor := 8;
                           SetColor(AColor);
                           OutTextXY(TmpR.A.X + 7, TmpR.A.Y + 2, LMenu.MenuItem[OldPos]);
                           BevelR (TPos.A.X, TPos.A.Y, TPos.B.X, TPos.B.Y,
                                   white, 8, lightgray, 2);
                           If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
                           SetColor(AColor);
                           OutTextXY(TPos.A.X + 9, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
                           ShowMouse;
                      END;
              END;
              { IF USER SELECTED ARROW KEYS THEN BROWSE THROUGH SELECTIONS }
              Case E.Key.ScanCode of
                   Key_UpArrow   : Begin
                                        HideMouse;
                                        FillR (TPos, LightGray);
                                        If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
                                        SetColor(AColor);
                                        OutTextXY(TPos.A.X + 7, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
                                        Dec(Pos);
                                        If Pos < 1 then Pos := MaxPos;
                                        If Pos = 1 then TPos.A.Y := TxtR.A.Y ELSE
                                        TPos.A.Y := TxtR.A.Y+ (TextYPos * (Pos-1));
                                        TPos.B.Y := (TPos.A.Y + TextYPos);
                                        BevelR(TPos.A.X, TPos.A.Y, TPos.B.X, TPos.B.Y,
                                                white, 8, lightgray, 2);
                                        If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
                                        SetColor(AColor);
                                        OutTextXY(TPos.A.X + 9, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
                                        ShowMouse;
                                   end;

                   Key_DownArrow : Begin
                                        HideMouse;
                                        FillR (TPos, LightGray);
                                        If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
                                        SetColor(AColor);
                                        OutTextXY(TPos.A.X + 7, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
                                        Inc(Pos);
                                        If Pos > MaxPos then Pos := 1;
                                        If Pos < 1 then Pos := MaxPos;
                                        If Pos = 1 then TPos.A.Y := TxtR.A.Y ELSE
                                        TPos.A.Y := TxtR.A.Y + (TextYPos * (Pos-1));
                                        TPos.B.Y := (TPos.A.Y + TextYPos);
                                        BevelR(TPos.A.X, TPos.A.Y, TPos.B.X, TPos.B.Y,
                                                white, 8, lightgray, 2);
                                        If LMenu.CanSelect[Pos] then AColor := white ELSE AColor := 8;
                                        SetColor(AColor);
                                        OutTextXY(TPos.A.X + 9, TPos.A.Y + 2, LMenu.MenuItem[Pos]);
                                        ShowMouse;
                                   end;
           END;
           { SELECTED MEANS THE USER CHOOSE A MENU SELECTION WITH MOUSE OR HITTING ENTER KEY }
           Selected := (E.Key.ScanCode = Key_Enter) OR (E.Mouse.Event = 1) AND MouseinR(E.Mouse.P, TxtR);
           IsDONE:= (E.Key.ScanCode = Key_Enter) AND LMenu.CanSelect[Pos] OR (E.Key.ScanCode = Key_Esc) OR
                    (E.Mouse.Event = 1) AND LMenu.CanSelect[Pos] OR (E.Mouse.Event = 1) AND (NOT MouseinR(E.Mouse.P, TxtR));
     UNTIL IsDONE;

     { RESTORE SCREEN AREA UNDER MENU }
     HideMouse;
     PutImage(MR.A.X, MR.A.Y, P^, NormalPut);
     ShowMouse;
     { RELEASE MEMORY FROM HEAP }
     FreeMem(P, Size);
     { PUSH UP AGAIN THE MENU BUTTON }
     MenuButton(True);
     { RESTORE TEXT SETTINGS }
     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
     { HANDLE MENU SELECTION }
     If Selected then
        BEGIN
           {    POS 1 = RESTORE     }
           {    POS 2 = MAXIMIZE    }
           {    POS 3 = CLOSE       }
           {    POS 4 = MOVE        }
           {    POS 5 = RESIZE      }
           {    POS 6 = SWITCH      }
             Case Pos of
                  1 : BEGIN
                           { MESSAGE TO VIEW }
                           E.Command := CMRestore;
                           Restore(E);
                      END;
                  2 : BEGIN
                           { MESSAGE TO VIEW }
                           E.Command := CMMaximize;
                           Maximize(E);
                      END;
                      { SEND APPLICATION A CLOSE COMMAND FOR THIS VIEW }
                  3 : CMCommand := CMClose;
                  4 : BEGIN
                           { MESSAGE TO VIEW }
                           E.Command := CMMove;
                           Move(E);
                      END;
                  5 : BEGIN
                           { MESSAGE TO VIEW }
                           E.Command := CMResize;
                           Resize(E);
                      END;
                      { CALL THE SWITCH TASK WINDOW }
                  6 : CMCommand := CMSwitch;
             END; { END OF CASES }
        END;      { END OF SELECTED CHOICE }
END;    { END OF MENU PROCEDURE }


Procedure LView.Idle;
BEGIN
END;


Procedure LView.HandleEvent(VAR E : Eventype);
VAR
   X         : Integer;
   TmpR1, TmpR2     : Rect;
   Found     : Boolean;


BEGIN
     PaintR := R;

     { CHECK FIRST FOR ANY KEY PRESSED }
     If E.Key.ScanCode <> 0 then
                                BEGIN
                                     IF (E.Key.ScanCode = CMMenu) THEN DoMenu(E);
                                END;
     { IF MOUSE IS MOVING ON ANY OF THE PREDETERMINED AREAS THEN CHANGE MOUSE CURSOR }
     IF (E.Mouse.Event = 5) THEN
        BEGIN
             For X := 1 to ViewCount do
                 Begin
                      If MouseinR(E.Mouse.P, ViewList.RectList[X]) AND (Place <> X)
                      then
                          Begin
                               MouseCursor(ViewList.MaskList[X], ViewList.P[X].X, ViewList.P[X].Y);
                               Place := X;
                          end;
                 end;
             If (NOT MouseinR(E.Mouse.P, R)) AND (Place <> 0)
                then
                    Begin
                         MouseCursor(Standard,1,1);
                         Place := 0;
                    end;
        END;


     { IF MOUSE BUTTON PRESSED }
     If (E.Mouse.Event = 1) THEN
                                BEGIN
                                     { IF MOUSE PRESSED ON MOVE AREA THEN SEND MOVE MESSAGE }
                                     IF MouseinR(E.Mouse.P, TitleR)
                                        THEN
                                            BEGIN
                                                 Move(E);
                                                 ClearEvent(E);
                                            END;
                                     { IS MOUSE PRESSED ON MENU AREA THEN SEND MENU DISPLAY MESSAGE }
                                     IF MouseinR(E.Mouse.P, MenuR)
                                        THEN
                                             BEGIN
                                                  DoMenu(E);
                                                  ClearEvent(E);
                                             END;
                                     { IF MOUSE PRESSED ON MAXIMIZE AREA THEN MAXIMIZE OR RESTORE ACCORDINGLY }
                                     If MouseinR(E.Mouse.P, MinMaxR)
                                        THEN
                                            BEGIN
                                                 IF (NOT MAXIMIZED) THEN Maximize(E)
                                                 ELSE Restore(E);
                                                 ClearEvent(E);
                                            END;

                                     { IF MOUSE ON ANY OF THE RESIZE AREAS THEN SEND RESIZE MESSAGE }
                                     If MouseinR(E.Mouse.P, R1)  OR
                                        MouseinR(E.Mouse.P, R2)  OR
                                        MouseinR(E.Mouse.P, R3)  OR
                                        MouseinR(E.Mouse.P, R4)  OR
                                        MouseinR(E.Mouse.P, R5)  OR
                                        MouseinR(E.Mouse.P, R6)  OR
                                        MouseinR(E.Mouse.P, R7)  OR
                                        MouseinR(E.Mouse.P, R8)  OR
                                        MouseinR(E.Mouse.P, R9)  OR
                                        MouseinR(E.Mouse.P, R10) OR
                                        MouseinR(E.Mouse.P, R11) OR
                                        MouseinR(E.Mouse.P, R12)   
                                     THEN { RESIZE VIEW IF VIEW NOT MAXIMIZED }
                                         BEGIN
                                               Resize(E);
                                               ClearEvent(E);
                                         END;
                                END;

    LView.Idle;
END;


Procedure LView.MakeLocal(VAR Rin, Rout : Rect);
BEGIN
     { CLIP DRAWING COORDINATES TO CURRRENT VIEW }
     Rout.A.X := (WorkR.A.X + Rin.A.X);
     Rout.A.Y := (WorkR.A.Y + Rin.A.Y);
     Rout.B.X := (WorkR.A.X + Rin.B.X);
     Rout.B.Y := (WorkR.A.Y + Rin.B.Y);
     IF Rout.A.X > WorkR.B.X THEN Rout.A.X := WorkR.B.X;
     IF Rout.A.Y > WorkR.B.Y THEN Rout.A.Y := WorkR.B.Y;
     IF Rout.A.X < WorkR.A.X THEN Rout.A.X := WorkR.A.X;
     IF Rout.A.Y < WorkR.A.Y THEN Rout.A.Y := WorkR.A.Y;

     IF Rout.B.X > WorkR.B.X THEN Rout.B.X := WorkR.B.X;
     IF Rout.B.Y > WorkR.B.Y THEN Rout.B.Y := WorkR.B.Y;
     IF Rout.B.X < WorkR.A.X THEN Rout.B.X := WorkR.A.X;
     IF Rout.B.Y < WorkR.A.Y THEN Rout.B.Y := WorkR.A.Y;
END;

Procedure LView.FitR ( VAR RL1, RL2 : Rect);
VAR
   TP : Point;
BEGIN
     TP.X := (RL1.B.X - RL1.A.X);
     TP.Y := (RL1.B.Y - RL1.A.Y);
     IF RL2.A.X < 0 THEN RL2.A.X := 0;
     IF RL2.A.Y < 0 THEN RL2.A.Y := 0;
     IF RL2.A.X > TP.X THEN RL2.A.X := TP.X;
     IF RL2.A.Y > TP.Y THEN RL2.A.Y := TP.Y;

     IF RL2.B.X < 0 THEN RL2.B.X := 0;
     IF RL2.B.Y < 0 THEN RL2.B.Y := 0;
     IF RL2.B.X > TP.X THEN RL2.B.X := TP.X;
     IF RL2.B.Y > TP.Y THEN RL2.B.Y := TP.Y;
END;


Procedure LView.PLine(X, Y, X1, Y1: Integer);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     Rin.B.X := X1;
     Rin.B.Y := Y1;
     MakeLocal (Rin, Rout);
     Graph.Line(Rout.A.X, Rout.A.Y, Rout.B.X, Rout.B.Y);
END;

Procedure LView.PLineTo(X, Y : Integer);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     MakeLocal (Rin, Rout);
     Graph.Lineto(Rout.A.X, Rout.A.Y);
END;

Procedure LView.PBar(X, Y, X1, Y1: Integer);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     Rin.B.X := X1;
     Rin.B.Y := Y1;
     MakeLocal (Rin, Rout);
     FillR(Rout, GetColor);
END;

Procedure LView.PMoveto(X, Y: Integer);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     MakeLocal (Rin, Rout);
     Graph.Moveto(Rout.A.X, Rout.A.Y);
END;

Procedure LView.PRectangle(X, Y, X1, Y1: Integer);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     Rin.B.X := X1;
     Rin.B.Y := Y1;
     MakeLocal (Rin, Rout);
     Graph.Rectangle(Rout.A.X, Rout.A.Y, Rout.B.X, Rout.B.Y);
END;


Procedure LView.PPutPixel(X, Y: Integer; Pixel: Word);
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     MakeLocal (Rin, Rout);
     Graph.PutPixel(Rout.A.X, Rout.A.Y, Pixel);
END;

Function LView.PGetPixel(X,Y : Integer): Word;
VAR
   Rin, Rout  : Rect;
BEGIN
     Rin.A.X := X;
     Rin.A.Y := Y;
     MakeLocal (Rin, Rout);
     PGetPixel:=Graph.GetPixel(Rout.A.X, Rout.A.Y);
END;



Destructor LView.Done;
BEGIN
END;



CONSTructor LWindow.Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string; color,back:Integer);
BEGIN
     LView.Init(X,Y,X1,Y1, anID, atitle);
END;

Destructor LWindow.Done;
BEGIN
     LView.Done;
END;





CONSTructor LTTYWindow.Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
BEGIN
     LView.Init(X,Y,X1,Y1, anID, atitle);
     TextBackground := Black;
     TextColor      := White;
     CWinWR         := Black;
     Xpos := WorkR.A.X;
     Ypos := WorkR.A.Y;
END;

Procedure LTTYWindow.FitCursorPos;
BEGIN
     { FORCE CURSOR POSITION INTO VIEW }
     IF Xpos < WorkR.A.X THEN Xpos := WorkR.A.X;
     IF Ypos < WorkR.A.Y THEN Ypos := WorkR.A.Y;
     IF Xpos > WorkR.B.X THEN Xpos := WorkR.B.X;
     IF Ypos > WorkR.B.Y THEN Ypos := WorkR.B.Y;
END;

Procedure LTTYWindow.SetTextColor (Acolor : integer);
BEGIN
      TextColor := Acolor;
END;

Procedure LTTYWindow.SetTextBackground (Acolor : integer);
BEGIN
      TextBackGround := Acolor;
      CWinWR         := Acolor;
END;


Procedure LTTYWindow.HandleEvent(VAR E : Eventype);
VAR
    tw,th              : Integer;
    TextInfo           : TextSettingsType;
    ClearR             : Rect;
    OldColor           : Integer;
    OldFill            :  FillSettingsType;
CONST
     space : integer = 3;
BEGIN
      LView.HandleEvent(E);
      GetTextSettings(TextInfo);
      SetTextStyle(SmallFont, 0, 5);
      SetTextJustify(LeftText, TopText);
      Tw:=TextWidth('M');
      Th:=TextHeight('M');
      Th := Th + space;
      OldColor := GetColor;
      GetFillSettings(OldFill);
      Setfillstyle(1,TextBackGround);
      SetColor(TextColor);
      FitCursorPos;
      If (E.Key.ScanCode <> 0) AND E.Key.ASCII then
         BEGIN
              Moveto(Xpos,Ypos);
              Inc(Xpos,Tw);
              If Xpos > (WorkR.B.X - Tw) then
                 Begin
                      Xpos:=WorkR.A.X;
                      Inc(Ypos, Th);
                 end;
              If Ypos > (WorkR.B.Y - Th) then
                 Begin
                      Xpos := WorkR.A.X;
                      Ypos := WorkR.A.Y;
                 end;
              HideMouse;
              ClearR.A.X := Xpos;
              ClearR.A.Y := Ypos;
              ClearR.B.X := Xpos + Tw;
              ClearR.B.Y := Ypos + Th;
              Bar(ClearR.A.X, ClearR.A.Y + 2, ClearR.B.X - 1, ClearR.B.Y);
              OutTextXY(Xpos,Ypos,E.Key.CharCode);
              ShowMouse;
         END;
      SetColor(OldColor);
      With TextInfo do
           BEGIN
                SetTextJustify(Horiz, Vert);
                SetTextStyle(Font, DiRection, CharSize);
           END;
      With OldFill do
      SetFillStyle(Pattern, Color);
END;


Destructor LTTYWindow.Done;
BEGIN
     LView.Done;
END;



CONSTructor LDialog.Init (X,Y,X1,Y1 : Integer; anID : Integer; atitle: string);
BEGIN
     LView.Init (X,Y,X1,Y1 ,anID,atitle);
     ObjCount := 0;
     Focused  := 0;
     { DIALOGS BY DEFAULT CAN NOT BE RESIZED, THIS CAN BE OVERRIDE YF YOU DECIDE TO RESIZE }
     CanResize (FALSE);
END;

Procedure LDialog.Paint;
VAR
   N : Integer;
BEGIN
      LView.Paint;
      IF ObjCount = 0 THEN EXIT ELSE
      { IF NO CONTROLS ADDED TO WINDOW THEN EXIT HERE }
      FOR N := 1 to ObjCount do
      { ELSE PAINT AND SET FOCUS TO CONTROLS }
          BEGIN
                ObjList[N]^.GetOwnerR(R);
                ObjList[N]^.Paint;
                ObjList[N]^.SetFocus(false);
      { BY DEFAULT ALL CONTROLS ARE DISABLE TO BEGIN WITH }
          END;
END;

Procedure LDialog.Insert(P : Pointer);
VAR
   TmpE : Eventype;
   TmpR  : Rect;
BEGIN
     if ObjCount <> 0 then
        ObjList[ObjCount]^.SetFocus(False);
     { CHANGE FOCUS TO NEW CONTROL }
     Inc(ObjCount,1);
     Focused :=  ObjCount;
     ObjList[ObjCount] := P;
     { ADD THE CONTROL TO PointER LIST }
     ObjList[ObjCount]^.GetOwnerR (WorkR);
     TmpR:= ObjList[ObjCount]^.R;
     FitR (WorkR, TmpR);
     ObjList[ObjCount]^.SetR (TmpR);
     ObjList[ObjCount]^.Move (TmpE);
     { MAKE SURE CONTROL WILL INSIDE WINDOW }
     ObjList[ObjCount]^.Paint;
     { PAINT THE CONTROL }
END;

Procedure LDialog.Delete(P : PLView);
BEGIN
     IF ObjCount = 0 THEN EXIT ELSE
     ObjList[ObjCount]^.Done;
     Dispose(ObjList[ObjCount],Done);
     { DELETE THE CONTROL WITH FOCUS }
     Dec(ObjCount,1);
     { DECREMENT THE CONTROL LIST NUMBER }
     Focused := ObjCount;
END;


Procedure LDialog.Move( VAR E : Eventype);
VAR
   N      : Integer;
BEGIN
     LView.Move(E);
     { GET NEW WINDOW LOCATION }
     IF ObjCount = 0 THEN EXIT ELSE
        For N:=1 to ObjCount do
        { MOVE ALL THE CONTROLS WITH WINDOW }
            BEGIN
                 ObjList[N]^.GetOwnerR(WorkR);
                 ObjList[N]^.Move(E);
            END;
END;

Procedure LDialog.Resize( VAR E : Eventype);
VAR
   N      : Integer;
   TmpR   : Rect;
BEGIN
     LView.Resize(E);
END;

Procedure LDialog.Maximize;
VAR
   N : Integer;
BEGIN
     LView.Maximize(E);
     IF ObjCount = 0 THEN EXIT ELSE
        For N:=1 to ObjCount do
        { MOVE ALL THE CONTROLS WITH WINDOW }
            BEGIN
                 ObjList[N]^.GetOwnerR(WorkR);
                 ObjList[N]^.Move(E);
            END;
END;

Procedure LDialog.Restore;
VAR
   N : Integer;
BEGIN
     LView.Restore(E);
     IF ObjCount = 0 THEN EXIT ELSE
        For N:=1 to ObjCount do
        { MOVE ALL THE CONTROLS WITH WINDOW }
            BEGIN
                 ObjList[N]^.GetOwnerR(WorkR);
                 ObjList[N]^.Move(E);
            END;
END;


Function LDialog.GetDC : PLView;
BEGIN
     If ObjCount = 0 then GetDC := NIL ELSE
     GetDC:= ObjList[ObjCount];
END;


Function LDialog.GetView(VAR P:Point): Integer;
VAR
   n          : Integer;
   isdone,
   inr        : Boolean;
   RR         : Rect;
   WinFound   : Integer;
BEGIN
     IF ObjCount = 0 THEN EXIT ELSE
     { IF STACK IS EMPTY THEN EXIT ELSE }
     N:=ObjCount;
     WinFound:=0;
     InR := False;
     
     REPEAT
           RR := ObjList[N]^.R;
           InR:=MouseinR(P, RR);
           If InR then WinFound:=N;
           Dec(N);
           IsDONE:=InR or (N = 0);
     UNTIL IsDONE;

     If InR then GetView := WinFound else GetView := 0;
     GetView := WinFound;
END;

Procedure LDialog.Clamp(VAR P : Point);
VAR
    N : Integer;
BEGIN
     LView.Clamp(P);
     { CLAMP TO VIEWPORT FOR REDRAWING }
     IF ObjCount = 0 THEN EXIT ELSE
     { CLAMP ALL CONTROLS TO VIEWPORT FOR REDRAWING }
        for n:= 1 to ObjCount do
            ObjList[N]^.Clamp(P);
END;

Procedure LDialog.UnClamp;
VAR
   N : Integer;
BEGIN
     LView.UnClamp;
     { RESTORE VIEWPORT TO WHOLE SCREEN }
     IF ObjCount = 0 THEN EXIT ELSE
        for n:= 1 to ObjCount do
        { SAME FOR ALL CONTROLS }
            ObjList[N]^.UnClamp;
END;

Procedure LDialog.RotateTop(N:Integer);
VAR
   X,Z      : Integer;
BEGIN
     IF ObjCount = 0 THEN EXIT ELSE
     Z:=1;
     { SAME AS IN APPLICATION }
     For X:=1 to ObjCount do
              if X <> N then
                            BEGIN
                                 TempList[Z] := ObjList[X];
                                 Inc(Z);
                            END;
    TempList[ObjCount] := ObjList[N];
    For Z:=1 to ObjCount do Objlist[Z]:= TempList[Z];
END;


Procedure LDialog.HandleEvent(VAR E : Eventype);
VAR
   N : Integer;
   P : PLView;

BEGIN
     LView.HandleEvent(E);
     IF ObjCount = 0 THEN EXIT ELSE
     If (E.Key.ScanCode = Key_Tab)
     AND (ObjCount <> 0) then
     { TAB ONE BY ONE ALL THE CONTROLS, CHANGE FOCUS }
        BEGIN
             ObjList[ObjCount]^.SetFocus(False);
             Dec (Focused,1);
             If Focused < 1 then Focused := ObjCount;
             If Focused > ObjCount then Focused := 1;
             ObjList[Focused]^.SetFocus(True);
             RotateTop(Focused);
        END;

     IF (E.Mouse.Event = 1) AND MouseInR(E.Mouse.P, R)
        then
     { GET CONTROL WITH MOUSE CLICK }
        BEGIN
             N := GetView(E.Mouse.P);
             IF N <> 0 THEN
                           BEGIN
                                ObjList[ObjCount]^.SetFocus(FALSE);
                                { DISABLE THE CONTROL WITH FOCUS }
                                ObjList[N]^.Paint;
                                { PAINT THE NEW CONTROL }
                                RotateTop(N);
                                { ROTSTE THE FOCUS TO THE CONTROL }
                                P := GetDC;
                                IF P <> NIL then
                                P^.HandleEvent (E);
                           END;
        END;
     IF (E.Key.ScanCode <> 0) then
     { SEND KEY PRESSED TO CONTROL HANDLE EVENT METHOD }
        BEGIN
             P := GetDC;
             IF P <> NIL then
                P^.HandleEvent (E);
        END;
END;

Destructor LDialog.Done;
VAR
   N : Integer;
BEGIN
     IF ObjCount <> 0 THEN 
     { DESTROY ALL CONTROL AND RELEASE MEMORY }
       for N :=1 to ObjCount do ObjList[N]^.Done;
     LView.Done;
     { DESTROY DIALOG }
END;



CONSTructor LControl.Init(X,Y,X1,Y1 : Integer);
VAR
    DifX, DifY : Integer;

BEGIN
     R.A.X := X;
     R.A.Y := Y;
     R.B.X := X1;
     R.B.Y := Y1;
     { SET RectANGLE LIMITS }
     MinSize.X := 40;
     MinSize.Y := 40;
     DifX:=(R.B.X-R.A.X);
     DifY:=(R.B.Y-R.A.Y);
     { SET MINIMUM SIZE OF CONTROL }
     If (DifX < MinSize.X) then R.B.X:= R.A.X + MinSize.X;
     If (DifY < MinSize.Y) then R.B.Y:= R.A.Y + MinSize.Y;
     { OFFSET FROM SCREEN ORIGIN }
     OffsetX := R.A.X;
     OffSetY := R.A.Y;
     If OffsetX < 0 then OffsetX := 0;
     If OffsetY < 0 then OffsetY := 0;
END;

Procedure LControl.Move(VAR E: EvenType);
VAR
   DIF   : Point;
BEGIN
     { MOVE CONTROL RELATIVE TO OWNER }
     DIF.X := (R.B.X - R.A.X);
     DIF.Y := (R.B.Y - R.A.Y);
     R.A.X := (OwnerR.A.X + OffSetX);
     R.A.Y := (OwnerR.A.Y + OffSetY);
     { THE OFFSET IS THE DIFFERENCE BETWEEN THE REAL SCREEN ORIGIN AND THE ACTUAL
       POSITION OF THE CONTROL }
     R.B.X := (R.A.X + DIF.X);
     R.B.Y := (R.A.Y + DIF.Y);
END;

Procedure LControl.SetFocus(OnOff : Boolean);
BEGIN
     { OVERRIDE THIS METHOD DEPENDING ON THE CONTROL TYPE }
END;


Destructor LControl.Done;
BEGIN
END;




CONSTructor LButton.Init(X,Y,X1,Y1 : Integer; wide : Integer; Atitle : String; Acolor: Integer);
VAR
    DifX, DifY : Integer;
BEGIN
     LControl.Init(X,Y,X1,Y1);
     Title  := ATitle;
     Color  := Acolor;
     TColor := 8;
     Ispushed := False;
     Margin := Wide;
     Key:=GetAKey;
END;


Procedure LButton.Paint;
VAR
   OldFill      :  FillSettingsType;
   OldColor     : Integer;
   Difx,dify,
   Xpos, Ypos,
   st, space,
   tw,th        : Integer;
   Atitle       : string;
   TextInfo     : TextSettingsType;
BEGIN
     IF (R.A.X < OWNERR.A.X) OR (R.B.X > OWNERR.B.X)
     OR (R.A.Y < OWNERR.A.Y) OR (R.B.Y > OWNERR.B.Y) THEN EXIT;
     HideMouse;
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 5);
     OldColor:=GetColor;
     BevelR(R.A.X, R.A.Y, R.B.X, R.B.Y, white, 8, lightgray, Margin);
     DifX:=(R.B.X-R.A.X);
     DifY:=(R.B.Y-R.A.Y);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     Atitle := Title;
     St:=Length(Atitle) * Tw;
     Space:=(DifX div Tw) - Margin;
     if St > Space then Delete(Atitle,Space+1,(St div Tw) - Space);
     St:=length(Atitle) * Tw;
     Xpos:=(R.A.X + (DifX DIV 2)) - (St DIV 2);
     Ypos:=(R.A.Y + (DifY DiV 2)) - Th;
     SetColor(TColor);
     OutTextXY(Xpos,Ypos, Atitle);
     SetColor(OldColor);
     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
     ShowMouse;
END;
     


Procedure LButton.Push;
VAR
   OldFill      :  FillSettingsType;
   OldColor     : Integer;
   Difx,dify,
   Xpos, Ypos,
   st, space,
   tw,th        : Integer;
   Atitle       : string;
   TextInfo     : TextSettingsType;
BEGIN
     IF (R.A.X < OWNERR.A.X) OR (R.B.X > OWNERR.B.X)
     OR (R.A.Y < OWNERR.A.Y) OR (R.B.Y > OWNERR.B.Y) THEN EXIT;
     HideMouse;
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 5);
     OldColor:=GetColor;
     BevelR(R.A.X, R.A.Y, R.B.X, R.B.Y, 8, white, lightgray, Margin);
     difx:=(R.B.X-R.A.X);
     dify:=(R.B.Y-R.A.Y);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     Atitle := Title;
     St:=length(Atitle) * Tw;
     Space:=(difx div Tw)-Margin;
     if St > Space then Delete(Atitle,Space+1,(St div Tw) - Space);
     St:=Length(Atitle) * Tw;
     Xpos:=(R.A.X + (DifX DIV 2)) - (St DIV 2);
     Ypos:=(R.A.Y + (DifY DiV 2)) - Th;
     SetColor(Black);
     OutTextXY(Xpos+5,Ypos+5, Atitle);
     SetColor(OldColor);
     ShowMouse;
     IsPushed := True;
     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
END;

Procedure LButton.SetFocus(OnOff : Boolean);
BEGIN
     { CHANGE FOCUS IN BUTTON }
     { OVERRIDE TO DO SOMETHING DIFFERENT WITH EACH CONTROL TYPE }
     Case OnOff of
          TRUE   :
                 BEGIN
                      TColor := 8;
                      Paint;
                 END;

          FALSE  :
                 BEGIN
                      TColor := White;
                      Paint;
                      TColor := 8;
                 END;
     END;

END;



Function LButton.GetAKey: Word;

VAR
    position : byte;
    achar    : char;
    N        : Integer;
BEGIN
     { CHECK FOR SHORTCUT KEY IN BUTTON }
     position := Pos('&', Title);
     If position = 0 then EXIT
     ELSE
     for N:=1 to (position + 1) do achar:=Title[N];
     Delete(Title, position, 1);
     GetAKey := Word(achar);
END;


Procedure LButton.Move(VAR E: EvenType);
BEGIN
     LControl.Move(E);
END;

Procedure LButton.HandleEvent (VAR E : EvenType);
VAR
   TempE     :  Eventype;
   TmpR      :  Rect;
   DifP      :  Point;
   OldP      :  Point;
   DifX,
   DifY      :  Integer;
   Event     :  Boolean;
   isDone    :  Boolean;
BEGIN
     { THE HANDLEEVENT ONLY PUSHES IN AND OUT THE BUTTON }
     If ((E.Mouse.Event = 1) AND (MouseinR(E.Mouse.P, R)))
     OR (E.Key.ScanCode = Key_Enter) then
         BEGIN
              Push;
              Wait(100);
              Paint;
         END;

END;

Destructor LButton.Done;
BEGIN
END;


Constructor LViewLogo.Init;
BEGIN
      LDialog.Init(0,0,150,200, 0,'VIEWS-Manager');
      MinSize.X        := 150;
      MinSize.Y        := 80;
      LDIalog.CanClose(False);
      LDIalog.CanResize(True);
END;

Procedure LViewLogo.Draw;
VAR
   DifX                          : Word;
   Th, Tw, OldColor              : Word;
   MultX, MultY                  : Word;
   TextInfo                      : TextSettingsType;

BEGIN
     GetTextSettings(TextInfo);
     SetTextStyle(TriplexFont , 0, 1);
     SetTextJustify(LeftText, TopText);
     MultX := (WorkR.B.X - WorkR.A.X) DIV 90;
     MultY := (WorkR.B.Y - WorkR.A.Y) DIV 30;
     SetUserCharSize(MultX, 1, MultY, 1);
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     DifX := 20;
     SetColor(White);
     OutTextXY(WorkR.A.X + DifX, WorkR.A.Y, 'Views');
     SetColor(8);
     Inc(DifX);
     OutTextXY(WorkR.A.X + DifX, WorkR.A.Y + 1, 'Views');
     Inc(DifX);
     OutTextXY(WorkR.A.X + DIfX, WorkR.A.Y + 2, 'Views');
     Inc(DifX);
     OutTextXY(WorkR.A.X + DIfX, WorkR.A.Y + 3, 'Views');
     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
     SetColor(OldColor);
END;

Procedure LViewLogo.Idle;
Begin
     ExplodeR;
     beep;
end;

Destructor LViewLogo.Done;
BEGIN

END;




Function OkMsg (Msg : string): Word;
VAR
    DL       : PLDialog;
    B1, B2   : PLButton;

BEGIN

END;



CONSTructor LApp.Init;
VAR
   Gd       : Integer;
   ErrMsg   : String;

{############ MODE VIDEO TO GRAPHICS MODE, INITIALIZE AND LOAD BGI DRIVER ############}
FUNCTION InitDevice(Selection:Integer; GraphDriver,GraphMode:Integer) : Integer;
VAR
    GrDriver : Integer;
    GrMode   : Integer;
    ErrCode  : Integer;

BEGIN

{ ALL GRAPHICS MODES SUPPORTED BY THE DIFFERENT BGI DRIVERS }
{ Constant     Value and Comment

 CurrentDriver-128  For GetModeRange
 Detect          0  Requests autodetection
 CGA             1
 MCGA            2
 EGA             3
 EGA64           4
 EGAMono         5
 IBM8514         6
 HercMono        7
 ATT400          8
 VGA             9
 PC3270         10                         }   

 ErrCode:=0;
    Case Selection of
                     { AUTODETECT }
                     0: BEGIN
                             GrDriver := Detect;
                             InitGraph(GrDriver,GrMode,'');
                             ErrCode := GraphResult;
                        END;
                     { FORCE GRAPHICS MODE }
                     1: BEGIN
                             InitGraph(GraphDriver,GraphMode,'');
                             ErrCode := GraphResult;
                        END;
    END; { CASES }
   InitDevice:= ErrCode;  { CHECK IF ERROR }
END;

BEGIN
     Gd:= InitDevice(0,3,1);
                    {^-- 0 = AUTODETECT; 1 = FORCE MODE; SEE MODES IN TABLE ABOVE }
     { MOVE DEVICE TO GRAPHICS }
     ErrMsg := 'Graphics Device Error...  '+GraphErrorMsg(Gd);
     If Gd <> 0 then Quit(ErrMsg)
     { IF AN ERROR OCCURED THEN HALT PROGRAM AND PRINT ERROR }
     ELSE
     GraphicsMouse(standard,1,1);
     ShowMouse;
     { INITIALIZE MOUSE WITH PointTING ARROW }
     ObjCount:=0;
     APColor:=Black;
     TotalR.A.X := 0;
     TotalR.A.Y := 0;
     TotalR.B.X := GetMaxX;
     TotalR.B.Y := GetMaxY;
     New(Logo, Init);
     LApp.Insert(Logo);
END;

Procedure LApp.FillR (VAR RFill : Rect; color : Integer);
CONST
    Rarea : array[1..4] of PointType =
   ((X: 0; Y: 0),
    (X: 0; Y: 0),
    (X: 0; Y: 0),
    (X: 0; Y: 0));

VAR
    OldFill      :  FillSettingsType;
    OldColor     :  Integer;
BEGIN
      { SAME AS LVIEW }
      GetFillSettings(OldFill);
      OldColor := GetColor;
      Setfillstyle(1,Color);
      Rarea[1].X:= RFill.A.X;
      Rarea[1].Y:= RFill.A.Y;
      Rarea[2].X:= RFill.B.X;
      Rarea[2].Y:= RFill.A.Y;
      Rarea[3].X:= RFill.B.X;
      Rarea[3].Y:= RFill.B.Y;
      Rarea[4].X:= RFill.A.X;
      Rarea[4].Y:= RFill.B.Y;
      FillPoly(SizeOf(Rarea) DIV SizeOf(PointType), Rarea);
      With OldFill do
      SetFillStyle(Pattern, Color);
      SetColor(OldColor);
END;

Procedure LApp.Insert (P : PLView);
BEGIN
     { CHECK IF ENOUGH MEMORY FOR OPERATION }
     If MemAvail < 100 then
                           BEGIN
                                Beep;
                                EXIT;
                           END;


     { GET A NEW PLVIEW OBJECT IN ARRAY LIST }
     if ObjCount <> 0 then
     ObjList[ObjCount]^.SetFocus(False);
     Inc(ObjCount,1);
     ObjList[ObjCount] := P; { insert Pointer in object list of Pointers }
     ObjList[ObjCount]^.FitR (TotalR, ObjList[ObjCount]^.R);
     ObjList[ObjCount]^.SetR(ObjList[ObjCount]^.R);
     ObjList[ObjCount]^.Paint;
END;

Procedure LApp.Destroy(P : PLView);
BEGIN
     { DISPOSE OF PLVIEW FROM ARRAY LIST }
     If ObjCount = 0 then EXIT ELSE
     ObjList[ObjCount]^.Done;
     Dispose(ObjList[ObjCount],Done);
     Dec(ObjCount,1);
END;



Function LApp.GetDC : PLView;
BEGIN
     If ObjCount = 0 then GetDC := NIL ELSE
     GetDC:= ObjList[ObjCount];
END;

Procedure LApp.Draw;
VAR
    N  :  Integer;
BEGIN
     If ObjCount = 0 then EXIT ELSE
     HideMouse;
     ClearDevice;
     ShowMouse;
     for N:=1 to ObjCount-1 do
         BEGIN
              ObjList[N]^.Paint;
              ObjList[N]^.SetFocus(False);
         END;
     ObjList[ObjCount]^.Paint;
END;


Procedure LApp.Idle;
BEGIN
     { PUT ANYTHING HERE TO MIMICK MULTITASKING }
END;

Procedure LApp.RotateTop(n:Integer);
VAR
   X,Z      : Integer;
BEGIN
     Z:=1;
     { FIND THE VIEW TO ROTATE IN THE PointER ARRAY }
     For X:=1 to ObjCount do
              if X <> N then
                            BEGIN
                                 TempList[Z] := ObjList[X];
                                 Inc(Z);
                            END;
    TempList[ObjCount] := ObjList[N];
    For Z:=1 to ObjCount do Objlist[Z]:= TempList[Z];
END;

Function LApp.YesNoMsg (Msg : string): Word;
VAR
    Size                : Integer;
    Dx, Dy              : Integer;
    X, Y, X1, Y1        : Integer;
    Th, Tw              : Integer;
    TextInfo            : TextSettingsType;
    Width, OldColor     : Integer;
BEGIN
     GetTextSettings(TextInfo);
     SetTextStyle(SmallFont, 0, 5);
     SetTextJustify(LeftText, TopText);
     OldColor := GetColor;
     Tw:=TextWidth('M');
     Th:=TextHeight('M');
     
     Size  := Length(Msg);
     Width := Size * Tw;

     If Width > GetMaxX THEN
        BEGIN
             Delete(Msg,(Width DIV Tw) - Size, Size - ((Width DIV Tw) - 9));
             Size  := Length(Msg);
             Width := Size * Tw;
        END;

     X  := (GetMaxX DIV 2) - Width;
     X1 := X + (Width * 2);
     Y  := (GetMaxY DIV 2) - 60;
     Y1 := Y + 120;

     New(DL, Init(X, Y, X1, Y1, -1, Msg));
     DL^.CanMove    (False);
     DL^.CanResize  (False);
     DL^.CanMaximize(False);
     CanRotate := False;
     LApp.Insert(DL);
     SetColor(White);
     OutTextXY((X1-X) DIV 2 - (Width DIV 2), Y + 30, Msg);

     With TextInfo do
          BEGIN
               SetTextJustify(Horiz, Vert);
               SetTextStyle(Font, DiRection, CharSize);
          END;
END;




Function LApp.GetView(VAR P:Point): Integer;
VAR
   n          : Integer;
   isdone,
   inr        : Boolean;
   R          : Rect;
   WinFound   : Integer;
BEGIN
     If ObjCount = 0 then EXIT;
     { IF STACK IS EMPTY THEN EXIT ELSE }
     N:=ObjCount;
     WinFound:=0;
     InR := False;
     
     REPEAT
           { REPEAT UNTIL WINDOW IS FOUND OR EVENT IS ABANDONED }
           R := ObjList[N]^.R;
           { IS MOUSE CLICK IN WINDOW AREA ? }
           InR:=MouseinR(P, R);
           If InR then WinFound:=N;
           { SCAN FROM TOP OF STACK TO BOTTOM }
           Dec(N);
           IsDONE:=InR or (N = 0);
     UNTIL IsDONE;
     
     If InR and (WinFound <> ObjCount) then
     { IF WINDOW IS NOT FOCUSED ALREADY THEN }
                                           BEGIN
                                                IF NOT CanRotate then
                                                { FOCUS IS GRABED BY A WINDOW THEN }
                                                   BEGIN
                                                        Beep;
                                                        EXIT;
                                                   END;
                                                { ELSE IS OK TO ROTATE FOCUS THEN }
                                                ObjList[ObjCount]^.SetFocus(FALSE);
                                                ObjList[WinFound]^.Paint;
                                                LApp.RotateTop(WinFound);
                                           END;
     GetView := WinFound;
END;


Procedure LApp.SetView( VAR R : Rect);
BEGIN
     With VP do
     { WITH CURRENT VIEWPOORT DO }
          BEGIN
               { FRAME RectANGLE }
               SetViewPort(R.A.X, R.A.Y, R.B.X, R.B.Y, TRUE);
          END;
END;

Procedure LApp.Paint (VAR R : Rect);
VAR
    N          :  Integer;
    ViewPoint  :  Point;
BEGIN
     If ObjCount = 0 then
     { CLEAR DEVICE, NO WINDOWS LEFT }
        BEGIN
             Hidemouse;
             ClearDevice;
             ShowMouse;
             EXIT
        END ELSE
     ClipR := R;
     { GET CLIP RectANGLE }
     ViewPoint.X := ClipR.A.X;
     ViewPoint.Y := ClipR.A.Y;
     SetView(ClipR);
     HideMouse;
     ClearViewPort;
     { CLEAN VIEWPORT TO UPDATE }
     ShowMouse;

     { THIS IS THE HEART OF THE REDRAWING TECHNIQUE }
     For N:=1 to ObjCount-1 do
     { FOR ALL WINDOWS-1 DO }
         BEGIN
               HideMouse;
               ObjList[N]^.Clamp (ViewPoint);
               { GET AREA OF WINDOW TO PAINT }
               ObjList[N]^.Paint;
               ObjList[N]^.SetFocus(False);
               ObjList[N]^.UnClamp;
               SetView(ClipR);
               ShowMouse;
         END;
     SetView(TotalR);
     { RESTORE VIEWPORT TO WHOLE SCREEN }
     ObjList[ObjCount]^.Paint;
     { PAINT TOP MOST WINDOW WITH FOCUS ON }
END;

Procedure LApp.Switch;
BEGIN
     { CALL THE TASK SWITCHER WINDOW }
     Beep;
END;


Procedure LApp.Run;
VAR
   Event    : Boolean;
   E        : Eventype;
   isE      : Boolean;
   N        : Integer;
   P        : PLView;
   PaintR   : Rect;
   NR       : Integer;
BEGIN
     NR := ObjCount;
     REPEAT
     { REPEAT THE APPLICATION MAIN LOOP UNTIL A QUIT COMMAND ARRIVES }
           CMCommand := 0;
           { RESET THE COMMAND BUFFER }
           Event:= GetEvent (E);
           { GET EVENT METHOD, CHECK EMOUSE.PAS LIBRARY }
           If Event then
                        { APPLICATION HANDLE EVENTS METHOD }
                        BEGIN
                             { HANDLE SPECIAL EVENTS FIRST }
                             If E.Key.Extended AND (E.Key.ScanCode = CMSwitch) THEN Switch;
                             { IF USER ROTATES VIEWS WITH KEYBOARD THEN }
                             If E.Key.Extended AND (E.Key.ScanCode = CMRotate) AND (ObjCount > 1) AND CanRotate
                             THEN
                                BEGIN
                                      MouseCursor(Standard, 1,1);
                                      ObjList[ObjCount]^.SetFocus(False);
                                      Dec (NR,1);
                                      If NR < 1 then NR := ObjCount-1;
                                      ObjList[NR]^.Paint;
                                      RotateTop(NR);
                                END;
                             If E.Key.Extended AND (E.Key.ScanCode = CMQuit) then LApp.Done;
                             { IF ALT-X PRESSED THEN QUIT }
                             

                             { IF MOUSE EVENT GET VIEW WITH MOUSE CLICK}
                             If (E.Mouse.Event <> 0) OR (E.Key.ScanCode <> 0)
                                     then
                                          BEGIN
                                               If E.Mouse.Event = 1 then
                                               N := LApp.GetView(E.Mouse.P);
                                               P := LApp.GetDC;
                                               if P <> NIL then
                                               { SEND MESSAGE TO VIEW AND LET IT HANDLE IT }
                                               P^.HandleEvent (E);
                                          END;

                             If CMCommand <> 0 then
                                BEGIN
                                     Case CMCommand of
                                     { PROCESS MESSAGES FROM VIEWS }
                                        CMPaint     :
                                        { A VIEW SAYS PAINT AREA OF SCREEN }
                                                    BEGIN
                                                         P := LApp.GetDC;
                                                         if P <> NIL then
                                                         PaintR := P^.PaintR;
                                                         LApp.Paint (PaintR);
                                                    END;
                                        { SOMEBODY WANTS TO CLOSE VIEW WITH FOCUS }
                                        CMClose     :
                                        { CLOSE THIS VIEW }
                                                    BEGIN
                                                         P := LApp.GetDC;
                                                         if P <> NIL then
                                                         { IF WINDOW CAN BE CLOSED THEN }
                                                         If P^.IsCloseable then
                                                            BEGIN
                                                                 PaintR := P^.PaintR;
                                                                 LApp.Destroy(P);
                                                                 LApp.Paint(PaintR);
                                                                 CanRotate := True;
                                                            END;
                                                    END;
                                     END; { Cases }
                                END;

                        END;
           { PROCESS IDLE EVENTS AT THE END }
           LApp.Idle;
     UNTIL FALSE;
END;

Destructor LApp.Done;
BEGIN
     CloseGraph;
     { CLOSE GRAPHICS }
     Quit(' Thanks for using Views');
     { HALT WITH SOME MESSAGE }
END;

BEGIN

END.


