{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$M 16384,0,655360}

{
GLENZ3.PAS
Demonstrates 	- sprite color mapping
		- sprite transparency
		- background usage
		- higher level of sprite encapsulation
}

uses	crt,uve32;

const	maxspheres=200;

type	spheretype=record
		x,y,
		forcex,forcey:longint;
	end;

var	sphere:array[1..maxspheres] of spheretype;

procedure init;
var	pal:palette;
	i:integer;
begin
	ia_inituve;
	ia_loadspr('sphere.uvl',1);
	ia_chainsprite(1,spritesloaded,1);
	ia_loadfont(8);
	ia_setfontattr(8,plain,proportional,horizontal,255,true,0);
	pal:=blackpal;
	for i:=0 to 63 do with pal[i] do begin
		red:=i;
		green:=i;
		blue:=i;
	end;
	ia_makeglenzmap(pal,1,1,1,maparray[1]);
	ia_powerup;
	ia_setpalette(pal);
	ia_setcycletime(40);
	for i:=1 to maxspheres do with sphere[i] do begin
		x:=longint(160)*256;
		y:=longint(200)*256;
		forcex:=(longint(random(2560))-1280);
		forcey:=-(longint(random(2560)));
		spr[i].n:=1+random(30);
		spr[i].transparent:=true;
		spr[i].map:=1;
	end;
	ia_cls(hidden,0);
	usebackground:=false;
end;

procedure deinit;
begin
	ia_shutdown;
	halt;
end;


procedure movespheres;
var	i:integer;
begin
	for i:=1 to maxspheres do with sphere[i] do begin
		inc(x,forcex);
		inc(y,forcey);
		if (y>200*256) and (forcey>0) then
			forcey:=-forcey
			else inc(forcey,64);
		if (x<0) and (forcex<0) then forcex:=-forcex;
		if (x>320*256) and (forcex>0) then forcex:=-forcex;
		ia_center(i,x div 256,y div 256,2);
	end;
end;

var	ch:char;
begin
	init;
	repeat
		if keypressed then begin
			while keypressed do ch:=readkey;
			if ch=' ' then usebackground:=not usebackground;
		end;
		movespheres;
		ia_doframepart1;
		ia_doframepart2;
		ia_printstr(hidden,-32768,30,'Press SPACE to toggle background',63);
		ia_doframepart3;
	until ch=#27;
	deinit;
end.