(*
     Programmers: Help fighting viruses and patching.

Viruses and unauthorized patching are problems which should be
fought against by the PC community. This program demonstrates a
simple and a reasonably general, fast selftest to detect whether the
program has caught a virus, or if it has been amateurishly patched.
The code is easily incorporated in any Turbo Pascal source code. The
idea is to check whether the file date and size have been altered.
Most .exe viruses work by appending their code to the .exe file
altering the file size. Trivial patching changes the file date.
Either of these is detected by selftest.
....................................................................
Prof. Timo Salmi   Co-moderator of news:comp.archives.msdos.announce
Moderating at ftp:// & http://garbo.uwasa.fi archives  193.166.120.5
Department of Accounting and Business Finance  ; University of Vaasa
ts@uwasa.fi http://uwasa.fi/~ts BBS 961-3170972; FIN-65101,  Finland
*)

program SelftestDemo;

uses Dos
     {$IFDEF VER40}  (* To provide what TP 4.0 is missing *)
     ,TSUNT45        (* as compared to the later TP versions *)
     {$ENDIF}
     ;

(* Define a datatype for the required information *)
type SelftestRecordType = record
                             size  : longint;
                             year  : word;
                             month : word;
                             day   : word;
                             ok    : boolean;
                           end;

(* Define a selftest constant. Give initial values to match your
   own program *)
const SelftestRecord
        : selftestRecordType
        = (size  : 3648;
           year  : 1992;
           month : 11;
           day   : 8;
           ok    : true);

(* Tests whether file size and / or filedate have been changed.
   Writes a warning message *)
procedure SELFTEST (var selftestRecord : selftestRecordType);
var FileInfo : SearchRec;
    FileDate : DateTime;
    oksize   : boolean;
    okdate   : boolean;
    progname : string;
begin
  oksize := true;
  okdate := true;
  {$IFDEF VER40} progname := ParamStr0;
  {$ELSE}        progname := ParamStr(0);
  {$ENDIF}
  FindFirst (progname, AnyFile, FileInfo);
  if DosError <> 0 then selftestRecord.ok := false;
  if selftestRecord.ok then
    if (FileInfo.Attr and VolumeId = 0) and
       (FileInfo.Attr and Directory = 0) then
      begin
        if FileInfo.Size <> selftestRecord.size then
          oksize := false;
        UnpackTime (FileInfo.Time, FileDate);
        if FileDate.year  <> selftestRecord.year then
          okdate := false;
        if FileDate.month <> selftestRecord.month then
          okdate := false;
        if FileDate.day   <> selftestRecord.day then
          okdate := false;
        selftestRecord.ok := oksize and okdate;
      end;
  if not selftestRecord.ok then
    begin
      writeln (#7, 'Warning for a patched or detached program, or a potential virus');
      if not oksize then
        writeln (progname, ' filesize has been altered');
      if not okdate then
        writeln (progname, ' filedate has been altered');
    end;
end;  (* selftest *)

procedure LOGO;
begin
  writeln;
  writeln ('SELFTEST demo by Prof. Timo Salmi, 8-Nov-92');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
  writeln;
end;  (* logo *)

(* Main program *)
begin
  LOGO;
  SELFTEST (selftestRecord);
  if not selftestRecord.ok then halt;
  writeln ('Hello world and whatever');
end.  (* selftestDemo *)
