unit Misc;

{ unit Misc, Version 1.20, Copr. 1993,95 Matthias Kppe

  misc.txt misc.doc
}

{$A+,B-,F-,G+,O-,R-,S-,X+}

interface

uses Objects, Dos;

{ ReadValue liest den Wert des Bezeichners Id im Abschnitt Section einer
  geffneten INI-Datei F, die im Format von Microsoft Windows
  vorliegt.
}
function ReadValue(var F: TStream; Section, Id: string): string;

{ GetWinDir versucht, das Verzeichnis von Microsoft Windows zu
  finden.
}
function GetWinDir: DirStr;

{ GetBGIDir versucht, das BGI-Verzeichnis zu finden.
}
function GetBGIDir: DirStr;

{ FirstFile sucht im Verzeichnis Dir die erste Datei, die in der Dateiliste
  Files aufgefhrt ist.
}
function FirstFile(Files: string; Dir: DirStr): PathStr;

{ Undokumentierte Routinen.
}
function SeekForLine(var F: TStream; s, h: string): string;
function ReadLine(var F: TStream): string;
function Matches(shorter, longer:string):Boolean;

implementation

{ INI- Routinen
}
function SeekForLine;
var
  Line: string;
  halted: Boolean;
Begin
  Repeat
    Line := ReadLine(F);
    halted := (F.Status <> 0) or Matches(h, Line);
  Until halted or Matches(s, Line);
  If halted
    then Begin F.Reset; SeekForLine := '' End
    else SeekForLine := Line;
End;

function ReadLine;
var
  s: string;
  x: char;
Begin
  s[0] := #0;
  Repeat
    F.Read(x, 1);
    If x <> #13
    then Begin s[Length(s) + 1] := x; Inc(s[0]) End
  Until (F.Status <> 0) or (x = #13);
  F.Read(x, 1);
  ReadLine := s;
End;

function Matches; assembler;
Asm
	PUSH	DS
	LDS	SI, shorter
	LES	DI, longer
	MOV	CL, [SI]
	XOR	CH, CH
	MOV	AL, [ES:DI]
	CMP	CL, AL
	JA	@@3
	INC	SI
	INC	DI
@@2:	LODSB
	MOV	AH, [ES:DI]
	INC	DI
	CMP	AL, AH
	JZ	@@1
	CMP	AL, "A"
	JB	@@3
	CMP	AL, "z"
	JA	@@3
	AND	AX, 1F1FH
	CMP	AL, AH
	JNZ	@@3
@@1:	LOOP	@@2
	MOV	AX, 1
	JMP	@@4
@@3:	XOR	AX, AX
@@4:	POP	DS
End;

function ReadValue;
var
  s: string;
  P: Byte;
Begin
  ReadValue := '';
  If Section <> ''
    then Begin
      F.Seek(0);
      If Section[1] <> '['
	then Section := '['+Section;
      If SeekForLine(F, Section, ^Z) = '' then Exit
    End;
  s := SeekForLine(F, Id, '[');
  If s = '' then Exit;
  P := Pos('=', s);
  If P = 0 then Exit;
  ReadValue := Copy(s, P + 1, Length(s) - P)
End;

{ Weiteres
}
function GetWinDir;
var
  s: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
Begin
  s:=FSearch('WIN.COM', GetEnv('PATH') + ';C:\WINDOWS');
  FSplit(s, Dir, Name, Ext);
  GetWinDir := Dir;
End;

function GetBGIDir: DirStr;
var
  DirList: string;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
Begin
  DirList := GetEnv('PATH') + ';C:\TP\BGI;C:\TURBO\BGI;C:\BP\BGI;';
  DirList := FSearch('EGAVGA.BGI', DirList);
  FSplit(DirList, Dir, Name, Ext);
  GetBgiDir := Dir;
End;

function FirstFile;
var
  DirInfo: SearchRec;
  s: PathStr;
  i: Byte;
Begin
  Repeat
    i := Pos(';', Files);
    If i = 0
      then s := Files
      else Begin
	s := Copy(Files, 1, i-1);
	Delete(Files, 1, i)
      End;
    FindFirst(Dir + s, AnyFile, DirInfo);
  Until (i = 0) or (DosError = 0);
  If DosError <> 0
    then FirstFile := ''
    else FirstFile := Dir + DirInfo.Name
End;

End.
