program sertest;

{ trivial test of serio.pas include -- a tiny dumb terminal program }

uses dos,crt;

{$define debug}

var
  console: boolean;
  port: integer;
  shadow: integer;
  eightbitclean: boolean;
  highcolor: integer;
  lowcolor: integer;

  speed: longint;

{local sertest variables, not needed for serio}
  done: boolean;
  c: char;
  outmask: byte;
  echo: boolean;

{$i serio.pas}

procedure usage;

begin
  writeln('sertest [-p port] [-s speed] [-h] [-e]');
  writeln('  -p 0=COM1, 1=COM2');
  writeln('  -s 2400=2400, 9600=9600');
  writeln('  -h strip high bit');
  writeln('  -e echo (half duplex)');
  halt(1);
end;

procedure initparams;

var
  i: integer;
  code: word;

begin
  speed := 2400;
  outmask := 255;
  echo := false;

  port := 0;

{$ifdef com2}
  port := 1;
{$endif}

{$ifdef halfduplex}
  echo := true;
{$endif}

  i := 1;
  while i<=paramcount do
    begin
      if paramstr(i)='-p' then
        begin
          inc(i);
          if i<=paramcount then
            val(paramstr(i),port,code)
          else
            usage;
        end
      else if paramstr(i)='-s' then
        begin
          inc(i);
          if i<=paramcount then
            val(paramstr(i),speed,code)
          else
            usage;
        end
      else if paramstr(i)='-h' then
        begin
          outmask := 127;
        end
      else if paramstr(i)='-e' then
        begin
          echo := true;
        end
      else
        usage;
      inc(i);
    end;
end;

begin
  console := true;
  port := 0;
  shadow := 0;
  eightbitclean := true;
  highcolor := 0;
  lowcolor := 0;

  initparams;

  portengage;
  portspeed(speed);

  xwritelns('quit by holding Cntl or Ctrl or Control and hitting A');
  xwriteln;

  done := false;

  while not done do
    begin

      console := false;
      if xkeypressed then
        begin
          c := xreadkey;
          c := chr(ord(c) and outmask);
          console := true;

{ change CRLF or CR to CRLF -- ignore LF }
{ this will double-space modems that give two CRs for every AT command }

          if c<>chr(10) then
            if c=chr(13) then
              xwriteln
            else
              xwrites(c);

        end;

      console := true;
      if xkeypressed then
        begin
          c := xreadkey;
          if c=chr(1) then
            done := true
          else
            begin
              if echo then
                xwrites(c);
              console := false;
              xwrites(c);
            end;
        end;
    end;

  portdisengage;

  console := true;
  xwriteln;
  xwritelns('done');

end.
