{ PROCPARM.PAS }
Program ProcParameter;
{ Demonstrates using a procedure type as a procedure parameter }

type
  FormatProc = procedure ( X : Integer );


const
  MaxListSize = 15;
  Values: array[1..MaxListSize] of Integer =
     (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);



function Hexadecimal ( X: Word ) : String;
var
  HiByte, LoByte : Word;

  function HexConvert( B : Byte ) : String;
  const
    HexTable : Array[0..15] of Char =
      ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
       'A', 'B', 'C', 'D', 'E', 'F');
  begin
    HexConvert := HexTable[B div 16] + HexTable[B and 15];
  end;

begin
  HiByte := X Div 256;
  LoByte := X and 255;
  Hexadecimal := HexConvert( HiByte ) + HexConvert( LoByte );
end;



procedure PrintInteger( X : Integer ); far;
begin

  Writeln( X : 5 );

end;



procedure PrintHex( X : Integer ); far;
begin

  Writeln ( Hexadecimal ( X ) );


end;


procedure PrintPercent( X : Integer ); far;
begin

  Writeln( X, '%');

end;


procedure Traverse ( Proc : FormatProc );
var
  I : Integer;
begin
  for I := 1 to MaxListSize do
    Proc( Values[I] );
end;


begin
  Traverse ( PrintInteger );
  Traverse ( PrintHex );
  Traverse ( PrintPercent );

  readln;

end.
