unit Math;

interface

(* ---------------------- *)       (* --------------------------- *)
(* MATH FUNCTIONS TP-UNIT *)       (* LOGARITHM, POWERS AND ROOTS *)
(* ---------------------- *)       (* --------------------------- *)
function Power (x,y:real):real;    (* x to the power of y         *)
function Root (x,y:real):real;     (* the y'th root of x          *)
function Log (x:real):real;        (* Logarithm of x with base 10 *)
function Antilog (x:real):real;    (* 10^x                        *)
function LogBase (x,y:real):real;  (* Logarithm of x with base y  *)
                                   (* --------------------------- *)
                                   (* TRIGONOMETRIC FUNCTIONS     *)
                                   (* --------------------------- *)
function D2R (x:real):real;        (* Degrees to radians          *)
function R2D (x:real):real;        (* Radians to degrees          *)
function Tan (x:real):real;        (* Tangent of x                *)
function ArcSin (x:real):real;     (* Arc sine of x               *)
function ArcCos (x:real):real;     (* Arc cosine of x             *)
                                   (* --------------------------- *)
                                   (* HYPERBOLIC FUNCTIONS        *)
                                   (* --------------------------- *)
function Sinh (x:real):real;       (* Sine hyperbolic of x        *)
function Cosh (x:real):real;       (* Cosine hyperbolic of x      *)
function Tanh (x:real):real;       (* Tangent hyperbolic of x     *)
function ArSinh (x:real):real;     (* Ar sine hyperbolic of x     *)
function ArCosh (x:real):real;     (* Ar cosine hyperbolic of x   *)
function ArTanh (x:real):real;     (* Ar tangent hyperbolic of x  *)
                                   (* --------------------------- *)
                                   (* OTHER FUNCTIONS             *)
                                   (* --------------------------- *)
function Fac (n:integer):real;     (* Factorial of n  (n!)        *)
function Frac (x:real):real;       (* Fraction of x               *)
function Sgn (x:real):integer;     (* Sign of x  <0=-1  0=0  >0=1 *)

implementation

function Power;
begin
  if x=0.0 then
    Power:=1.0
  else
    Power:=exp(y*ln(abs(x)));
  if (x<0.0) and (frac(abs(y))=0.0) and (odd(round(y))) then Power:=-exp(y*ln(-x));
end;

function Root;
begin
  Root:=exp(1.0/y*ln(abs(x)));
end;

function Log;
begin
  Log:=ln(x)/ln(10.0);
end;

function Antilog;
begin
  if x=0.0 then
    Antilog:=1.0
  else
    Antilog:=exp(x*ln(10.0));
end;

function LogBase;
begin
  LogBase:=ln(x)/ln(y);
end;

function D2R;
begin
  D2R:=x*pi/180.0;
end;

function R2D;
begin
  R2D:=x*180.0/pi;
end;

function Tan;
begin
  tan:=sin(x)/cos(x);
end;

function ArcSin;
begin
  if abs(x)=1.0 then
    ArcSin:=pi/2.0
  else
    ArcSin:=arctan(x/sqrt(1.0-x*x));
end;

function ArcCos;
begin
  if x=0.0 then ArcCos:=pi/2.0;
  if x>0.0 then ArcCos:=arctan(sqrt(1.0-x*x)/x);
  if x<0.0 then ArcCos:=arctan(sqrt(1.0-x*x)/x)+pi;
end;

function Sinh;
begin
  Sinh:=(exp(x)-exp(-x))/2.0;
end;

function Cosh;
begin
  Cosh:=(exp(x)+exp(-x))/2.0;
end;

function Tanh;
begin
  Tanh:=(exp(x)-exp(-x))/(exp(x)+exp(-x));
end;

function ArSinh;
begin
  ArSinh:=ln(x+sqrt(x*x+1.0));
end;

function ArCosh;
begin
  ArCosh:=ln(x+sqrt(x*x-1.0));
end;

function ArTanh;
begin
  ArTanh:=ln((x+1.0)/(1.0-x))/2.0;
end;

function Fac;
var
 hlpvar  : integer;
 hlpvarr : real;
begin
  hlpvarr:=1.0;
  for hlpvar:=2 to n do
    hlpvarr:=hlpvarr*hlpvar;
  fac:=hlpvarr;
end;

function Frac;
begin
  Frac:=x-int(x);
end;

function Sgn;
begin
  Sgn:=0;
  if x>0.0 then Sgn:=1;
  if x<0.0 then Sgn:=-1;
end;

end.
