{$ifdef WINDOWS}

{$M 2048,30000}

{$ELSE}

	{$ifdef DPMI}

		{$M 2048}

	{$else}

		{$M 2048,60000,60000}

	{$endif}
{$endif}


program LZOTest;

uses
{$ifdef WINDOWS}

	wincrt,windos,
{$ENDIF}


  LZO;

type TFileHuff = Object (THuff)
       infile, outfile: file;
       counter: longint;
       constructor Init (infname, outfname: String);
       destructor  Done; virtual;
       function    ReadBuf (var data; size: word): longint; virtual;
       function    WriteBuf (var data; size: word): longint; virtual;
     END;


constructor TFileHuff.Init (infname, outfname: String);
begin
	THuff.Init;
	Assign (infile, infname);
	Reset (infile, 1);
	if IoResult > 0 then begin
		Writeln ('! Can''t open input file');
		{$ifdef WINDOWS}
		donewincrt;
		{$endif}
		Halt (1);
		end;
	Assign (outfile, outfname);
	Rewrite (outfile, 1);
	if IoResult > 0 then begin
		Writeln ('! Can''t open input file');
		{$ifdef WINDOWS}
		donewincrt;
		{$endif}
		Halt (1);
		end;
  counter := 0
end;

destructor TFileHuff.Done;
begin
	Close (infile);
	if IoResult>0 then begin
		Writeln ('! Error closing input file');
		{$ifdef WINDOWS}
		readkey;
		donewincrt;
		{$endif}
		Halt (1);
		end;
	Close (outfile);
	if IoResult>0 then begin
		Writeln ('! Error closing output file');
		{$ifdef WINDOWS}
		readkey;
		donewincrt;
		{$endif}
		Halt (1);

		end;
end;

function TFileHuff.ReadBuf (var data; size: word): longint;
var rd: word;
begin
  BlockRead (infile, data, size, rd);
  if IOResult > 0 then
	ReadBuf := -1
  else
	ReadBuf := rd;
  if Compressing then begin
	inc (counter, rd);
	Write (counter, #13)
  end;
end;

function TFileHuff.WriteBuf (var data; size: word): longint;
var wr: word;
begin
  BlockWrite (outfile, data, size, wr);
  if IOResult > 0 then
    WriteBuf := -1
  else
    WriteBuf := wr;
  if not Compressing then begin
    inc (counter, wr);
    Write (counter, #13)
  end;
end;

var
  s: String;
  test: Word;
  RData: Byte;
  FileHuff: TFileHuff;
  fsize,
  compr: longint;

begin
  {$ifdef WINDOWS}
	Initwincrt;
  {$endif}
  Writeln ('Huffman Compression Engine v', EngineVer);
  if ParamCount <> 3 then begin
	Writeln ('Usage: testlzo e(ncode)|d(ecode) infile outfile');
	Halt (1);
  end;

  FileHuff.Init (ParamStr (2), ParamStr (3));

  s := ParamStr(1);
  case s[1] of
   'e','E': Begin
			  fsize := FileSize (FileHuff.infile);
			  Writeln (fsize);
			  compr := FileHuff.Compress (fsize);

			  Writeln ('input:  ', fsize, ' bytes');
			  Writeln ('output: ', compr, ' bytes');
			  Writeln ('relative output: ', compr*100 div fsize, '%');
			End;
   'd','D': FileHuff.Expand
   else begin
		  Writeln ('! Use [D] for Decompression or [E] for Compression');
		  Halt (1)
		end;
  end;
  FileHuff.Done;

  {$ifdef WINDOWS}
	donewincrt;
  {$endif}

end.