
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Longint Shift Right                             *
; *                                                     *
; *     Copyright (C) 1992,1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   LONGSHR


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  LongShr

;-------------------------------------------------------------------------------
; LongShr performs a logical right shift on its LONGINT argument, that is, the
; sign for negative numbers is not preserved. It allows a variable shift count
; to be used, but masks this off so that the count is in the range 0...31.
; Counts > 31 would not be sensible, since the result would be already zero by
; the 31st shift.
;
; INPUT:     DX:AX     argument
;            CX        count
;
; OUTPUT:    DX:AX     argument SHR count
;
; DESTROYS:  AX,BX,CX,DX,Flags
;-------------------------------------------------------------------------------

LongShr      PROC    FAR
             AND     CX, 1FH           ; mask off shift count to 0..31
             CMP     CL, 16            ; 16 shifts or more ?
             JAE     $more_16          ; yes
             MOV     BX, DX            ; duplicate hi-word of number
             SHR     DX, CL            ; shift hi-word of number
             SHR     AX, CL            ; shift lo-word of number
             NEG     CL                ; compute new shift count as
             ADD     CL, 16            ;  16 - old shift count
             SHL     BX, CL            ; get bits shifted out of hi-word
             OR      AX, BX            ; move them into lo-word
$zero_shr:   RET                       ; done
$more_16:    XCHG    AX, DX            ; shift number
             XOR     DX, DX            ;  by 16 bits
             SUB     CL, 16            ; 16 shifts done
             SHR     AX, CL            ; perform remaining shifts
             RET                       ; done
LongShr      ENDP

             ALIGN   4

CODE         ENDS

             END
