
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Longint Shift Left                              *
; *                                                     *
; *     Copyright (C) 1992,1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   LONGSHL


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  LongShl

;-------------------------------------------------------------------------------
; LongShl performs a logical left shift on its LONGINT argument, that is, the
; sign is not preserved and there is no check if the results overflows the
; LONGINT format. It allows a variable shift count to be used, but masks this
; off so that the count is in the range 0...31. Counts > 31 are not sensible,
; since the result would be already zero after the 31st shift.
;
; INPUT:     DX:AX     argument
;            CX        count
;
; OUTPUT:    DX:AX     argument SHL count
;
; DESTROYS:  AX,CX,DX,Flags
;-------------------------------------------------------------------------------

LongShl      PROC    FAR
             AND     CX, 1FH           ; mask off shift count to 0..31
             CMP     CL, 16            ; 16 shifts or more ?
             JAE     $more_16          ; yes
             MOV     BX, AX            ; duplicate lo-word of number
             SHL     DX, CL            ; shift hi-word of number
             SHL     AX, CL            ; shift lo-word of number
             NEG     CL                ; compute new shift count as
             ADD     CL, 16            ; 16 - old shift count
             SHR     BX, CL            ; get bits shifted out of lo-word
             OR      DX, BX            ; insert them into hi-word
$zero_shr:   RET                       ; done
$more_16:    XCHG    AX, DX            ; shift number
             XOR     AX, AX            ;  by 16 bits
             SUB     CL, 16            ; 16 shifts done
             SHL     DX, CL            ; perform remaining shifts
             RET                       ; done
LongShl      ENDP

             ALIGN   4

CODE         ENDS

             END
