
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Longint Absolute Value                          *
; *                                                     *
; *     Copyright (C) 1991-1993 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   LONGABS


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  LongAbs

;-------------------------------------------------------------------------------
; LONG_ABS computes the absolute value of a four byte signed integer.
;
; INPUT:     DX:AX      longint number
;
; OUTPUT:    DX:AX      absolute value of longint number
;
; DESTROYS:  AX,DX,Flags
;-------------------------------------------------------------------------------

LongAbs      PROC    FAR
             OR      DX, DX            ; number positive ?
             JNS     $positive         ; yes, all done
             NOT     DX                ; negate
             NEG     AX                ;  number
             SBB     DX, -1            ;   in DX:AX
$positive:   RET                       ; done
LongAbs      ENDP

             ALIGN   4

CODE         ENDS

             END
