
; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0        *
; *     Real Longint -> Real Conversion                 *
; *                                                     *
; *     Copyright (C) 1989-1992 Norbert Juffa           *
; *                                                     *
; *******************************************************

             TITLE   FP48FLT

             INCLUDE SE.ASM


CODE         SEGMENT BYTE PUBLIC

             ASSUME  CS:CODE

; Publics

             PUBLIC  RealFloat,RFloat

;-------------------------------------------------------------------------------
; RealFloat converts a four byte signed long integer number to the six byte
; TURBO-Pascal floating point format.
;
; INPUT:     DX:AX      longint number
;
; OUTPUT:    DX:BX:AX   real number
;
; DESTROYS:  AX,BX,CH,DX,Flags
;-------------------------------------------------------------------------------

RealFloat    PROC    NEAR
             MOV     BX, AX            ; save low word of longint
             OR      AX, DX            ; is longint = 0 ?
             JZ      $real_zero        ; yes, result is real zero
             MOV     CH, 7Fh           ; load mask for sign bit
             OR      CH, DH            ; extract sign bit (clear carry flag)
             JNS     $long_pos         ; no sign bit, number is positive
             NEG     DX                ; negate
             NEG     BX                ;  long integer
$long_pos:   SBB     DX, 0             ;   in DX:BX
             MOV     AX, 0A0h          ; set exponent (assume all bits set)
             JNZ     $hiword_set       ; high word of longint not zero
             XCHG    DX, BX            ; do a 16-bit left shift on DX:BX
             MOV     AL, 90h           ; assume last 24 bits in longint set
$hiword_set: OR      DH, DH            ; test, wether more than 16 bits set
             JNZ     $hibyte_set       ; yes, exponent correct
             SUB     AL, 8             ; adjust exponent
             OR      DH, DL            ; do an
             MOV     DL, BH            ;  eight bit
             MOV     BH, BL            ;   left shift
             MOV     BL, AH            ;    on DX:BX
$hibyte_set: JS      $normalized       ; yes, mantissa ready

             ALIGN   4

$shift_bit:  DEC     AX                ; adjust exp. for left shift of mantissa
             ADD     BX, BX            ; shift mantissa one
             ADC     DX, DX            ;  bit to the left
             JNS     $shift_bit        ; until msb of mantissa set
$normalized: AND     DH, CH            ; mask out sign bit if necessary
$real_zero:  RET                       ; done
RealFloat    ENDP

             ALIGN   4

RFloat       PROC    FAR
             CALL    RealFloat         ; perform conversion longint to real
             RET                       ; done
RFloat       ENDP

             ALIGN   4

CODE         ENDS

             END
