{

	pickf.pas
	4-25-90

    Copyright 1990
    John W. Small
    All rights reserved

    PSW / Power SoftWare
    P.O. Box 10072
	McLean, Virginia 22102 8072
	(703) 759-3838

}

unit pickf;

interface

	uses dos, pick;

	type

		PickFile = object(PickList)
			dir : DirStr;
			name : NameStr;
			ext : ExtStr;
			constructor init(path : string);
			procedure   showItem; virtual;
			function    doItem : boolean; virtual;
			destructor  done; virtual;
			end;
{
		PickList = object(FlexList)
			color, mono, attrs : PAptr;
			x, y, rows, cols, clen, startRow,
            crow, ccol : integer;
			update, finished : boolean;
			title : string;
			w : FramedTextWindow;
			constructor init(pdlen,px,py,
				prows,pcols,pclen : integer;
				ptitle : string);
			procedure   showItem; virtual;
			function    doItem : boolean; virtual;
			procedure   query;
			destructor  done; virtual;
			end;
}

implementation


	function strcmp(str1, str2 : string) : integer;
		var i  : byte;
		begin
			i := 1;
			while (i <= byte(str1[0])) and
				(i <= byte(str2[0])) and
				(str1[i] = str2[i]) do
				inc(i);
			if i <= length(str1) then
				if i <= length(str2) then
					if byte(str1[i]) > byte(str2[i]) then
						strcmp := 1
					else
						strcmp := -1
				else
					strcmp := -1
			else if i <= length(str2) then
				strcmp := 1
			else
				strcmp := 0
		end;

	{$F+}
	function DirEntryCompare(var buf1, buf2) : integer; {$F-}
		var de1 : SearchRec absolute buf1;
			de2 : SearchRec absolute buf2;
		begin
			{$V-}
			DirEntryCompare := strcmp(de1.Name,de2.Name)
			{$V+}
		end;

	constructor PickFile.init(path : string);
		var DirEntry : SearchRec;
		begin
			PickList.init(sizeof(SearchRec),10,10,9,4,12,path);
			title := FExpand(title);
			FindFirst(title,Directory,DirEntry);
			while DosError = 0 do begin
				insSort(DirEntry,DirEntryCompare);
				FindNext(DirEntry)
				end
		end;

	procedure PickFile.showItem;
		var DirEntryPtr : ^SearchRec;
		begin
			DirEntryPtr := currentD;
			if ok then begin
				if DirEntryPtr^.Attr = Directory then
					crt.TextAttr := attrs^[PICK_HILITE_ATTR]
				else
					crt.TextAttr := attrs^[PICK_NORMAL_ATTR];
				write(DirEntryPtr^.Name)
				end
		end;

	function  PickFile.doItem : boolean;
		var DirEntry : SearchRec;
		begin
			get(DirEntry);
			if ok then
				if DirEntry.Attr = Directory then begin
					{$V-}
					if strcmp(DirEntry.name,'.') <> 0 then begin
						FSplit(title,dir,name,ext);
						if strcmp(DirEntry.name,'..')  = 0 then begin
							if length(dir) > 3 then
								dir[0] := char(length(dir)-1);
							FSplit(dir,dir,name,ext);
							title := concat(dir,'*.*')
							end
						else
							title := concat(dir,DirEntry.name,'\*.*');
						clear;
						init(title)
						end;
					doItem := false
					{$V+}
					end
				else
					doItem := true
            else
                doItem := false
		end;

	destructor PickFile.done;
		begin
			PickList.done
		end;

	begin
	end.
