;   _______________________________________________________________
;  |                                                               |
;  |            Copyright (C) 1989,1990  Steven Lutrov             |
;  |_______________________________________________________________|____
;  |                                                               |    |
;  |  Program Title : FastKbd.Asm                                  |    | ___
;  |  Author        : Steven Lutrov                                |    |    |
;  |  Revision      : 2.01                                         |    |    |
;  |  Date          : 1990-03-16                                   |    |    |
;  |  Language      : Turbo Assembler                              |    |    |
;  |                                                               |    |    |
;  |                                                               |    |    |
;  |  Description   : Assembly functions  For Keyboard Operations. |    |    |
;  |                : Using Int 16H or Dos 21H.                    |    |    |
;  |                : Tested on Turbo Pascal 5.0 & 5.5             |    |    |
;  |_______________________________________________________________|    |    |
;      |                                                                |    |
;      |________________________________________________________________|    |
;          |                                                                 |
;          |_________________________________________________________________|
;


Code Segment Word Public

Assume Cs:Code, Ds:Data

Public  Altkeydown,Capslockdown,Capslockon,Freshchar,Clearbuffer
Public  Clearcapslock,Clearins,Clearnumlock,Clearscrolllock,Ctrlkeydown
Public  Getscan,Inskeydown,Inskeyon,Keypause
Public  Leftshiftdown,Nextkey,Lastkey,Numlockdown,Numlockon,Readchar
Public  Readchar,Rightshiftdown,Scrolllockdown,Scrolllockon,Setcapslock
Public  Setins,Setnumlock,Setscrolllock

Data    Segment
        Extrn  Errreturn : Byte
Data    Ends


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Altkeydown: Boolean;
;
;
Altkeydown Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,8                       ;Test Bit 3
                Jnz  Altkeydownl1               ;Jump If True
                Mov  Bl,0                       ;False Value
Altkeydownl1:   Mov  Al,Bl                      ;Place Value For Return
                Ret
Altkeydown Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Capslockdown: Boolean;
;
;
Capslockdown Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Point Es To 0000:0000
                Mov  Si,418H                    ;Offset Of Status Byte
                Mov  Bl,64                      ;Test Bit 6
                Mov  Al,1                       ;True Value
                Test Es:[Si],Bl                 ;Test The Bit
                Jnz  Capslockdownl1             ;Jump If True
                Mov  Al,0                       ;False Value
Capslockdownl1: Ret
Capslockdown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Capslockon: Boolean;
;
;
Capslockon Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,64                      ;Test Bit 6
                Jnz  Capslockonl1               ;Jump If True
                Mov  Bl,0                       ;False Value
Capslockonl1:   Mov  Al,Bl                      ;Place Value For Return
                Ret
Capslockon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Freshchar: Char;
;
;
Freshchar Proc Far
                Mov  Ah,0Ch                     ;Dos Function Number
                Mov  Al,7                       ;Keyboard Read Function
                Int  21H                        ;Wait For A Keystroke
                Ret
Freshchar Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearbuffer;
;
;
Clearbuffer Proc Far
Clrbufferl1:    Mov  Ah,6                       ;Function Number
                Mov  Dl,0Ffh                    ;Subfunction Number
                Int  21H                        ;Seek Keystroke
                Jnz  Clrbufferl1                ;Repeat If One Found
                Ret
Clearbuffer Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearcapslock;
;
;
Clearcapslock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,10111111B               ;Bit 6
                And  Es:[417H],Al               ;Clear The Bit
                Ret
Clearcapslock Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearins;
;
;
Clearins  Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,01111111B               ;Bit 7
                And  Es:[417H],Al               ;Clear The Bit
                Ret
Clearins  Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearnumlock;
;
;
Clearnumlock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,11011111B               ;Bit 5
                And  Es:[417H],Al               ;Clear The Bit
                Ret
Clearnumlock Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Clearscrolllock;
;
;
Clearscrolllock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,11101111B               ;Bit 4
                And  Es:[417H],Al               ;Clear The Bit
                Ret
Clearscrolllock Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Ctrlkeydown: Boolean;
;
;
Ctrlkeydown Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,4                       ;Test Bit 2
                Jnz  Ctrlkeydownl1              ;Jump If True
                Mov  Bl,0                       ;False Value
Ctrlkeydownl1:  Mov  Al,Bl                      ;Place Value For Return
                Ret
Ctrlkeydown Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Getscan: Byte;
;
;
Getscan Proc Far
                Mov  Dx,0Ffh                    ;Assume No Keystroke
                Mov  Ah,1                       ;Bios Func To Chk Buffer
                Int  16H                        ;Chk For Keystroke
                Jz   Getscanl4                  ;Jump If Buffer Empty
                Mov  Dl,Ah                      ;Assume Ascii Code
                Or   Al,Al                      ;Test For Extended Code
                Jnz  Getscanl4                  ;Jump If Ascii Code
                Cmp  Ah,84                      ;Test For Func+Shift Keys
                Jb   Getscanl3                  ;Jump Ahead If Below
                Cmp  Ah,94                      ;Test If Func + Shift
                Jnb  Getscanl1                  ;Jump Ahead If Not
                Sub  Ah,25                      ;Figure The Scan Code
                Jmp  Short Getscanl3            ;Jump Ahead And Adjust
Getscanl1:      Cmp  Ah,104                     ;Test If Func + Ctrl
                Jnb  Getscanl2                  ;Jump Ahead If Not
                Sub  Ah,35                      ;Figure The Scan Code
                Jmp  Short Getscanl3            ;Jump Ahead And Adjust
Getscanl2:      Cmp  Ah,114                     ;Test If Func + Alt
                Jnb  Getscanl3                  ;Jump Ahead If Not
                Sub  Ah,45                      ;Figure The Scan Code
Getscanl3:      Add  Ah,128                     ;Add 128 To Extended Code
                Mov  Dl,Ah                      ;Move Value To Dl
Getscanl4:      Mov  Al,Dl                      ;Set For Return
                Ret
Getscan Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Inskeydown: Boolean;
;
;
Inskeydown Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Point Es To 0000:0000
                Mov  Si,418H                    ;Offset Of Status Byte
                Mov  Bl,128                     ;Test Bit 7
                Mov  Al,1                       ;True Value
                Test Es:[Si],Bl                 ;Test The Bit
                Jnz  Inskeydownl1               ;Jump If True
                Mov  Al,0                       ;False Value
Inskeydownl1:   Ret
Inskeydown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Inskeyon: Boolean;
;
;
Inskeyon Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,128                     ;Test Bit 7
                Jnz  Inskeyonl1                 ;Jump If True
                Mov  Bl,0                       ;False Value
Inskeyonl1:     Mov  Al,Bl                      ;Place Value For Return
                Ret
Inskeyon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Keypause(Code: Char; Ascii: Boolean; Wait_A,Wait_B: Byte);
;
;
Keypause Proc Far
                Sti                             ;Enable Interrupts
                Push Bp                         ;Save Bp
                Mov  Bp,Sp                      ;Set Up Stack Frame
                Mov  Bh,[Bp+12]                 ;Code To Bh
                Mov  Bl,[Bp+10]                 ;Extended Code Flag To Bl
                Sub  Ax,Ax                      ;Get Wait_A
                Mov  Al,[Bp+8]                  ;
                Mov  Si,Ax                      ;First Char Delay
Keypausel1:     Mov  Ah,0                       ;Function To Read Timer
                Int  1Ah                        ;Time To Cx:Dx
                Add  Dx,Si                      ;Add Delay To Low Word
                Mov  Di,Dx                      ;Copy To Di
Keypausel2:     Int  1Ah                        ;Keep Reading Time...
                Cmp  Dx,Di                      ;Delay Complete?
                Jne  Keypausel2                 ;Jump If Not
                Mov  Ah,1                       ;Bios Func To Chk Buffer
                Int  16H                        ;Check For Character
                Jz   Keypausel5                 ;Quit If Buffer Empty
                Cmp  Al,Bl                      ;See If Extended Code
                Jne  Keypausel3                 ;Jump If Not Extended
                Mov  Al,Ah                      ;Else Shift Code To Al
Keypausel3:     Cmp  Al,Bh                      ;Is It The Right Code?
                Jne  Keypausel5                 ;Quit Routine If Not
Keypausel4:     Mov  Ah,6                       ;Now Clear Buffer
                Mov  Dl,0Ffh                    ;Dos Func To Read Char
                Int  21H                        ;Read Char W.O. Waiting
                Jnz  Keypausel4                 ;Read Again If Char Found
                Sub  Ax,Ax                      ;Fetch Wait_B
                Mov  Al,[Bp+6]                  ;
                Mov  Si,Ax                      ;Typematic Delay
                Jmp  Short Keypausel1           ;Go Check Buffer Again
Keypausel5:     Pop  Bp                         ;Restore Bp And Quit
                Ret  4
Keypause Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Leftshiftdown: Boolean;
;
;
Leftshiftdown Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,2                       ;Test Bit 1
                Jnz  Leftshiftdownl1            ;Jump If True
                Mov  Bl,0                       ;False Value
Leftshiftdownl1:        Mov  Al,Bl              ;Place Value For Return                 
                Ret
Leftshiftdown Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Nextkey: Char;
;
;
;
;
Nextkey Proc Far
                Mov  Errreturn,2                ;2 = No Keystroke In Buffer
                Mov  Al,0Ffh                    ;Assume No Keystroke
                Mov  Ah,1                       ;Bios Func To Chk Buffer
                Int  16H                        ;Chk For Keystroke
                Jz   Nextkeyl1                  ;Jump If Buffer Empty
                Mov  Errreturn,0                ;0 = Not Extended Code
                Or   Al,Al                      ;Test For Extended Code
                Jne  Nextkeyl1                  ;Quit If Ascii Code
                Inc  Errreturn                  ;1 = Extended Code
                Mov  Al,Ah                      ;Move Extended Code To Al
Nextkeyl1:      Ret     
Nextkey Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Lastkey: Char;
;
;
Lastkey Proc Far
                Mov  Ah,6                       ;Dos Func To Chk For Key
                Mov  Dl,0Ffh                    ;Subfunction Number
                Int  21H                        ;Seek A Keystroke
                Jnz  Lastkey1                   ;Jump If Keystroke Found
                Mov  Al,0Ffh                    ;Else Flag  That No Char
Lastkey1:       Ret
Lastkey Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Numlockdown: Boolean;
;
;
Numlockdown Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Point Es To 0000:0000
                Mov  Si,418H                    ;Offset Of Status Byte
                Mov  Bl,32                      ;Test Bit 5
                Mov  Al,1                       ;True Value
                Test Es:[Si],Bl                 ;Test The Bit
                Jnz  Numlockdown                ;Jump If True
                Mov  Al,0                       ;False Value
Numlockdownl1:  Ret
Numlockdown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Numlockon: Boolean;
;
;
Numlockon Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,32                      ;Test Bit 5
                Jnz  Numlockonl1                ;Jump If True
                Mov  Bl,0                       ;False Value
Numlockonl1:    Mov  Al,Bl                      ;Place Value For Return
                Ret
Numlockon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Readchar: Char;
;
;
Readchar Proc Far
Readcharl1:     Mov  Ah,1                       ;Func To Check For Char
                Int  16H                        ;Find Out Next Char
                Jz   Readcharl1                 ;Loop If No Char
                Or   Al,Al                      ;Is It Extended?
                Jz   Readcharl6                 ;Read By Dos Func If So
                Sub  Ah,Ah                      ;Bios Func To Read Key
                Int  16H                        ;Get The Ascii Code
                Cmp  Al,8                       ;Is It Backspace?
                Jne  Readcharl2                 ;Jump Ahead If Not
                Cmp  Ah,14                      ;Is It From Backspc Key?
                Je   Readcharl7                 ;Jump Ahead If So
                Jmp  Short Readcharl5           ;Else Make It 208
Readcharl2:     Cmp  Al,9                       ;Is It Tab?
                Jne  Readcharl3                 ;Jump Ahead If Not
                Cmp  Ah,15                      ;Is It From Tab Key?
                Je   Readcharl7                 ;Jump Ahead If So
                Jmp  Short Readcharl5           ;Else Make It 209
Readcharl3:     Cmp  Al,13                      ;Is It Carriage Return?
                Jne  Readcharl4                 ;Jump Ahead If Not
                Cmp  Ah,28                      ;Is It From Cr Key?
                Je   Readcharl7                 ;Jump Ahead If So
                Jmp  Short Readcharl5           ;Else Make It 213
Readcharl4:     Cmp  Al,27                      ;Is It Escape?
                Jne  Readcharl7                 ;Jump Ahead If Not
                Cmp  Ah,1                       ;Is It From Escape Key?
                Je   Readcharl7                 ;Jump Ahead If So
Readcharl5:     Add  Al,200                     ;Inc Key Code By 200
                Jmp  Short Readcharl7           ;Go Set Char For Return
Readcharl6:     Mov  Ah,7                       ;Dos Keyboard Read Func
                Int  21H                        ;Get The Initial 0
Readcharl7:     Ret
Readchar Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Rightshiftdown: Boolean;
;
;
Rightshiftdown Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,1                       ;True Value
                Test Al,1                       ;Test Bit 0
                Jnz  Rightshiftdownl1           ;Jump If True
                Mov  Bl,0                       ;False Value
Rightshiftdownl1:       Mov  Al,Bl              ;Place Value For Return
                Ret
Rightshiftdown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Scrolllockdown: Boolean;
;
;
Scrolllockdown Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Point Es To 0000:0000
                Mov  Si,418H                    ;Offset Of Status Byte
                Mov  Bl,16                      ;Test Bit 4
                Mov  Al,1                       ;True Value
                Test Es:[Si],Bl                 ;Test The Bit
                Jnz  Scrollldownl1              ;Jump If True
                Mov  Al,0                       ;False Value
Scrollldownl1:  Ret
Scrolllockdown Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Function Scrolllockon: Boolean;
;
;
Scrolllockon Proc Far
                Mov  Ah,2                       ;Bios Kybd Status Func
                Int  16H                        ;Call The Interrupt
                Mov  Bl,-1                      ;True Value
                Test Al,16                      ;Test Bit 4
                Jnz  Scrolllockonl1             ;Jump If True
                Mov  Bl,0                       ;False Value
Scrolllockonl1: Mov  Al,Bl                      ;Place Value For Return
                Ret
Scrolllockon Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setcapslock;
;
;
Setcapslock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,64                      ;Bit 6
                Or   Es:[417H],Al               ;Set The Bit
                Ret
Setcapslock Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setins;
;
;
Setins  Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,128                     ;Bit 7
                Or   Es:[417H],Al               ;Set The Bit
                Ret
Setins  Endp



;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setnumlock;
;
;
Setnumlock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,32                      ;Bit 5
                Or   Es:[417H],Al               ;Set The Bit
                Ret
Setnumlock Endp


;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
;Procedure Setscrolllock;
;
;
Setscrolllock Proc Far
                Sub  Ax,Ax                      ;Clear Ax
                Mov  Es,Ax                      ;Es Pts To 0000:0000
                Mov  Al,16                      ;Bit 4
                Or   Es:[417H],Al               ;Set The Bit
                Ret
Setscrolllock Endp



Code    Ends

        End


