Unit sObjects;

Interface

Uses Graph,sObj2,sTypes,Mouse,Crt;

Const
  ws_Border=1;
  ws_Title=2;
  ws_Maximize=4;
  ws_System=8;
  ws_Display=16;

Type

  PsWindow=^TsWindow;
  TsWindow=object(TsObject)
    Attr:TsAttr;
    Parent,Current:PsWindow;
    Title:PChar;
    Repaint,Maximize,Close:Boolean;
    Constructor Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);
    Destructor Done; virtual;
    Procedure SetUpWindow; virtual;
    Procedure Paint; virtual;
    Procedure DeleteChildren; virtual;
    Procedure Clear; virtual;
    Procedure Event(evX,evY:Word;var Msg:Byte); virtual;
    Procedure HandleEvent(evX,evY:Word;var Msg:Byte); virtual;
    Procedure PaintUp; virtual;
  End;

  PsApplication=^TsApplication;
  TsApplication=object(TsObject)
    MainWindow:PsWindow;
    Constructor Init;
    Destructor Done; virtual;
    Procedure InitMainWindow; virtual;
    Procedure Run; virtual;
  End;

  PsView=^TsView;
  TsView=object(TsObject)
    Attr:TsAttr;
    Constructor Init(sX,sY,sW,sH:Word;sFT,sColor:Byte);
  End;

  PsFrame=^TsFrame;
  TsFrame=object(TsView)
    Procedure SetUpWindow; virtual;
  End;

  PsDisplay=^TsDisplay;
  TsDisplay=object(TsView)
    Procedure SetUpWindow; virtual;
  End;

  PsTitle=^TsTitle;
  TsTitle=object(TsView)
    Title:PChar;
    Procedure SetTitle(T:PChar); virtual;
    Procedure SetUpWindow; virtual;
  End;

  PsMaximize=^TsMaximize;
  TsMaximize=object(TsView)
    Procedure SetUpWindow; virtual;
  End;

  PsSystem=^TsSystem;
  TsSystem=object(TsView)
    Procedure SetUpWindow; virtual;
  End;


Implementation

  Procedure TsTitle.SetTitle(T:PChar);

       Sets the title for the title bar.

  Constructor TsApplication.Init;

       Goes into graphics mode.  Looks for driver path from env. var. BGI.
       Initializes the mouse and called InitMainWindow

  Destructor TsApplication.Done;

       Disposes of MainWindow and closes the graphics mode.

  Procedure TsApplication.InitMainWindow;

       Calls the MainWindow's Paint Method.
       When overridden, it is important to call this method after your
       new method.

  Procedure TsApplication.Run;

       Checks for Mouses Events and passes them to the MainWindow.
       MainWindow will in turn pass the events down until some window
       uses it.  If not, it will  be passed back up the parents and then
       they can use it.  The smallest child gets the event first.
       If overridden, call MainWindow^.Event and check if MainWindow^.Close
       is true before exiting.

  Procedure TsWindow.HandleEvent(evX,evY:Word;var Msg:Byte);

       Sorts out the events and does their functions.  Handles maximize,
       selection, close.

  Procedure TsWindow.Event(evX,evY:Word;var Msg:Byte);

       Keeps track and handles the repainting of windows to avoid unnecessary
       repainting.

  Procedure TsWindow.PaintUp;

       Same here.

  Procedure TsWindow.Paint;

       Draws the window and all children.  If this is overridden, it also
       needs to be called.

  Constructor TsView.Init(sX,sY,sW,sH:Word;sFT,sColor:Byte);

       Initializes variables.

  Procedure TsDisplay.SetUpWindow;

       Draws window.

  Procedure TsMaximize.SetUpWindow;

       Draws Maximize Button.

  Procedure TsSystem.SetUpWindow;

       Draws System Button.

  Procedure TsTitle.SetUpWindow;

       Draws Title Bar

  Procedure TsFrame.SetUpWindow;

       Draws Frame

  Procedure TsWindow.SetUpWindow;

       Calls all the pieces to be drawn.

  Constructor TsWindow.Init(sParent:PsWindow;sTitle:String;sX,sY,sW,sH:Word);

       Sets up variables, Creates child list, Sets Parent pointer, adds self
       to parent's child list, Calls TsObject.Init

  Procedure TsWindow.DeleteChildren;

      Disposes of all children and their children....

  Procedure TsWindow.Clear;

      Clears the window and sets the viewport to whole screen.

  Destructor TsWindow.Done;

      Calls DeleteChildren, Dispose of Window List, Clear the window.
      Deletes self from parent's child list.  Calls parent to paint.
      Calls TsObject.Done

Begin
End.