{

                                                      ͻ
                                                          Stack Unit    
                                                        (Simple Array)  
                                                          Rev. 1.01     
                                                      ͼ

}

{$F-} {$O-} {$A+} {$G-}
{$V-} {$B-} {$X-} {$N+} {$E+}

{$I FINAL.PAS}

{$IFDEF FINAL}
  {$I-} {$R-}
  {$D-} {$L-} {$S-}
{$ENDIF}

Unit DBStack;

Interface

Const
  MaxData      = 10;

Type

  Data         = Record
                   FileStart,
                   FileEnd   :LongInt;
                 End;

  StackArray   = Array [1..MaxData] of Data;

  StackObject  = Object

                   Procedure Init;
                   Function  Empty        :Boolean;
                   Function  Full         :Boolean;
                   Procedure Push(    Item:Data);
                   Procedure Pop (Var Item:Data);
                   Procedure Top (Var Item:Data);
                   Procedure Drop;
                   Procedure Destroy;

                 Private

                   StackData:StackArray;
                   StackPtr :Word;

                 {$IFDEF NOTFINAL}

                   Procedure Error(Num:Byte);

                 {$ENDIF}

                 End;

Implementation

{Include Error Checking iff Debug Information is Required}

{$IFDEF NOTFINAL}

Procedure StackObject.Error(Num:Byte);
Begin

  WriteLn;
  Write('Runtime Error Stack-',Num,'  ');

  Case Num Of
    1:Write('Stack Overflow');
    2:Write('Stack Underflow');
  End;

  WriteLn('.');

  Halt;
End;

{$ENDIF}

Procedure StackObject.Init;
Begin
  StackPtr:=0;
End;

Function StackObject.Empty:Boolean;
Begin
  If StackPtr=0 Then
    Empty:=True
  Else
    Empty:=False;
End;

Function StackObject.Full:Boolean;
Begin
  If StackPtr=MaxData Then
    Full:=True
  Else
    Full:=False;
End;

Procedure StackObject.Push(Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Full Then Error(1);

  {$ENDIF}

  Inc(StackPtr);
  StackData[StackPtr]:=Item;
End;

Procedure StackObject.Pop(Var Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Item:=StackData[StackPtr];             {Could Top and Drop, but
                                          this is much faster}
  Dec(StackPtr);
End;

Procedure StackObject.Top(Var Item:Data);
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Item:=StackData[StackPtr];
End;

Procedure StackObject.Drop;
Begin

  {$IFDEF NOTFINAL}

    If Empty Then Error(2);

  {$ENDIF}

  Dec(StackPtr);
End;

Procedure StackObject.Destroy;
Begin
  StackPtr:=0;
End;

End.

{
ͻ
                   Pure Power Software                        
Ķ
                                                              
       This  software  is copyright by Michael Gallias.       
                                                              
       .NG file available for this unit.                      
                                                              
ͼ
}
