(*****************************************************************************

  Time
    Version 1.2

  Purpose:
    This unit is designed to initiate precise system timing routines for
    measuring processing time for certain routines.  It also allows for the
    Precise timing in time sensitive operations.

  Features:
    Returns accurate timing value in a real number in seconds.
    Includes procedure to calculate accuracy adjustment.
    The time exactly between the two procedures is
      End_Timer - Accuracy_Adjustment

  Limitations:
    Since these routines use the system clock, the accuracy decreases with
      faster processors.

  Versions:
    1.2 - Modified the code to also compile under Speed Pascal/2.

  Copyright 1990, 1996 all rights reserved.
    Paul Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Unit Time;

  Interface

    Uses
      DOS;

(***********************************************************

  Procedure: Start timer.

    This procedure takes the initial time and stores it.

***********************************************************)

    Procedure Start_Timer;

(***********************************************************

  Function: End timer.

    This function is called after Start_Timer to get the
    system time and calculate the amount of time lost
    between the interval.  The result is returned in seconds
    as a real number.

***********************************************************)

    Function End_Timer: Real;

(***********************************************************

  Function: Accuracy adjustment.

    This function returns in seconds the amount of time it
    takes to perform the two functions.  By subtracting this
    value from the result of End_Timer, the true amount of
    time can be obtained to process the code between.

***********************************************************)

    Function Accuracy_Adjustment: Real;

(***********************************************************

  Procedure: Wait to.

    This procedure is called after Start_Timer to extend the
    required time of an operation, usually sandwiched in
    between the two routines.  This procedure polls the
    system until the alloted time has past beween the call
    to Start_Timer and Wait_To.  Real is in seconds.

***********************************************************)

    Procedure Wait_To( When: Real );

{----------------------------------------------------------------------------}

  Implementation

    Const
      { This value holds the beginning clock value. }
      Start_Time: LongInt = 0;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Get_Time.
    This function gets the time from the system
    and returns it in the form of hundreds of a
    second.

*************************************************)

    Function Get_Time: LongInt;
      Var
        Hour,
        Minute,
        Second,
        Second100: Word;
      Begin
        GetTime( Hour, Minute, Second, Second100 );
        Get_Time := ( ( Hour * 360000 ) + ( Minute * 6000 ) + ( Second * 100 ) + Second100 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Convert time to seconds.
    This function converts the given data to real
    seconds.

*************************************************)

    Function Convert_Time_To_Seconds( Time: LongInt ): Real;
      Begin
        Convert_Time_To_Seconds := ( Time / 100 );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Start timer.
    As previously defined.

*************************************************)

    Procedure Start_Timer;
      Begin
        Start_Time := Get_Time;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: End timer.
    As previously defined.

*************************************************)

    Function End_Timer: Real;
      Var
        End_Time: LongInt;
      Begin
        End_Time := Get_Time;
        End_Timer := Convert_Time_To_Seconds( ( End_Time - Start_Time ) );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Accuracy adjustment.
    As previously defined.

*************************************************)

    Function Accuracy_Adjustment: Real;
      Var
        Save_Time: LongInt;
      Begin
        Save_Time := Start_Time;
        Start_Timer;
        Accuracy_Adjustment := End_Timer;
        Start_Time := Save_Time;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Do absolutely nothing.
    This procedure does absolutely nothing
    useful for the system.

*************************************************)

    Procedure Do_Absolutely_Nothing;
      Var
        Count: Byte;
      Begin
        For Count := 1 to 10 do
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Wait to.
    As previously defined.

*************************************************)


    Procedure Wait_To( When: Real );
      Var
        End_Time: LongInt;
      Begin
        Repeat
          Do_Absolutely_Nothing;
          End_Time := Get_Time;
        Until ( When <= Convert_Time_To_Seconds( End_Time - Start_Time ) )
      End;

{----------------------------------------------------------------------------}

  End.

