(*****************************************************************************

  Program:  Point demonstration.

  Purpose:
    This program demonstrates the pointer interface unit.

  Features:
    This program merely displays the pointer cursor on the screen and the
    value of the indicators as returned by the unit.  It stops when a key
    is pressed.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  System:
    MS-DOS, MDOS, OS/2

*****************************************************************************)


Program Pointer_Demonstration( Input, Output );

  Uses
    CRT,
   {$IFNDEF OS2}
    Pointer;
   {$ELSE}
    Pointer_;
   {$ENDIF}

  Var
    Pointer_Data: Pointer_Data_Type;

  Begin
    WriteLn( 'Pointer demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the pointer unit.  All it does is display at the' );
    WriteLn( 'top of the screen the current location of the pointer device.  Any key will' );
    WriteLn( 'stop this program.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;
    ClrScr;
    Display_Pointer;
    Repeat
      GotoXY( 1, 1 );
      Read_Pointer( Pointer_Data );
      With Pointer_Data do
        Write( Button1:6, Button2:6, Row:3, Column:3, X:6, Y:6 );
    Until KeyPressed;
  End.

