(*****************************************************************************

  Program:  Music demonstration.

  Purpose:
    This unit demonstrates the abilities of the music unit.

  Features:
    The music unit processes in the background.  So all that must be done
    is programming the music and stopping it when it's done.

  Copyright 1994, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0.
    Speed Pascal/2 version Beta 4.

  Systems:
    MS-DOS, MDOS, OS/2.

*****************************************************************************)

Program Music_Demonstration( Input, Output );

  Uses
    CRT,
    Music;

  Var
    Counter: Word;

  Begin
    WriteLn( 'Music unit demonstration program.' );
    WriteLn( 'Copyright 1994, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program attempts to demonstrate the abilites of the music unit' );
    WriteLn( 'A series of notes will be programmed into the music queue.  These notes' );
    WriteLn( 'will be played automatically in the background while the program goes' );
    WriteLn( 'through a simple looping mechanism.' );
    WriteLn;
    WriteLn( 'Note:  This program runs longer on slower machines.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;

    DirectVideo := True;

    { Music demonstration }

    Add_Note_To_Music( A4, 0.07 );
    Add_Note_To_Music( An4, 0.05 );
    Start_Music;

    For Counter := 1 to 500 do
      WriteLn( Counter );

    { Music demonstration }

    Clear_Music;
    Add_Sound_To_Music( 900, 1 );
    Add_Sound_To_Music( 760, 1 );
    Start_Music;

    For Counter := 1 to 500 do
      WriteLn( Counter );

    Stop_Music;

  End.

