{$F+} { Set all procedure and function calls to far. } { Do Not Change! }

(*****************************************************************************

  ANSI Crt
    version 1.1 (Beta version)

  This is a unit that simulates part of the Borland Pascal CRT unit entirely
    by using ANSI screen commands.

  Features:
    Simulates many of the features of Turbo Pascal's CRT unit.
    Keeps track of the entire screen characters internally.
    Designed to make programming dumb ANSI terminals easier.

  How it works:
    Uses standard ANSI codes for moving around the screen instead of using
      the system's internal routines.

  Warning!
    Not for use with Turbo Pascal's CRT unit.

  Versions:
    Version 1.1 added better support for write's and writeLn's.

  CopyRight 1990, all rights reserved.
    Paul Renaud.

  Compiler:
    Turbo Pascal versions 4.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit ANSI_Crt;

  Interface

    Uses
      DOS;

(***********************************************************

  These two constants define the two different video modes
    that the unit supports.  ANSI codes will not work well
    in graphical environments.

***********************************************************)

    Const
      BW80 = 2;  { 80X25 B/W On Color Adapter }
      CO80 = 3;  { 80X25 Color On Color Adapter }

(***********************************************************

  These constants define the possible colors supported by
    the ANSI system.

***********************************************************)

    Const
      Black = 0;
      Blue = 1;
      Green = 2;
      Cyan = 3;
      Red = 4;
      Magenta = 5;
      Yellow = 14;
      White = 15;

(***********************************************************

  Wrap alters the ability of the unit to wrap around the
    text to the next line when it reaches the end of the
    screen window.

***********************************************************)

    Var
      Wrap: Boolean;

(***********************************************************

  Procedure:  Clear to end of line.

    This procedure clears the text from the current cursor
    position to the end of the current line.

***********************************************************)

    Procedure ClrEOL;

(***********************************************************

  Procedure:  Clear screen.

    This procedure clears the current screen window of all
    text.

***********************************************************)

    Procedure ClrScr;

(***********************************************************

  Procedure:  Delete line.

    This procedure deletes the current cursor line and moves
    all proceeding lines up in the current screen window.

***********************************************************)

    Procedure DelLine;

(***********************************************************

  Procedure:  Goto x, y.

    This procedure moves the current cursor position to the
    approximate coordinates in the current screen window.
      X defines the column while Y defines the row starting
      from the top.

***********************************************************)

    Procedure GotoXY( X, Y: Byte );

(***********************************************************

  Procedure:  High video.

    This procedure changes the video attribute to produce
    bright characters on a black background.

***********************************************************)

    Procedure HighVideo;

(***********************************************************

  Procedure:  Insert line.

    This procedure inserts a line in the current row of the
    cursor and moves the proceeding lines in the current
    window down.

***********************************************************)

    Procedure InsLine;

(***********************************************************

  Procedure:  Low video.

    This procedure changes the video attribute to produce
    dim characters on a black background.

***********************************************************)

    Procedure LowVideo;

(***********************************************************


  Procedure:  Normal video.

    This procedure changes the video attribute to produce
    bright characters on a black background.

***********************************************************)

    Procedure NormVideo;

(***********************************************************

  Procedure:  Text background.

    This procedure alters the background color of the
    current screen window to that provided in Color.

***********************************************************)

    Procedure TextBackground( Color: Byte );

(***********************************************************

  Procedure:  Text color.

    This procedure alters the current text color in the
    current screen window to that provided in Color.

***********************************************************)

    Procedure TextColor( Color: Byte );

(***********************************************************

  Procedure:  Text mode.

    This procedure alters the current mode of the text
    screen.  Currently it supports only the modes defined
    in the constant section.

***********************************************************)

    Procedure TextMode( Mode: Byte );

(***********************************************************

  Procedure:  Window.

    This procedure defines the current screen window by the
    given values.  The left side is determined by column X1,
    the right side is determined by column X2.  The top is
    determined by row Y1 and the bottom by row Y2.

***********************************************************)

    Procedure Window( X1, Y1, X2, Y2: Byte );

(***********************************************************

  Procedure:  Assign file to ANSI screen.

    This procedure assigns the given file to write to the
    current screen window.  Output is automatically
    redefined using this procedure in the initialization
    section.

***********************************************************)

    Procedure Assign_ANSI( Var The_File: Text );

(***********************************************************

  Function:  Where x.

    This function returns the value of the current cursor's
    column position in the current window.

***********************************************************)

    Function  WhereX: Byte;

(***********************************************************

  Function:   Where y.

    This function returns the value of the current cursor's
    row position in the current window.

***********************************************************)

    Function  WhereY: Byte;

{-----------------------------------------------------------------------------}

  Implementation

    Const
     { Defines the escape code used for the system. }
      Esc = #27;

    Type
     { Defines the data structure necessary to hold the screen data. }
      Screen_Type = array[ 1 .. 25, 1 .. 80 ] of Record
                                                   Character: Char;
                                                   T_Color,
                                                   B_Color: Byte;
                                                 End;

    Var
     { These variables define the location of the current screen window. }
      Top,
      Left,
      Right,
      Bottom,
     { This variable defines the current text color. }
      Text_Color,
     { These variables define the current cursor location. }
      Cursor_Row,
      Cursor_Column,
     { This variable defines the current background color. }
      BackGround_Color: Byte;
     { This variable holds the current screen data. }
      Screen: Screen_Type;
     { This file is used to transfer data to the ANSI screen system. }
      OutWrite: Text;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Goto x, y absolute.
    This procedure moves the real screen cursor to
    the absolute location defined by X and Y.
    It's location is defined in absolute terms
    from the screen and not by the current window.

*************************************************)

    Procedure GotoXY_Absolute( X, Y: Byte );
      Var
        Row_String,
        Column_String: String;
      Begin
        If ( X < 1 )
          then
            X := 1
          else
            If ( X > 80 )
              then
                X := 80;
        If ( Y < 1 )
          then
            Y := 1
          else
            If ( Y > 24 )
              then
                Y := 24;
        Cursor_Column := X;
        Cursor_Row := Y;
        Str( Y, Row_String );
        Str( X, Column_String );
        Write( OutWrite, Esc, '[', Row_String, ';', Column_String, 'H' );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Clear to end of line.
    As previously defined.

*************************************************)

    Procedure ClrEOL;
      Var
        Data1: String;
        Count: Integer;
        Row,
        Column: Byte;
      Begin
        Data1 := '';
        Row := Cursor_Row;
        Column := Cursor_Column;
        For Count := Column to Right do
          Begin
            Data1 := Data1 + ' ';
            With Screen[ Row, Count ] do
              Begin
                T_Color := Text_Color;
                B_Color := Background_Color;
                Character := ' ';
              End;
          End;
        Write( OutWrite, Data1 );
        GotoXY_Absolute( Column, Row );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Text color.
    As previously defined.

*************************************************)

    Procedure TextColor( Color: Byte );
      Begin
        If ( Color <> Text_Color )
          then
            Case Color of
              Black:
                Write( OutWrite, Esc, '[', '3', '0', 'm' );
              Red:
                Write( OutWrite, Esc, '[', '3', '1', 'm' );
              Green:
                Write( OutWrite, Esc, '[', '3', '2', 'm' );
              Yellow:
                Write( OutWrite, Esc, '[', '3', '3', 'm' );
              Blue:
                Write( OutWrite, Esc, '[', '3', '4', 'm' );
              Magenta:
                Write( OutWrite, Esc, '[', '3', '5', 'm' );
              Cyan:
                Write( OutWrite, Esc, '[', '3', '6', 'm' );
              White:
                Write( OutWrite, Esc, '[', '3', '7', 'm' );
            End; { Case }
        Text_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Text background.
    As previously defined.

*************************************************)

    Procedure TextBackground( Color: Byte );
      Begin
        If ( Color <> Background_Color )
          then
            Case Color of
              Black:
                Write( OutWrite, Esc, '[', '4', '0', 'm' );
              Red:
                Write( OutWrite, Esc, '[', '4', '1', 'm' );
              Green:
                Write( OutWrite, Esc, '[', '4', '2', 'm' );
              Yellow:
                Write( OutWrite, Esc, '[', '4', '3', 'm' );
              Blue:
                Write( OutWrite, Esc, '[', '4', '4', 'm' );
              Magenta:
                Write( OutWrite, Esc, '[', '4', '5', 'm' );
              Cyan:
                Write( OutWrite, Esc, '[', '4', '6', 'm' );
              White:
                Write( OutWrite, Esc, '[', '4', '7', 'm' );
            End; { Case }
        Background_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Delete line.
    As previously defined.

*************************************************)

    Procedure DelLine;
      Var
        Row,
        Column: Integer;
        Save_Row,
        Save_Text,
        Save_Back,
        Save_Column: Byte;
      Begin
        Save_Row := Cursor_Row;
        Save_Column := Cursor_Column;
        Save_Text := Text_Color;
        Save_Back := Background_Color;
        For Row := Cursor_Row to Pred( Bottom ) do
          Begin
            GotoXY_Absolute( Left, Row );
            For Column := Left to Right do
              Begin
                Screen[ Row, Column ] := Screen[ Succ( Row ), Column ];
                TextColor( Screen[ Row, Column ].T_Color );
                TextBackground( Screen[ Row, Column ].B_Color );
                Write( OutWrite, Screen[ Row, Column ].Character );
              End;
          End;
        GotoXY_Absolute( Left, Bottom );
        For Column := Left to Right do
          With Screen[ Bottom, Column ] do
            Begin
              Character := ' ';
              B_Color := Background_Color;
              T_Color := Background_Color;
              Write( OutWrite, ' ' );
            End;
        TextColor( Save_Text );
        TextBackground( Save_Back );
        GotoXY_Absolute( Save_Column, Save_Row );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Clear screen.
    As previously defined.

*************************************************)

    Procedure ClrScr;
      Var
        Row,
        Column: Byte;
        Data: String;
      Begin
        FillChar( Data, SizeOf( Data ), ' ' );
        Data[ 0 ] := Chr( Succ( Right - Left ) );
        For Row := Top to Bottom do
          Begin
            GotoXY_Absolute( Left, Row );
            Write( OutWrite, Data );
            For Column := Left to Right do
              With Screen[ Row, Column ] do
                Begin
                  Character := ' ';
                  T_Color := Text_Color;
                  B_Color := BackGround_Color;
                End;
          End;
        GotoXY_Absolute( Left, Top );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Goto x, y.
    As previously define.

*************************************************)

    Procedure GotoXY( X, Y: Byte );
      Var
        Row_String,
        Column_String: String;
      Begin
        Cursor_Column := Pred( Left + X );
        Cursor_Row := Pred( Top + Y );
        If ( Cursor_Column < Left )
          then
            Cursor_Column := Left
          else
            If ( Cursor_Column > Right )
              then
                Cursor_Column := Right;
        If ( Cursor_Row < Top )
          then
            Cursor_Row := Top
          else
            If ( Cursor_Row > Bottom )
              then
                Cursor_Row := Bottom;
        Str( Cursor_Row, Row_String );
        Str( Cursor_Column, Column_String );
        Write( OutWrite, Esc, '[', Row_String, ';', Column_String, 'H' );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Insert line.
    As previously defined.

*************************************************)

    Procedure InsLine;
      Var
        Row,
        Column: Integer;
        Save_Row,
        Save_Back,
        Save_Text,
        Save_Column: Byte;
      Begin
        Save_Row := Cursor_Row;
        Save_Column := Cursor_Column;
        Save_Back := Background_Color;
        Save_Text := Text_Color;
        For Row := Bottom downto Succ( Cursor_Row ) do
          Begin
            GotoXY_Absolute( Left, Row );
            For Column := Left to Right do
              Begin
                Screen[ Row, Column ] := Screen[ Pred( Row ), Column ];
                TextColor( Screen[ Row, Column ].T_Color );
                TextBackground( Screen[ Row, Column ].B_Color );
                Write( OutWrite, Screen[ Row, Column ].Character );
              End;
          End;
        GotoXY_Absolute( Left, Save_Row );
        TextColor( Save_Text );
        TextBackground( Save_Back );
        For Column := Left to Right do
          With Screen[ Cursor_Row, Column ] do
            Begin
              Character := ' ';
              B_Color := Save_Back;
              T_Color := Save_Text;
              Write( OutWrite, ' ' );
            End;
        GotoXY_Absolute( Save_Column, Save_Row );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Low video.
    As previously defined.

*************************************************)

    Procedure LowVideo;
      Begin
        Text_Color := White;
        Background_Color := Black;
        Write( OutWrite, Esc, '[37;40;2m' );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Normal video.
    As previously defined.

*************************************************)

    Procedure NormVideo;
      Begin
        Text_Color := Yellow;
        Background_Color := Black;
        Write( OutWrite, Esc, '[33;40M' );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: High video.
    As previously defined.

*************************************************)

    Procedure HighVideo;
      Begin
        Text_Color := Yellow;
        Background_Color := Black;
        Write( OutWrite, Esc, '[33;40M' );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Text mode.
    As previouly defined.

*************************************************)

    Procedure TextMode( Mode: Byte );
      Begin
        Case Mode of
          BW80: System.Write( OutWrite, Esc, '[', '=', '2', 'h' );
          CO80: System.Write( OutWrite, Esc, '[', '=', '3', 'h' );
        End; { Case }
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Window.
    As previously defined.

*************************************************)

    Procedure Window( X1, Y1, X2, Y2: Byte );
      Begin
        If ( X1 < 1 )
          then
            X1 := 1;
        If ( Y1 < 1 )
          then
            Y1 := 1;
        If ( X2 > 80 )
          then
            X2 := 80;
        If ( Y2 > 24 )
          then
            Y2 := 24;
        If ( X2 < X1 )
          then
            X2 := X1;
        If ( Y2 < Y1 )
          then
            Y2 := Y1;
        Left := X1;
        Top := Y1;
        Right := X2;
        Bottom := Y2;
        GotoXY( 1, 1 );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function:  Where x.
    As previously defined.

*************************************************)

    Function WhereX: Byte;
      Begin
        WhereX := ( Succ( Cursor_Column ) - Left );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function:  Where y.
    As previously defined.

*************************************************)

    Function WhereY: Byte;
      Begin
        WhereY := ( Succ( Cursor_Row ) - Top );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Put on the screen.
    This procedure puts the character given in
    Piece in the current cursor location in the
    current screen window.

*************************************************)

    Procedure PutScreen( Piece: Char );
      Begin
        If ( Cursor_Column <= Right )
          then
            Begin
              With Screen[ Cursor_Row, Cursor_Column ] do
                Begin
                  Character := Piece;
                  T_Color := Text_Color;
                  B_Color := Background_Color;
                End;
              Inc( Cursor_Column );
              Write( OutWrite, Piece );
              If ( Wrap and ( Cursor_Column > Right ) )
                then
                  Begin
                    Cursor_Column := Left;
                    Inc( Cursor_Row );
                    If ( Cursor_Row > Bottom )
                      then
                        Begin
                          GotoXY_Absolute( Left, Top );
                          DelLine;
                          GotoXY_Absolute( Left, Bottom );
                        End;
                    GotoXY_Absolute( Cursor_Column, Cursor_Row );
                  End;
            End
          else
            If Wrap
              then
                Begin
                  Cursor_Column := Left;
                  Inc( Cursor_Row );
                  If ( Cursor_Row > Bottom )
                    then
                      Begin
                        GotoXY_Absolute( Left, Top );
                        DelLine;
                        GotoXY_Absolute( Left, Bottom );
                      End;
                  GotoXY_Absolute( Cursor_Column, Cursor_Row );
                  With Screen[ Cursor_Row, Cursor_Column ] do
                    Begin
                      Character := Piece;
                      T_Color := Text_Color;
                      B_Color := Background_Color;
                    End;
                  Inc( Cursor_Column );
                  Write( OutWrite, Piece );
                End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Move down a line.
    This procedure moves the current cursor down
    a line in the current window as if a line
    down and carriage return were employed.

*************************************************)

    Procedure Move_Down_A_Line;
      Begin
        If ( Cursor_Row = Bottom )
          then
            Begin
              GotoXY_Absolute( Left, Top );
              DelLine;
              GotoXY_Absolute( Left, Bottom );
            End
          else
            GotoXY_Absolute( Left, Succ( Cursor_Row ) );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function:  File output.
    This function takes the output to the file
    and transfers it to the current screen window.

*************************************************)

    Function File_Output( Var The_File: TextRec ): Integer;
      Var
        Point: Word;
      Begin
        With The_File do
          Begin
            Point := 0;
            While ( Point < BufPos ) do
              Begin
                Case BufPtr^[ Point ] of
                  #10:
                    Move_Down_A_Line;
                  #13:
                    { Here we would return to the first column. } ;
                  else
                    PutScreen( BufPtr^[ Point ] );
                End; { Case }
                Inc( Point );
              End;
            BufPos := 0;
          End;
        File_Output := 0;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function:  File close.
    This function closes the ANSI screen file.

*************************************************)

    Function File_Close( Var The_File: TextRec ): Integer;
      Begin
        File_Close := 0;
        The_File.Mode := FmClosed;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function:  File open.
    This function initializes the file variables
    so that writes are directed to the ANSI window
    screen.

*************************************************)

    Function File_Open( Var The_File: TextRec ): Integer;
      Begin
        File_Open := 0;
        The_File.Mode := FmOutput;
        The_File.InOutFunc := @File_Output;
        The_File.FlushFunc := @File_Output;
        The_File.CloseFunc := @File_Close;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure:  Assign file to ANSI screen.
    As previously defined.

*************************************************)

    Procedure Assign_ANSI( Var The_File: Text );
      Begin
        With TextRec( The_File ) do
          Begin
            Mode := FmClosed;
            BufSize := SizeOf( Buffer );
            BufPtr := @Buffer;
            OpenFunc := @File_Open;
            Name[ 0 ] := #0;
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    This section sets up a file for the output to
    the ANSI screen driver and sets up the
    variables to define the whole screen as a
    window.  Finally the standard file is
    reinitialized so that it intercepts the screen
    output and directs it to the ANSI system.

*************************************************)

  Begin
    Assign( OutWrite, '' );
    Rewrite( OutWrite );
    Top := 1;
    Left := 1;
    Right := 80;
    Bottom := 24;
    Background_Color := White;
    Text_Color := Black;
    TextColor( White );
    TextBackground( Black );
    ClrScr;
    Wrap := False;
    Assign_ANSI( OutPut );
    Rewrite( Output );
  End.

