program GetDisplayMode;

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{  Program to illustrate Turbo Pascal INTR procedure, which uses DOS. }
{                                                                     }
{  The BIOS Interrupt Service 10 Hex is used with Function (AH) = 0F  }
{                                                                     }
{  For use with Version 5+ of Turbo Pascal. Version 3 is different    }
{  because Registers is not predefined in DOS, but user defined.      }
{                                                                     }
{  INTRDEMO.PAS  -> .EXE    R. Shaw      10.3.90                      }
{_____________________________________________________________________}

uses DOS, Crt;

var
   Regs        : Registers;    { Registers is a record defined in DOS }
   Mode        : Byte;
   Width       : Byte;
   Page        : Byte;
   DisplayMode : String[20];

begin
   Regs.AX := $0F00;           { Sets AH = 0F for Get Display Mode function }
   Intr($10,Regs);             { Interrupt 10 for ROM BIOS Video Services }
   Mode  := Lo(Regs.AX);       { Display Mode returned in AL }
   Width := Hi(Regs.AX);       { Screen width returned in AH }
   Page  := Hi(Regs.BX);       { Screen page returned in BH }

   ClrScr;                                { Uses Crt }
   Writeln('Display Mode is ',Mode);
   Writeln('Screen Width is ',Width,' Columns');
   Writeln('Screen Page is ',Page);
   writeln;
   write('Press any key to conclude...');
   repeat until keypressed;
end.