;=======================================================================
; MODULE NAME:  StrPos.ASM
; DEPENDENCIES: (None)
; LAST MOD ON:  9005.08
; PROGRAMMER:   Naoto Kimura
;
;     This is the assembly code for the routines in the StrUtil unit.
; Many of the routines were rewritten in the hopes that it will not
; only reduce the memory requirement, but also reduce the execution
; time.
;
;     This file should be assembled with Turbo Assembler.  If you need
; to use another assembler, then you should keep some things in mind.
;
; The TPASCAL memory model sets up automatically:
; * the standard Turbo Pascal entry code
;      push bp
;      mov bp,sp
; * the standard Turbo Pascal exit code
;      pop bp
;      ret n
; * the order of the arguments don't need to be reversed in the
;   assembly code.
;-----------------------------------------------------------------------
; 9001.20     Naoto Kimura
;             * Initial version created
;
; Modification history:
;
; 9002.27     Naoto Kimura
;             * Corrected code for RightPos.  It used to give the wrong
;               results.  Rewritten using the SCASB instruction.
;             * Added function LeftPos which does a similar task as the
;               RightPos function.
; 9005.05     Naoto Kimura
;             * Broke up assembler modules into separate files to try
;               to decrease overhead (although the overhead is pretty
;               small, it's always nice to make available whatever
;               memory the user can use).
; 9005.05     Naoto Kimura
;             * Added RPos to the functions rewritten in assembly.
; 9005.05     Naoto Kimura
;             * Made minor changes trying to minimize number of
;               jumps in code.
;=======================================================================
.MODEL   TPASCAL
LOCALS

.CODE

;-----------------------------------------------------------------------
;FUNCTION RPos( Needle,HayStack : string ) : Byte
;
;     This function returns the last matching position of "Needle" in
; "HayStack."
;
; REGISTER USAGE:  AX			-- Return value
;                  BX,CX,DI,SI,ES	-- Destroyed
;-----------------------------------------------------------------------
PROC	RPos	FAR	Needle:DWORD,HayStack:DWORD
		PUBLIC	RPos
		USES	ds
;
		xor	ax,ax
		mov	bx,ax
		les	di,[HayStack]	;IF Length(HayStack)=0 THEN
		mov	al,[es:di]
		or	al,al
		jz	Done		;   Return(0)
		; NOTE: ax <-- Length(HayStack)
		lds	si,[Needle]	;IF Length(Needle) = 0 THEN
		mov	bl,[ds:si]
		or	bl,bl
		jz	Done		;   Return(Length(HayStack))
		; NOTE: bx <-- Length(Needle)
		cmp	al,bl		;IF Length(Needle) > Length(HayStack) THEN
		jl	@@NotFound
		mov	cx,ax		;  cx <-- length(HayStack)
		sub	cx,bx		;         - length(Needle)
		inc	cx		;         + 1
		add	di,cx		;  di <-- ofs(HayStack[cx])
					;  REPEAT
@@More:		std			;    reverse string op
		mov	al,[si+1]	;    ax <-- Needle[1]
		repne scasb
		je	@@Ok		;    if not found then
@@NotFound:	mov	ax,0		;        Return(0)
		jmp	Done
@@Ok:		mov	ax,cx
		mov	dx,di
		inc	di		;    adjust di
		inc	si		;    move ds:si to 1st char
		cld			;    forward string op
		mov	cx,bx
		repz cmpsb		;    test match
		jz	@@Found		;
		lds	si,[Needle]
		mov	di,dx
		mov	cx,ax
		or	cx,cx		;  UNTIL cx=0
		jnz	@@More
					;END IF
@@Found:	sub	di,bx		;adjust di
		mov	ax,di
		les	di,[HayStack]
		sub	ax,di
Done:		ret
	ENDP

;-----------------------------------------------------------------------
;FUNCTION RightPos ( S:String; C:Char ) : Integer
;
;     This function returns the last matching position of character
; "C" in "S".
;
; REGISTER USAGE:  AX		-- Return value
;                  BX,CX,DI,ES	-- Destroyed
;-----------------------------------------------------------------------
RightPos	PROC FAR S:DWORD,C:BYTE
		PUBLIC	RightPos
		USES	DS
		les	di,[S]		; get addr of function parameter
		xor	ax,ax
		mov	al,[es:di]
		or	ax,ax
		jz	@@done
		mov	bx,di
		dec	bx
		mov	cx,ax
		add	di,cx
		mov	al,[C]
		std			; backward string op
		repne scasb		; search
		je	@@Found
		mov	di,bx
@@Found:	xchg	ax,di
		sub	ax,bx
@@done:		ret
RightPos	ENDP

;-----------------------------------------------------------------------
;FUNCTION LeftPos ( S:String; C:Char ) : Integer
;
;     This function returns the first matching position of character
; "C" in "S".
;
; REGISTER USAGE:  AX		-- Return value
;                  BX,CX,DI,ES	-- Destroyed
;-----------------------------------------------------------------------
LeftPos		PROC FAR S:DWORD,C:BYTE
		PUBLIC	LeftPos
		USES	DS
		xor	ax,ax
		les	di,[S]		; get addr of function parameter
		mov	al,[es:di]
		or	ax,ax
		jz	@@done
		inc	di
		mov	bx,di
		mov	cx,ax
		mov	al,[C]
		cld			; forward string op
		repne scasb		; search
		je	@@Found
		mov	di,bx
@@Found:	xchg	ax,di
		sub	ax,bx
@@done:		ret
LeftPos		ENDP

END
