unit ErrMsg;
(*====================================================================*\
|| MODULE NAME:  ErrMsg                                               ||
|| DEPENDENCIES: System                                               ||
|| LAST MOD ON:  9004.08                                              ||
|| PROGRAMMER:   Naoto Kimura                                         ||
||                                                                    ||
||     This unit was made for those who want to have more descriptive ||
|| error messages from Turbo Pascal programs.  The error messages     ||
|| will be sent to the standard DOS output file.  The "EndWait" unit  ||
|| is installed for version 5 of the compiler.                        ||
||                                                                    ||
|| MODIFICATION HISTORY:                                              ||
|| 8905.31       Naoto Kimura                                         ||
||               Original release                                     ||
|| 9001.17       Naoto Kimura                                         ||
||               Modified to use some of the lower level DOS system   ||
||               calls to try to shrink code.                         ||
||               (The TPU file shrunk to slightly more than half the  ||
||                original size)                                      ||
|| 9004.08       Naoto Kimura                                         ||
||               Rewrote parts in assembler to make more compact.     ||
||               (The TPU file shrunk to less than half the original  ||
||                size!)                                              ||
|| 9005.11       Naoto Kimura                                         ||
||               Added error message for version 5.5 of Turbo Pascal. ||
\*====================================================================*)
{$D-}	{No debug information}
{$R-}	{No range checking}
{$O-}	{Overlay disallowed}
{$S-}	{No stack checking}

interface

{$IFNDEF VER40}
uses
    EndWait;
{$ENDIF}

(*--------------------------------------------------------------------*\
| "VerboseMsg" is a static variable that determines the verbosity of   |
| the error messages.   If TRUE, then the error messages are verbose,  |
| usually including a message listing the possible causes for the      |
| error.                                                               |
\*--------------------------------------------------------------------*)
const {really a static variable}
    VerboseMsg	: boolean	= TRUE;

implementation

const
    ExitSave	: pointer	= NIL;

(*--------------------------------------------------------------------*\
| NAME: ErrorMessage                                                   |
|                                                                      |
|     This is the procedure installed by the ErrMsg unit as an exit    |
| procedure.   This procedure prints out a text message that will be   |
| more helpful than the plain error code numbers output by the exit    |
| procedure in the standard Turbo Pascal "System" unit.                |
\*--------------------------------------------------------------------*)
{$F+}
{$L ErrMsg.OBJ}
{far} procedure ErrorMessage;
    External;

begin (* unit initialization code *)
    ExitSave := ExitProc;		{Remember old exit procedure}
    ExitProc := @ErrorMessage		{Install error message routine}
end.
