IDEAL
MODEL	TPASCAL

DATASEG

; The following record type describes the contents of the Program
; Segment Prefix (PSP).
;
;    int20H		exit code
;    TopOfMemory	Memory size in paragraphs
;    Reserved0		??? (0)
;    PSP_DOS		Far call to DOS
;    TerminationAddr	Terminate address
;    BreakExitAddr	Address of break handler
;    CriticalErrorAddr	Address of critical error handler
;    ParentPSP_Seg	Parent PSP segment
;    OpenFiles		Open files, $ff = unused
;    EnvSeg	Environment segment
;    PSP_OldStack	far pointer to processes SS:SP ???
;    PSP_Nfiles		maximum open files
;    PSP_aofile		ofile address
;    Reserved3		Unused ???
;    PSP_int21		INT 21, far return
;    Reserved4		Unused ???
;    PSP_FCB1ext	FCB #1 extension
;    PSP_FCB1		FCB #1
;    PSP_FCB2ext	FCB #2 extension
;    PSP_FCB2		FCB #2
;    PSP_DMA		Command Tail
;
STRUC	PSPtype
	Int20		DW	?		;00
	TopOfMemory	DW	?		;02
	Reserved0	DB	?		;04
	PSP_DOS		DB	5 DUP(?)	;05
	TerminationAddr	DD	?		;0A
	BreakExitAddr	DD	?		;0E
	CriticalErrAddr	DD	?		;12
	ParentPSP_Seg	DW	?		;16
	OpenFiles	DB	20 DUP(?)	;18
	EnvironmentSeg	DW	?		;2C
	PSP_OldStack	DD	?		;2E
	PSP_Nfiles	DW	?		;32
	PSP_aofile	DD	?		;34
	Reserved3	DB	24 DUP(?)	;38
	PSP_int21	DB	3 DUP(?)	;50
	Reserved4	DB	2 DUP(?)	;53
	PSP_FCB1ext	DB	7 DUP(?)	;55
	PSP_FCB1	DB	9 DUP(?)	;5C
	PSP_FCB2ext	DB	7 DUP(?)	;65
	PSP_FCB2	DB	20 DUP(?)	;6C
	PSP_DMA		DB	128 DUP(?)	;80
ENDS

EXTRN	PrefixSeg:WORD

CODESEG

PUBLIC	DosVersion
PROC	DosVersion	FAR
	mov	ah,30h
	int	21h
	ret
ENDP

PUBLIC	GetCBreak
PROC	GetCBreak	FAR
	ARG	BreakPtr:DWORD
	mov	ax,3300h
	int	21h
	or	al,al
	jnz	@@Done		; Error if AL=0xff
	les	di,[BreakPtr]	; DL=0/1	OFF/ON
	mov	[es:di],dl
@@Done:	ret
ENDP

PUBLIC	SetCBreak
PROC	SetCBreak	FAR
	ARG	Break:BYTE
	mov	ax,3301h
	mov	dl,[Break]
	or	dl,dl
	jz	@@Go		; Already zero, so go ahead
	mov	dl,1		; not zero, so make sure it's a 1
@@Go:	int	21h
	ret
ENDP

PUBLIC	GetVerify
PROC	GetVerify	FAR
	ARG	VerifyPtr:DWORD
	mov	ax,5400h
	int	21h
	les	di,[VerifyPtr]
	mov	[es:di],al
	ret
ENDP

PUBLIC	SetVerify
PROC	SetVerify	FAR
	ARG	Verify:BYTE
	mov	ax,2e00h
	xor	dl,dl
	test	[Verify],0ffh
	jz	@@Go
	inc	ax
@@Go:	int	21h
	ret
ENDP

; NAME:  GetEnv
;
; EXTERNALS:
;     word        PrefixSeg   (System)
;PROC	GetEnv	FAR
;	ARG	EnvVar:DWORD	RETURNS Result:DWORD
;	USES	ds
;	xor	cx,cx		; clear CX
;	cld			; forward string op
;	les	di,[EnvVar]
;	lodsb
;	mov	si,cx		; clear SI
;	mov	cl,al		; CX <- length of environ var
;	mov	ds,[PrefixSeg]
;	mov	ds,[ds:(PSPtype PTR si).EnvironmentSeg]
;@@More:	mov	al,[ds:si]
;	or	ax,ax
;	jz	@@Done
;@@Chk:	mov	al,[ds:si]
;	cmp	al,[]
;	mov
;@@Done:	ret
;ENDP

;FUNCTION GetEnv( envvar : string ) : string;
;    VAR
;	i		: integer;
;	found		: boolean;
;	WorkBuffer	: string;
;    BEGIN  (* GetEnv *)
;	i := 0;
;	found := false;
;	WHILE NOT (found OR (mem[EnvironmentSeg:i]=0)) DO BEGIN
;	    WorkBuffer := '';
;	    WHILE mem[EnvironmentSeg:i] <> ord('=') DO BEGIN
;		WorkBuffer := WorkBuffer + chr(mem[EnvironmentSeg:i]);
;		Inc(i)
;	      END;
;	    Inc(i);		(* skip '=' *)
;	    found := WorkBuffer = envvar;
;	    WorkBuffer := '';
;	    WHILE mem[EnvironmentSeg:i] <> 0 DO BEGIN
;		WorkBuffer := WorkBuffer + chr(mem[EnvironmentSeg:i]);
;		Inc(i)
;	      END;
;	    Inc(i)		(* skip '\0' *)
;	  END;
;	IF found THEN
;	    GetEnv := WorkBuffer
;	ELSE
;	    GetEnv := ''
;    END;  (* GetEnv *)

;-----------------------------------------------------------------------
; NAME:  EnvCount
;
; EXTERNALS:
;     word        PrefixSeg   (System)
; REGISTER USAGE:   AX,BX,DI,ES		-- Destroyed
;-----------------------------------------------------------------------
PUBLIC	EnvCount
PROC	EnvCount	FAR
	cld			; forward string op
	xor	ax,ax		; clear AX
	mov	bx,ax		; clear BX
	mov	di,ax		; clear DI
	mov	es,[PrefixSeg]
	mov	es,[es:(PSPtype PTR di).EnvironmentSeg]
@@EnvEndChk:
	scasb			; is es:di=0 ?
	jz	@@Done
	inc	bx
@@More:	scasb			; look for end of environment
	jnz	@@More		;    string.
	jmp	@@EnvEndChk
@@Done:	mov	ax,bx
	ret
ENDP

;-----------------------------------------------------------------------
; NAME:  EnvStr
;
; EXTERNALS:
;     word        PrefixSeg   (System)
; REGISTER USAGE:   AX,CX,DI,ES		-- Destroyed
;-----------------------------------------------------------------------
PUBLIC	EnvStr
PROC	EnvStr	FAR
	ARG	Index:Word	RETURNS	Result:DWORD
	USES	ds
	cld			; forward string op
	xor	ax,ax		; clear AX
	mov	si,ax		; clear SI
	les	di,[Result]
	stosb			; set result length to 0
	mov	cx,[Index]	; get index
	jcxz	@@Done
	mov	ds,[PrefixSeg]
	mov	ds,[ds:(PSPtype PTR si).EnvironmentSeg]
@@EnvEndChk:
	test	[BYTE PTR si],0ffh
	jz	@@Done
	dec	cx
	jcxz	@@Found
@@More:	lodsb			; look for end of environment
	or	ax,ax		; string
	jnz	@@More		;
	jmp	@@EnvEndChk
@@Found:movsb
	inc	cx
	test	[BYTE PTR si],0ffh
	jnz	@@Found
	les	di,[Result]
	mov	[es:di],cl	; set length
@@Done:	ret
ENDP

END
