program DemoMyMousePackage;

{ Demonstrates the MyMouse software package.
}

{$A+,B-,F-,G+,O-,R-,S-,X+}

uses
  Crt, Dos, Gr, Graph, Bgi, Objects, Drivers, Memory,
  MyMouse, Misc, MyFonts, VGAMem

{$IFDEF exe}
, BgiDriv, BgiFont
{$ENDIF}
;

(***************************************************************************)

procedure InitGr;
var
  d, m: Integer;
Begin
{$IFDEF Exe}
  RegisterBgiDriver(@EgaVgaDriverProc);
  RegisterBgiFont(@SmallFontProc);
  RegisterBgiFont(@SansSerifFontProc);
  RegisterBgiFont(@TriplexFontProc);
  RegisterBgiFont(@GothicFontProc);
{$ENDIF}
  SetGrMode(grVgaHiStd);
  UserParams(0);
  If not InitGraphProc then Begin
    PrintStr(
      'Error: Graphics cannot be initialized. This demonstration'^m^j +
      'requires a standard VGA adapter. Maybe you will just have to'^m^j +
      'change the path to the BGI graphics device driver.'^m^j^m^j);
    Halt(1)
  End;
End;

procedure Out(X, Y: Integer; TextString: string);
Begin
  Graph.OutTextXY(X, Y, TextString)
End;

var
  Event: TEvent;
  R: Word;

procedure W;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
  until keypressed or (Event.What=evMouseDown);
  If keypressed then Readkey;
  HideMouse;
End;

(****************************** M Y M O U S E ******************************)

const
  mcInput = 50;
  mcHuge  = 51;

var
  SaveGetCursor: TGetMCProc;

procedure DoGetCursor(n: Integer); far; assembler;
Asm
	MOV	AX, n
	CMP	AX, mcInput
	MOV	SI, OFFSET @D50
	JZ	@@3
	CMP	AX, mcHuge
	MOV	SI, OFFSET @D51
	JNZ	@@1
@@3:	MOV	CursorNum, AX
	MOV	WORD PTR CursorPtr, SI
	MOV	WORD PTR CursorPtr+2, CS
	JMP	@@2
@D50:	DW	17, 2			{ Windows cursor "Text" }
	DW	3, 8
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1110111000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	1110111000000000B
@D51:	DW	64, 8			{ 64x64 demo cursor }
	DW	32, 31

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	1111111111111111B
	DW	1000000000000000B
	DW	1000111000000000B
	DW	1001000100000000B
	DW	1010000001000101B
	DW	1010000001000101B
	DW	1010000001000101B
	DW	1010000001000101B
	DW	1001000101001101B
	DW	1000111000110101B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1010000000000000B
	DW	1010000000000000B
	DW	1010110001110001B
	DW	1011001010001010B
	DW	1010001011111010B
	DW	1010001010000010B
	DW	1011001010001010B
	DW	1010110001110001B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1010001001110010B
	DW	1010001010001011B
	DW	1001010011111010B
	DW	1001010010000010B
	DW	1000100010001010B
	DW	1000100001110010B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1011111111111111B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000001B
	DW	1000000000000010B
	DW	1000000000000100B
	DW	1000000000001000B
	DW	1000000000010000B
	DW	1000000000100000B
	DW	1000000001000000B
	DW	1000000010000000B
	DW	1000000100000000B
	DW	1000001000000000B
	DW	1000010000000000B
	DW	1000100000000000B
	DW	1001000000000000B
	DW	1010000000000000B
	DW	1100000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW      0100111000111001B
	DW	1001000101000101B
	DW	0000110001000101B
	DW	0000001001000101B
	DW	0001000101000101B
	DW	0000111000111001B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1100011100101001B
	DW	0010100010110110B
	DW	0000100010100100B
	DW	0000100010100100B
	DW	0010100010100100B
	DW	1100011100100100B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1010001000000000B
	DW	0010001000000000B
	DW	0001010000000000B
	DW	0001010000000000B
	DW	0000100000000000B
	DW	0000100000011111B
	DW	0000100000001111B
	DW	0001000000000111B
	DW	1111111100001011B
	DW	0000000000010001B
	DW	0000000000100000B
	DW	0000000001000000B
	DW	0000000010000000B
	DW	0000000100000000B
	DW	0000001000000000B
	DW	0000010000000000B
	DW	0000100000000000B
	DW	0001000000000000B
	DW	0010000000000000B
	DW	0100000000000000B
	DW	1000000000000000B
	DW	0000000000000000B
	DW	0001100000000111B
	DW	0001100000000111B
	DW	0001100000001101B
	DW	0001100000001101B
	DW	0001100000001101B
	DW	0001100000011000B
	DW	0001100000011000B
	DW	0001100000011111B
	DW	0001100000110000B
	DW	0001111110110000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0100111000000111B
	DW	1001000100001000B
	DW	0000110000001000B
	DW	0000001000001000B
	DW	0001000100001000B
	DW	0000111000000111B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0001110000000001B
	DW	1010001000000010B
	DW	1011111000000100B
	DW	1010000000001000B
	DW	1010001000010000B
	DW	1001110000100000B
	DW	0000000001000000B
	DW	0000000010000000B
	DW	0000000100000000B
	DW	0000001000000000B
	DW	0100010000000000B
	DW	0110100000000000B
	DW	0111000000000000B
	DW	0111100000000000B
	DW	0111110000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000111111000001B
	DW	0000110001100011B
	DW	1000110001100110B
	DW	1000110001100110B
	DW	1000110001100110B
	DW	1100111111000110B
	DW	1100110011000110B
	DW	1100110011100110B
	DW	0110110001100011B
	DW	0110110001110001B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0001110010110001B
	DW	1010001011001001B
	DW	0001111010001001B
	DW	0010001010001001B
	DW	1010011010001001B
	DW	0001101010001001B
	DW	0000000000000001B
	DW	0000100000000001B
	DW	0001000000000001B
	DW	0010000000000001B
	DW	0100000000000001B
	DW	1000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	1111000111111001B
	DW	0001100110000001B
	DW	0000000110000001B
	DW	0000000110000001B
	DW	0000000111111001B
	DW	0111100110000001B
	DW	0001100110000001B
	DW	0001100110000001B
	DW	0001100110000001B
	DW	1111000111111001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	1111111111111111B


@@1:    PUSH	AX
	CALL	SaveGetCursor
@@2:
End;

{***** Adaption to elements *****}

var
  SaveCC: procedure;

procedure DoCC; far;
const
  R1: TRect = (A: (x: 160; y: 120); B: (x: 260; y: 220));
  R2: TRect = (A: (x: 290; y: 120); B: (x: 470; y: 140));
  R3: TRect = (A: (x: 141; y:  80); B: (x: 499; y: 100));
Begin
  If R1.Contains(MouseWhere) then NewNum := mcLargeCross else
  if R2.Contains(MouseWhere) then NewNum := mcInput else
  if R3.Contains(MouseWhere) then NewNum := mcCross else
  NewNum := mcStd
End;

{***** Expensive graphics *****}

procedure FillUp;
Begin
  Repeat
    SetColor(Random(16));
    HideMouse;
    Line(Random(100)+10, Random(100)+100, Random(100)+10, Random(100)+100);
    ShowMouse;
    GetMouseEvent(Event);
  Until (Event.What=evMouseDown) or keypressed;
  SetColor(15);
  If keypressed then ReadKey
End;

procedure BeginMyMouse;
Begin
  SetFillStyle(SolidFill, Blue);
  Bar(0, 0, 639, 185);
  Graph.SetTextJustify(CenterText, TopText);
  SetTextStyle(TriplexFont, 0, 6);
  Out(320, 0, 'The MyMouse Package');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'A Demonstration Program');
  Out(320, 140, 'Part I: MyMouse, Version 1.5');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 200, 'Certainly, you will know THIS mouse cursor.'); W;
  Out(320, 230, 'Often it is useful to have a different cursor shape.');
  Out(320, 250, 'That is no problem - you must do some interrupt calls.');
  Out(320, 280, 'On the one hand, this is a bit complicated.');
  Out(320, 300, 'Above all, you will soon meet the limits of conventional');
  Out(320, 320, 'mouse drivers.  They only support cursors up to 16 x 16');
  Out(320, 340, 'pixels -- and that is not at all enough for attractive');
  Out(320, 360, 'cursor shapes.'); W;
  SetTextStyle(TriplexFont, 0, 4);
  SetColor(12);
  Out(320, 410, 'But now you have MyMouse...'); W;
End;

procedure DemoMyMouse;
var
  i: Byte;
Begin
  Bar(0, 0, 639, 60);
  SetColor(15);
  Out(320, 10, 'MyMouse, Version 1.5: Cursor Shapes');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 70, 'Here you can see the standard cursor of MyMouse.');
  Out(320, 90, 'You will know this comfortable size from Windows.');
  Out(320, 110, 'Now you can have it in a DOS application.'); W;
  Out(320, 140, 'More cursor shapes are integrated into MyMouse. For');
  Out(320, 160, 'instance, the well-known hourglass.');
  SetMCursor(mcHourGlass); W;
  Out(320, 190, 'Besides the hard-coded cursor shapes, it is especially');
  Out(320, 210, 'simple to define your own cursor shapes in MyMouse.');
  Out(320, 230, 'Have a look at this cursor for text marking!');
  SetMCursor(mcInput); W;
  Out(320, 250, 'Maybe you will know it from somewhere.');
  SetMCursor(mcInput); W;
  Out(320, 280, 'With MyMouse, mouse cursors can become nearly as large');
  Out(320, 300, 'as you want. But, please, don''t exaggerate it...');
  SetMCursor(mcHuge); W;
  Out(320, 330, 'Further, the cursor can get any color you want.');
  SetMCursor(mcStd); ShowMouse;
  For i := 1 to 15 do Begin
    SetPointerColor(i);
    Delay(200);
  End; W;
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 370, 'But this is not all:');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 440, 'MyMouse, version 1.5, also provides the automatical cursor');
  Out(320, 460, 'adaption to graphical user interface elements...'); W;
  ClearDevice;
  Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 10, 'MyMouse: Automatical Cursor Adaption');
  SetTextStyle(SmallFont, 0, 6);
  SetFillStyle(SolidFill, Blue); Bar(135, 75, 504, 244);
  SetFillStyle(SolidFill, White); Bar(140, 79, 499, 239);
  SetFillStyle(SolidFill, Blue); Bar(141, 80, 498, 99);
  SetFillStyle(SolidFill, DarkGray); Bar(160, 120, 259, 219);
  SetColor(Black); Rectangle(290, 120, 469, 140);
  SaveCC:=ChangeCursor; ChangeCursor:=DoCC;
  SetColor(White);
  Out(320, 260, 'Please move the mouse cursor over the shown regions...'); W;
  Out(320, 290, 'This adaption is done by MyMouse automatically. It does');
  Out(320, 310, 'not burden the programmer in any way. You just have to');
  Out(320, 330, 'write a small procedure that may be called by MyMouse in');
  Out(320, 350, 'the background.'); W;
  ChangeCursor:=SaveCC; SetMCursor(mcStd);
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 380, 'Besides,');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 440, 'MyMouse, version 1.5, provides efficient routines');
  Out(320, 460, 'for screen region and page control...'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 10, 'MyMouse: Screen Regions');
  SetTextStyle(SmallFont, 0, 6);
  Out(370, 70, 'In MyMouse, you can lock the mouse into a box...');
  Rectangle(10, 100, 109, 199); SetMouseArea(10, 100, 110, 200); W;
  SetMouseArea(0, 0, 640, 480);
  Out(370, 100, 'Before any graphical operation, you normally must');
  Out(370, 120, 'hide the mouse so that no side effects will ');
  Out(370, 140, 'happen that destroy the screen mask.');
  Out(370, 160, 'If graphics is extensively done, this hide-and-show');
  Out(370, 180, 'will result in a dreadful flickering ...');
  ShowMouse; FillUp; HideMouse;
  Out(320, 210, 'MyMouse, version 1.5, provides an elegant solution');
  Out(320, 230, 'for that: the critical area -- this is the region');
  Out(320, 250, 'that is actually modified. With it, it looks MUCH');
  Out(320, 270, 'better doesn''t it...');
  SetCriticalArea(10, 100, 110, 200);
  ShowMouse; FillUp; HideMouse;
  SetCriticalArea(0, 0, 640, 480);
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 300, 'More Features');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 350, 'Drivers-compatible event support');
  Out(320, 370, 'Timer event support');
  Out(320, 390, 'SuperVGA adaptor card support');
  Out(320, 410, '256-color mode support');
  Out(320, 430, 'Co-operation with all mouse types');
  Out(320, 450, 'BGI compatibility'); W;
End;

(****************************** M Y F O N T S ******************************)

const
  ftBios8       =  0;
  ftBios14      =  1;
  ftBios16      =  2;
  ftWinSys      =  3;
  ftSSerif      =  4;
  ftSSerifBold  =  5;
  ftSSerif24    =  6;
  ftBgi         =  7;
  ftBgiBold     =  8;
  ftCPI852      =  9;
  ftWinScal     = 10;
  ftWinScalBold = 11;

procedure InitFonts;
var
  WinDir, WinSysDir: DirStr;
  Font: PFontRec;

 function SysFont: PathStr;
 var
   F: PStream;
   s: PathStr;
 Begin
   F:=New(PBufStream, Init(WinDir+'SYSTEM.INI', stOpenRead, 1024));
   s:=ReadValue(F^, 'BOOT', 'FONTS.FON');
   Dispose(F, Done);
   SysFont:=FirstFile(s+';VGASYS.FON;?GASYS.FON', WinSysDir);
 End;

 procedure Define(Font: PFontRec);
 Begin
   If Font = nil
     then DefFont(FullAliasOf(ftBios16))
     else DefFont(Font)
 End;

Begin
  MaxBufMem := 131072 div 16;	{ larger buffer for many fonts }
  InitMemory; InitMyFonts;
  WinDir := GetWinDir;
  WinSysDir := WinDir+'SYSTEM\';

  DefFont(LoadBIOSFont( 8, 0, 0, 0));
  DefFont(LoadBIOSFont(14, 0, 0, 0));
  DefFont(LoadBIOSFont(16, 0, 0, 0));

  Define(LoadWinFont(SysFont, 1, 0, 0, 0, 0, 0, 0));
  Define(LoadWinFont(
    FirstFile('SSERIFE.FON;HELVE.FON;SSERIF?.FON;HELV?.FON', WinSysDir),
    0, 12, 0, 0, 0, 0, 0));
  DefFont(AliasOf(ftSSerif, 1, 0, 0, ftBold));
  Define(LoadWinFont(
    FirstFile('SSERIFE.FON;HELVE.FON;SSERIF?.FON;HELV?.FON', WinSysDir),
    0, 24, 0, 0, 0, 0, 0));
  Define(LoadBgiFileFont(
{$IFDEF exe}
    FixedAddr(@TriplexFontProc),
{$ELSE}
    PathToDriver+'\TRIP.CHR',
{$ENDIF}
    0, 1, 1, 1, 1, 0, 0, 0, ftNormal + ftNoDescent));
  Define(AliasOf(ftBgi, 2, 0, 0, ftBold));
  Define(LoadCpiFont('C:\DOS\EGA.CPI', 852, 16, 0, 0, 0));
  Define(LoadWinFont(
    FirstFile('SCRIPT.FON;ROMAN.FON', WinSysDir),
    1, 35, 0, 0, 0, 0, ftNormal));
  Define(AliasOf(ftWinScal, 0, 0, 0, ftBold));
End;

procedure BeginMyFonts;
Begin
  ClearDevice;
  Bar(0, 0, 639, 185); SetColor(White);
  SetTextStyle(TriplexFont, 0, 6);
  Out(320, 0, 'The MyMouse Package');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'A Demonstration Program');
  Out(320, 140, 'Part II: MyFonts, Version 1.5');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 200, 'On the one hand, BGI''s Graph unit');
  SetTextStyle(GothicFont, 0, 4);
  Out(320, 240, 'gives you nice scalable Fonts.');
  SetTextStyle(SansSerifFont, 0, 1);
  Out(320, 280, 'But if smallened to normal text size, they look ugly.');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 310, 'SmallFont looks somehow primitive,');
  SetTextStyle(DefaultFont, 0, 1);
  Out(320, 340, 'and DefaultFont can hardly be read.'); W;
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 370, 'Even the text mode fonts look then better. But how');
  Out(320, 390, 'to use them in graphics mode?');
  Out(320, 410, 'And then there are the Windows fonts. They are really');
  Out(320, 430, 'excellent but there is no chance to get to them.'); W;
  Out(320, 460, 'Let''s see...'); W;
End;

procedure DemoMyFonts;
var
  cx, cy: Integer;

 procedure MOut(s: string);
 Begin
   OutTextXY(cx, cy, s);
   Inc(cy, TextHeight('') + 5);
 End;

 procedure DoLine;
 Begin
   Line(0, cy+2, 639, cy+2);
   Inc(cy, 11);
 End;

Begin
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 50);
  Graph.SetTextJustify(CenterText, TopText);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 5, 'MyFonts: Font Types');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftBIOS8, 0, 15, false);
  cx := 320; cy := 47;
  DoLine;
  MOut('MyFonts, version 1.5, uses all the installed');
  SetTextParams(ftBIOS14, 0, 15, false);
  MOut('BIOS fonts in different sizes. These are');
  SetTextParams(ftBIOS16, 0, 15, false);
  MOut('8 x 8 pixels, 8 x 14 pixels, and 8 x 16 pixels.');
  DoLine; W;
  SetTextParams(ftCPI852, 0, 15, false);
  MOut('Furthermore, MyFonts can utilize the codepage-specific MS-DOS');
  If PFontRec(FontCollection^.At(ftCpi852))^.CodePage = 437
  then MOut('fonts. Unfortunately, there aren''t any in your system.')
  else MOut('fonts: h   ב .');
  DoLine; W;
  SetTextParams(ftWinSys, 0, 15, false);
  MOut('MyFonts, version 1.5, can also use Windows');
  SetTextParams(ftSSerif, 0, 15, false);
  MOut('bitmap fonts if they are existing in your system.');
  SetTextParams(ftSSerifBold, 0, 15, false);
  MOut('It can sythesize bold font variants if you want.');
  SetTextParams(ftSSerif24, 0, 15, false);
  If PFontRec(FontCollection^.At(ftWinSys))^.FontMode = ftCpi
  then MOut('Unfortunately, they''re not present in your system.')
  else Begin
    Dec(cy, 2);
    MOut('That nice are Windows fonts!');
    Dec(cy, 4)
  End;
  DoLine; W;
  SetTextParams(ftWinScal, 0, 15, false);
  MOut('MyFonts can also use scalable Windows fonts');
  SetTextParams(ftWinScalBold, 1, 15, false); Dec(cy, 2);
  MOut('and synthesize a bold font version.'); Dec(cy, 2);
  DoLine; W;
  SetTextParams(ftBgi, 0, 15, false);
  MOut('MyFonts utilizes BGI fonts directly'); Inc(cy, 7);
  SetTextParams(ftBgiBold, 0, 15, false);
  MOut('and can synthesize a bold version.'); Inc(cy, 7);
  DoLine; W;
  SetTextParams(ftWinSys, 1, 12, false);
  SetTextJustify(RightText, BottomText);
  OutTextXY(639, 479, 'Moreover, MyFonts provides some special effects...'); W;

  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'MyFonts: Output Variations');
  SetTextParams(ftWinSys, 4, 15, false);
  SetTextJustify(CenterText, TopText);
  OutTextXY(320, 80, 'By character space modifications, text');
  OutTextXY(320, 100, 'may be set spaced (nice, isn''t it?).');
  SetTextParams(ftWinSys, -1, 15, false);
  OutTextXY(320, 130, 'In the same way, text may be compressed.');
  SetTextParams(ftWinSys, -20, 15, false);
  OutTextXY(320, 160, 'This exaggerated use is not very sensible.'); W;
  SetTextParams(ftWinSys, 1, $0C0F, true);
  OutTextXY(320, 200, 'MyFonts supports ~marking characters~ that');
  OutTextXY(320, 220, 'surround the words to be highlighted.'); W;
  SetTextParams(ftWinSys, 1, 15, false);
  SetTextJustify(LeftText, TopText);    OutTextXY(  0, 260, 'Left-aligned');
  SetTextJustify(CenterText, TopText);  OutTextXY(320, 260, 'Centered');
  SetTextJustify(RightText, TopText);   OutTextXY(639, 260, 'Right-aligned');
  SetColor(4); Line(0, 300, 639, 300);
  SetTextJustify(LeftText, BottomText); OutTextXY(  0, 300, 'Upwards');
  SetTextJustify(LeftText, BaseLine);   OutTextXY(128, 300, 'Base line');
  SetTextJustify(LeftText, CenterText); OutTextXY(256, 300, 'Centered');
  SetTextJustify(LeftText, LeadLine);   OutTextXY(384, 300, 'Leading line');
  SetTextJustify(RightText, TopText);   OutTextXY(639, 300, 'Downwards'); W;
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 1, 15, false);
  OutTextXY(320, 340, 'You''ll work with MyFonts as you did before with Graph:');
  OutTextXY(320, 360, 'MyFonts implements the OutTextXY, SetTextJustify,');
  OutTextXY(320, 380, 'TextWidth, and TextHeight routines.');
  OutTextXY(320, 410, 'Only SetTextStyle is replaced by SetTextParams, so');
  OutTextXY(320, 430, 'that you can use extended possibilities.'); W;
  SetTextJustify(RightText, BottomText); SetTextParams(ftWinSys, 1, 12, false);
  OutTextXY(639, 479, 'MyFonts also provides clipping at any rectangle...'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'MyFonts: Clipping and Management');
  SetFillStyle(SolidFill, DarkGray); Bar(20, 80, 239, 219);
  SetTextJustify(LeftText, TopText); SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(260, 80, 'This rectangle is the so-called ~ClipRect~,');
  OutTextXY(260, 100, 'i.e. the region in which text output may');
  OutTextXY(260, 120, 'take place.');
  OutTextXY(260, 150, 'Try it out: Click somewhere on the screen or');
  OutTextXY(260, 170, 'draw the mouse.');
  OutTextXY(260, 200, '(Stop by key press)');
  SetClipRect(20, 80, 240, 220);
  SetMCursor(mcCross); ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      SetTextParams(ftWinSys, 0, Random(16), false);
      OutTextXY(Event.Where.x, Event.Where.y, 'Example text for clipping');
      ShowMouse
    End
  Until keypressed;
  HideMouse; SetMCursor(mcStd); Readkey;
  SetClipRect(0, 0, 640, 480);
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320, 230, 'Clipping is done automatically. Independently from ~ClipRect~, the');
  OutTextXY(320, 250, 'origin of the coordinates may be specified. This facility is called');
  OutTextXY(320, 270, '~DrawOrigin~. Seperating these things is very advantageous in many');
  OutTextXY(320, 290, 'applications (in contrast to Graph''s ViewPort).'); W;
  SetColor(15); Line(0, 320, 639, 320);
  OutTextXY(320, 330, 'Font management is very efficient and elegant: Fonts are registered at');
  OutTextXY(320, 350, 'program start-up and then accessed by identifiers.');
  OutTextXY(320, 370, 'So, you can easily exchange the fonts - without program modification.');
  OutTextXY(320, 400, 'MyFonts provides an ~intelligent memory management~ for maximal speed');
  OutTextXY(320, 420, 'without wasting memory.');
  OutTextXY(320, 450, 'Moreover, MyFonts provides Windows-compatible ~font metrics~ for all fonts.'); W;
End;

(****************************** V G A M E M ********************************)

procedure DoRestScr;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      RestoreScreen16(200, 50, 400, 150, Event.Where.x, Event.Where.y, R);
      ShowMouse
    End
  until keypressed; Readkey;
  HideMouse
End;

procedure DoCopyScr;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      CopyScreen16(420, 5, 630, 200, Event.Where.x, Event.Where.y);
      ShowMouse
    End
  until keypressed; Readkey;
  HideMouse
End;

procedure DrawIcon(x1, y1, n: Integer; Mode: Word); assembler;
{ Low byte of Mode specifies modified memory maps. If high byte is zero,
  the bits are anded, otherwise they are orred.
  So you can achieve color effects.
}
Asm
	MOV	SI, OFFSET @D1
	MOV	AX, n
	OR	AL, AL
	JZ 	@@1
@@2:	MOV	CX, [CS:SI]
	SHL	CX, 1
	JZ	@@3
	ADD	SI, CX
	ADD	SI, 2
	DEC	AL
	JNZ	@@2
@@1:    PUSH	x1
	PUSH	y1
	PUSH	Mode
	PUSH	CS
	PUSH	SI
	CMP	BYTE PTR Mode+1, 0
	JNZ	@@4
	CALL	PutIconAnd
	JMP	@@3
@@4:	CALL	PutIconOr
	JMP	@@3
@D1:	DW	13			{ 0 CheckBox off }
	DW	1111111111111000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1111111111111000B
	DW	13			{ 1 CheckBox on }
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1010000000101000B
	DW	1001000001001000B
	DW	1000100010001000B
	DW	1000010100001000B
	DW	1000001000001000B
	DW	1000010100001000B
	DW	1000100010001000B
	DW	1001000001001000B
	DW	1010000000101000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	13			{ 2 RadioButton off }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	13			{ 3 RadioButton on }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100011100010000B
	DW	0100111110010000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	0100111110010000B
	DW	0100011100010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	11			{ 4 Zoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	15			{ 5 UnZoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 6 Symbol }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 7 Scroll Arrow Right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111100000B
	DW	0000000011000000B
	DW	0000000010000000B
	DW	12			{ 8 Scroll Arrow Left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000110000000B
	DW	0000001111110000B
	DW	0000011111110000B
	DW	0000001111110000B
	DW	0000000110000000B
	DW	0000000010000000B
	DW	12			{ 9 Scroll Arrow Up }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	12			{ 10 Scroll Arrow Down }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	13			{ 11 Scroll Arrow Right Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111111000B
	DW	0000001111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	13			{ 12 Scroll Arrow Left Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111110000B
	DW	0000011111111000B
	DW	0000001111111000B
	DW	0000000111111000B
	DW	0000000011000000B
	DW	0000000001000000B
	DW	13			{ 13 Scroll Arrow Up Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000011111011000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000000011100000B
	DW	13			{ 14 Scroll Arrow Down Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000011111110000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	14			{ 15 Open List Button }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	0000000000000000B
	DW	0000011111110000B
	DW	9			{ 16 Submenu Arrow }
	DW	1000000000000000B
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1100000000000000B
	DW	1000000000000000B
	DW	13			{ 17 held CheckBox off }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 18 held CheckBox on }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1110000000111000B
	DW	1101000001011000B
	DW	1100100010011000B
	DW	1100010100011000B
	DW	1100001000011000B
	DW	1100010100011000B
	DW	1100100010011000B
	DW	1101000001011000B
	DW	1110000000111000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 19 held RadioButton off }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111000001110000B
	DW	0110000000110000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	0110000000110000B
	DW	0111000001110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	13			{ 20 held RadioButton on }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111011101110000B
	DW	0110111110110000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	0110111110110000B
	DW	0111011101110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	12			{ 21 small CheckBox off }
	DW	0000000000000000B
	DW	0111111111110000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0111111111110000B
	DW	12			{ 22 small CheckBox on }
	DW	0000000000000000B
	DW	0111111111110000B
	DW	0110000000110000B
	DW	0101000001010000B
	DW	0100100010010000B
	DW	0100010100010000B
	DW	0100001000010000B
	DW	0100010100010000B
	DW	0100100010010000B
	DW	0101000001010000B
	DW	0110000000110000B
	DW	0111111111110000B
	DW	0			{ end }
@@3:
End;

procedure DrawColIcon(x1, y1, n: Integer; Color: Byte);
{ Draws an icon of a certain color. }
Begin
  DrawIcon(x1, y1, n, $0F);
  DrawIcon(x1, y1, n, $100+Color);
End;

procedure DrawIcons;
{ Icons with some graphical background in GUI look }
var
  x, y, dx, dy, n:Integer;
Begin
  UserParams(1); ClipNotifyProc(gcnHaltUpd);
  Repeat
    x:=Random(GetMaxX+1); y:=Random(GetMaxY+1); n:=Random(23);
    case n of
      4..6: Begin dx:=20; dy:=20 End;
      7..14: Begin dx:=17; dy:=17 End;
      15: Begin dx:=17; dy:=20 End;
      else Begin dx:=0; dy:=0 End
    End;
    If dx <> 0 then Begin
      SetCriticalArea(x, y, x+dx, y+dy);
      SetFillStyle(SolidFill, 7); Bar(x, y, x+dx-1, y+dy-1);
      SetColor(0); Rectangle(x, y, x+dx-1, y+dy-1);
      SetColor(8); Line(x+2, y+dy-3, x+dx-2, y+dy-3);
      Line(x+1, y+dy-2, x+dx-2, y+dy-2);
      Line(x+dx-3, y+2, x+dx-3, y+dy-4); Line(x+dx-2, y+1, x+dx-2, y+dy-4);
      SetColor(15); Line(x+1, y+1, x+dx-3, y+1); Line(x+1, y+2, x+1, y+dy-3)
    End else Begin
      SetCriticalArea(x-1, y-1, x+13, y+13);
      SetFillStyle(SolidFill, White);
      Bar(x-1, y-1, x+13, y+13)
    End;
    If (n<4) or (n>=16) then DrawColIcon(x, y, n, Random(16)) else
      if (n<11) or (n>14) then DrawIcon(x, y, n, $0F) else begin
	DrawIcon(x, y, n, $10F); DrawIcon(x, y, n-4, $07) end;
    GetMouseEvent(Event);
  Until keypressed or (Event.What=evMouseDown);
  If keypressed then Readkey
End;

procedure DemoVgaMem;
Begin
  ClearDevice; SetFillStyle(SolidFill, Blue);
  Bar(0, 0, 639, 185); SetColor(White);
  SetTextStyle(TriplexFont, 0, 6); Graph.SetTextJustify(CenterText, TopText);
  Out(320, 0, 'The MyMouse Package');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'A Demonstration Program');
  Out(320, 140, 'Part III: VgaMem, Version 1.5');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320, 200, 'The VgaMem unit, version 1.5, is the answer to the inefficient');
  OutTextXY(320, 220, 'and defective PutImage/GetImage routines, the waste of VGA rest');
  OutTextXY(320, 240, 'memory and the lack of VGA copying and manipulating routines');
  OutTextXY(320, 260, 'that directly access the VGA adapter.'); W;
  OutTextXY(320, 290, 'The VgaMem unit makes use of all the adapter''s possibilities and');
  OutTextXY(320, 310, 'therefore provides ~maximal performance~ when executing its');
  OutTextXY(320, 330, 'routines, which are completely written in assembler.');
  OutTextXY(320, 360, 'Though VgaMem directly accesses VGA''s registers and memory, it');
  OutTextXY(320, 380, 'is absolutely compatible with Borland Graphics Interface - and,');
  OutTextXY(320, 400, 'of course, also with MyMouse and MyFonts.'); W;
  SetTextJustify(RightText, BottomText);
  OutTextXY(639, 479, '~VgaMem''s Rest Memory Management...~'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'VgaMem: Rest Memory Management');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320,  80, 'On your VGA adapter, normally large memory blocks remain unused. In');
  OutTextXY(320, 100, 'the standard mode (640 x 480 pixels), these are about ~106 KB~,');
  OutTextXY(320, 120, 'therefore an enormously important resource.');
  OutTextXY(320, 150, 'With VgaMem, version 1.5, this rest memory can efficiently be used.');
  OutTextXY(320, 170, 'It provides a modern dynamical ~memory management~ and very fast');
  OutTextXY(320, 190, 'copying routines between the visible screen and the rest memory');
  OutTextXY(320, 210, 'of your adapter.'); W;
  InitVGAMan;
  SetColor(10); Rectangle(200, 50, 399, 149);
  R:=GetVGAMem(GetSize16(200, 50, 400, 150));
  SaveScreen16(200, 50, 400, 150, R);
  OutTextXY(320, 240, 'This rectangle has just been copied into the rest memory.'); W;
  OutTextXY(320, 270, 'Now click or draw the mouse. The rectangle is then restored');
  OutTextXY(320, 290, 'from the rest memory. (Stop by key press.)');
  SetMCursor(mcCross); DoRestScr;
  ClearDevice; Bar(0, 0, 639, 60); SetColor(White);
  Out(320, 10, 'VgaMem: Copying Methods');
  Rectangle(50, 80, 399, 299);
  SetTextJustify(LeftText, TopText);
  OutTextXY(440,  80, 'VgaMem also supports');
  OutTextXY(440, 100, 'the ~ClipRect~. The');
  OutTextXY(440, 120, 'restored rectangle');
  OutTextXY(440, 140, 'is then clipped at');
  OutTextXY(440, 160, 'the bounds of this');
  OutTextXY(440, 180, 'rectangle.');
  SetClipRect(50, 80, 400, 300); DoRestScr;
  SetClipRect(0, 0, 640, 480); SetTextJustify(CenterText, TopText);
  SetFillStyle(SolidFill, 0); Bar(50, 80, 399, 299);
  SetColor(15); Rectangle(50, 80, 399, 299);
  SetMCursor(mcStd);
  OutTextXY(320, 340, 'Besides the rest memory use, VgaMem provides ');
  OutTextXY(320, 360, 'direct screen copying routines, too. Any part');
  OutTextXY(320, 380, 'of the screen can be copied - and the ~ClipRect~');
  OutTextXY(320, 400, 'can also be used here.'); W;
  SetColor(10); Rectangle(420, 5, 629, 199);
  OutTextXY(320, 430, 'This rectangle will be copied... (Stop by key press.)');
  SetClipRect(50, 80, 400, 300); SetMCursor(mcCross); DoCopyScr;
  SetMCursor(mcStd); SetClipRect(0, 0, 640, 480);
  ClearDevice; SetFillStyle(SolidFill, 1); Bar(0, 0, 639, 60); SetColor(White);
  Out(320, 10, 'VgaMem: Drawing Icons');
  SetFillStyle(SolidFill, 15); Bar(50, 80, 589, 299);
  OutTextXY(320, 320, 'VgaMem provides procedures that can draw small ~icons~ on');
  OutTextXY(320, 340, 'the screen. This example shows the icons of some graphical');
  OutTextXY(320, 360, 'user interfaces. The ~ClipRect~ may be used for clipping');
  OutTextXY(320, 380, 'icon output.');
  SetClipRect(50, 80, 590, 300); DrawIcons;
  SetClipRect(0, 0, 640, 480);
  SetCriticalArea(0, 0, 640, 480);
  SetColor(15); Line(20, 405, 620, 405);
  OutTextXY(320, 415, 'Besides, VgaMem replaces BGI''s image routines. So, images are');
  OutTextXY(320, 435, 'correctly clipped at the bounds of the ClipRect.'); W;
  DoneVGAMan;
End;

(***************************************************************************)

Begin
  If not MouseInstalled then Begin
    PrintStr(
      'This demonstration program for the MyMouse software package'^m^j+
      'requires a mouse driver installed.'^m^j^m^j);
    Halt(1)
  End;
  InitGr;
  InitEvents; HideMouse;
  BeginMyMouse;
  MaxWidth := 8; MaxLength := 64;
  ClearDevice; InitMyMouse; HideMouse;
  SaveGetCursor:=GetMCursor; GetMCursor:=DoGetCursor;
  DemoMyMouse;
  BeginMyFonts;
  InitFonts;
  DemoMyFonts;
  DemoVgaMem;
  DoneMyFonts; DoneMemory; DoneMyMouse; DoneEvents;
  UserParams(0); CloseGraphProc;
  PrintStr(
    'This was the demonstration of the MyMouse Software Package. We want to thank'^m^j +
    'you for your attention. If you are interested in the software, please read the'^m^j +
    'registration information.'^m^j^m^j);
End.

