%title "VIDL86P - Pascal interface for VIDL86 routine library"
%pagesize 78,132

;title		: VIDL86P
;version	: 1.0
;date		: Dec 15,1995 
;author		: J R Ferguson
;language	: Intel 8068/8088 assembler
;O.S.		: MS-DOS v3.2
;assembler	: Borland Turbo Assembler v3.2, Ideal mode
;interface to	: Borland Pascal v7.0
;memory model	: TPASCAL (simplified segment directives)
;function	: parameter-passing conventions interface
;usage		: link into Turbo Pascal program or unit, together with
;		  VIDL86
;
;This module is a Turbo Pascal interface to the routine library VIDL86.
;Its task is to translate the Pascal parameter-passing conventions into
;the register parameter-passing conventions used in VIDL86.
;
;
;The Turbo Pascal program or unit must have the following declarations:
;
;1. Include directives to link in both VIDL86.OBJ and VIDL86P.OBJ.
;
;   {$IVIDL86}
;   {$IVIDL86P}
;
;2. External references to the procedures and functions defined in this
;   module, defined under the far call compiler option.
;
;   {$F+}
;   procedure VidInit;						external;
;   procedure VidSnow(snowcheck: boolean);			external;
;   function  VidSetPos(row,col: byte):boolean			external;
;   procedure VidGetPos(var row,col: byte);			external;
;   procedure VidSetAttr(attr: byte);				external;
;   function  VidGetAttr: byte;					external;
;   procedure VidDspChr(c: char);				external;
;   procedure VidPutChr(c: char);				external;
;   procedure VidPutChrAttr(c: char; attr: byte);		external;
;   procedure VidChgAttr(attr: byte);				external;
;   procedure VidChgChr(c: char);				external;
;   function  VidRetChr: char;					external;
;   function  VidRetAttr: byte;					external;
;   procedure VidRetChrAttr(var c: char; var attr: byte);	external;
;   procedure VidPutNChr(c: char; n: word);			external;
;   procedure VidPutNChrAttr(c: char; attr: byte; n: word);	external;
;   procedure VidChgNAttr(attr: byte; n: word);			external;
;   procedure VidChgNChr(c: char; n: word);			external;
;   procedure VidPutStz(var s);					external;
;   procedure VidDspStz(var s);					external;
;   procedure VidPutStp(s: string);				external;
;   procedure VidDspStp(s: string);				external;
;   procedure VidClrEol;					external;
;   procedure VidClrEolAttr(attr: byte);			external;
;   procedure VidClrEos;					external;
;   procedure VidClrEosAttr(attr: byte);			external;
;   procedure VidClrScr;					external;
;   procedure VidClrScrAttr(attr: byte);			external;
;   {$F-}
;
;   The {$F+} and {$F-} directives may be omitted when the declarations
;   are part of the interface part of a Turbo Pascal unit, since this
;   implies far calls.
;
;Be sure to execute procedure VidInit before using any other procedure
;or function defined in this library interface.
;
%newpage
		ideal
		model	tpascal
		locals	@@

		codeseg

;
; Routines defined in VIDL86.OBJ
;
extrn	_VidInit		:near
extrn	_VidSnow		:near
extrn	_VidSetPos		:near
extrn	_VidGetPos		:near
extrn	_VidSetAttr		:near
extrn	_VidGetAttr		:near
extrn	_VidDspChr		:near
extrn	_VidPutChr		:near
extrn	_VidPutChrAttr		:near
extrn	_VidChgAttr		:near
extrn	_VidChgChr		:near
extrn	_VidRetChrAttr		:near
extrn	_VidPutNChr		:near
extrn	_VidPutNChrAttr		:near
extrn	_VidChgNAttr		:near
extrn	_VidChgNChr		:near
extrn	_VidDspStz		:near
extrn	_VidPutStz		:near
extrn	_VidDspStp		:near
extrn	_VidPutStp		:near
extrn	_VidClrEol		:near
extrn	_VidClrEolAttr		:near
extrn	_VidClrEos		:near
extrn	_VidClrEosAttr		:near
extrn	_VidClrScr		:near
extrn	_VidClrScrAttr		:near

;
; Routines defined here that can be used in Turbo Pascal.
;
public	VidInit
public	VidSnow
public	VidSetAttr
public	VidGetAttr
public	VidSetPos
public	VidGetPos
public	VidDspChr
public	VidPutChr
public	VidPutChrAttr
public	VidChgAttr
public	VidChgChr
public	VidRetChr
public	VidRetAttr
public	VidRetChrAttr
public	VidPutNChr
public	VidPutNChrAttr
public	VidChgNAttr
public	VidChgNChr
public	VidPutStz
public	VidDspStz
public	VidPutStp
public	VidDspStp
public	VidClrEol
public	VidClrEolAttr
public	VidClrEos
public	VidClrEosAttr
public	VidClrScr
public	VidClrScrAttr

%newpage
;
;procedure VidInit
;
proc		VidInit		far
		call	_VidInit
		ret
endp		VidInit


;
;procedure VidSnow(snowcheck: boolean);
;
proc 		VidSnow		far	snowcheck:byte
		mov	al,[snowcheck]
		call	_VidSnow
		ret
endp		VidSnow


;
;function VidSetPos(row,col: byte): boolean;
;
proc		VidSetPos	far	row:byte, col:byte
		mov	bh,[row]
		mov	bl,[col]
		call	_VidSetPos
		mov	al,1
		jc	@@1
		mov	al,0
@@1:		ret
endp		VidSetPos


;
;procedure VidGetPos(var row,col: byte);
;
proc		VidGetPos	far	row:far ptr byte, col:far ptr byte
		call	_VidGetPos	;bl=row, bh=col
		les	di,[row]	;store row value
		mov	[es:di],bh
		les	di,[col]	;store col value
		mov	[es:di],bl
		ret
endp		VidGetPos


;
;procedure VidSetAttr(attr: byte);
;
proc		VidSetAttr	far	attr:byte
		mov	ah,[attr]
		call	_VidSetAttr
		ret
endp		VidSetAttr


;
;function VidGetAttr: byte;
;
proc		VidGetAttr	far
		call	_VidGetAttr
		mov	al,ah
		ret
endp		VidGetAttr


;
;procedure VidDspChr(c: char);
;
proc		VidDspChr	far	c:byte
		mov	al,[c]
		call	_VidDspChr
		ret
endp		VidDspChr


;
;procedure VidPutChr(c: char);
;
proc		VidPutChr	far	c:byte
		mov	al,[c]
		call	_VidPutChr
		ret
endp		VidPutChr


;
;procedure VidPutChrAttr(c: char; attr: byte);
;
proc		VidPutChrAttr	far	c:byte, attr:byte
		mov	al,[c]
		mov	ah,[attr]
		call	_VidPutChrAttr
		ret
endp		VidPutChrAttr


;
;procedure VidChgAttr(attr: byte);
;
proc		VidChgAttr	far	attr:byte
		mov	ah,[attr]
		call	_VidChgAttr
		ret
endp		VidChgAttr


;
;procedure VidChgChr(c: char);
;
proc		VidChgChr	far	c:byte
		mov	al,[c]
		call	_VidChgChr
		ret
endp		VidChgChr


;
;function VidRetChr: char;
;
proc		VidRetChr	far
		call	_VidRetChrAttr		;al=char, ah=attr
		ret
endp		VidRetChr


;
;function VidRetAttr: byte;
;
proc		VidRetAttr	far
		call	_VidRetChrAttr		;al=char, ah=attr
		mov	al,ah
		ret
endp		VidRetAttr


;
;procedure VidRetChrAttr(var c: char; var attr: byte);
;
proc		VidRetChrAttr	far	c: far ptr byte, attr: far ptr byte
		call	_VidRetChrAttr		;al=char, ah=attr
		les	di,[c]			;store char value
		mov	[es:di],al
		les	di,[attr]		;store attr value
		mov	[es:di],ah
		ret
endp		VidRetChrAttr


;
;procedure VidPutNChr(c: char; n: word);
;
proc		VidPutNChr	far	c:byte, n:word
		mov	al,[c]
		mov	cx,[n]
		call	_VidPutNChr
		ret
endp		VidPutNChr


;
;procedure VidPutNChrAttr(c: char; attr: byte; n: word);
;
proc		VidPutNChrAttr	far	c:byte, attr:byte, n:word
		mov	al,[c]
		mov	ah,[attr]
		mov	cx,[n]
		call	_VidPutNChrAttr
		ret
endp		VidPutNChrAttr


;
;procedure VidChgNAttr(attr: byte; n: word);
;
proc		VidChgNAttr	far	attr:byte, n:word
		mov	ah,[attr]
		mov	cx,[n]
		call	_VidChgNAttr
		ret
endp		VidChgNAttr


;
;procedure VidChgNChr(c: char; n: word);
;
proc		VidChgNChr	far	c:byte, n:word
		mov	al,[c]
		mov	cx,[n]
		call	_VidChgNChr
		ret
endp		VidChgNChr


;
;procedure VidPutStz(var s);
;
proc		VidPutStz	far	s:far ptr byte
		les	di,[s]
		call	_VidPutStz
		ret
endp		VidPutStz


;
;procedure VidDspStz(var s);
;
proc		VidDspStz	far	s:far ptr byte
		les	di,[s]
		call	_VidDspStz
		ret
endp		VidDspStz


;
;procedure VidPutStp(s: string);
;
proc		VidPutStp	far	s:far ptr byte
		les	di,[s]
		call	_VidPutStp
		ret
endp		VidPutStp


;
;procedure VidDspStp(s: string);
;
proc		VidDspStp	far	s:far ptr byte
		les	di,[s]
		call	_VidDspStp
		ret
endp		VidDspStp

;
;procedure VidClrEol;
;
proc		VidClrEol	far
		call	_VidClrEol
		ret
endp		VidClrEol


;
;procedure VidClrEolAttr(attr: byte);
;
proc		VidClrEolAttr	far	attr:byte
		mov	ah,[attr]
		call	_VidClrEolAttr
		ret
endp		VidClrEolAttr


;
;procedure VidClrEos;
;
proc		VidClrEos	far
		call	_VidClrEos
		ret
endp		VidClrEos


;
;procedure VidClrEosAttr(attr: byte);
;
proc		VidClrEosAttr	far	attr:byte
		mov	ah,[attr]
		call	_VidClrEosAttr
		ret
endp		VidClrEosAttr


;
;procedure VidClrScr;
;
proc		VidClrScr	far
		call	_VidClrScr
		ret
endp		VidClrScr


;
;procedure VidClrScrAttr(attr: byte);
;
proc		VidClrScrAttr	far	attr:byte
		mov	ah,[attr]
		call	_VidClrScrAttr
		ret
endp		VidClrScrAttr


		end
