{ NIOLIB.PAS : Numerical I/O library

  Title   : NIOLIB
  Version : 4.0
  Date    : Nov 11,1996
  Language: Borland Turbo Pascal 4.0 through 7.0 (all targets)
  Author  : J.R. Ferguson
  Usage   : unit
  Remarks : Output is sent to the standard output device.
}

UNIT NioLib;

INTERFACE
uses DefLib, CvtLib;



procedure owuns(n: integer; g,l: integer);
{ Output Word Unsigned.
  Write unsigned integer n with base g in l digits. }

procedure owubin(n: integer);
{ Output Word Unsigned Binary.
  Write the binary representation of n in 16 bit
  (0000000000000000..1111111111111111). }

procedure owuoct(n: integer);
{ Output Word Unsigned Octal.
  Write the octal representation of n in 6 digits (000000..177777). }

procedure owuhex(n: integer);
{ Output Word Unsigned Hexadecimal.
  Write the hexadecimal representation of n in 4 digits (0000..FFFF). }

procedure owudec(n: integer);
{ Output Word Unsigned Decimal.
  Write n as an unsigned decimal integer (0..65535). }

procedure owsdec(n: integer);
{ Output Word Signed Decimal.
  Write n as a signed decimal integer (-32768..32767). }



procedure obuns(n: byte; g,l: integer);
{ Output Byte Unsigned.
  Write unsigned byte n with base g in l digits. }

procedure obubin(n: byte);
{ Output Byte Unsigned Binary.
  Write the binary representation of n in 8 bit (00000000..11111111). }

procedure obuoct(n: byte);
{ Output Byte Unsigned Octal.
  Write the octal representation of n in 3 digits (000..377). }

procedure obuhex(n: byte);
{ Output Byte Unsigned Hexadecimal.
  Write the hexadecimal representation of n in 2 digits (00..FF). }

procedure obudec(n: byte);
{ Output Byte Unsigned Decimal.
  Write n as an unsigned decimal byte (0..255). }

procedure obsdec(n: byte);
{ Output Byte Signed Decimal.
  Write n as a signed decimal byte (-128..127). }



function iwuns(g: integer): integer;
{ Input Word Unsigned.
  Read unsigned integer with base g. }

function iwubin: integer;
{ Input Word Unsigned Binary.
  Read binary representation of an unsigned integer (0..1111111111111111). }

function iwuoct: integer;
{ Input Word Unsigned Octal.
  Read octal representation of an unsigned integer (0..177777). }

function iwuhex: integer;
{ Input Word Unsigned Hexadecimal.
  Read hexadecimal representation of an unsigned integer (0..FFFF). }

function iwudec: integer;
{ Input Word Unsigned Decimal.
  Read decimal representation of an unsigned integer (0..65535). }

function iwsdec: integer;
{ Input Word Signed Decimal.
  Read decimal representation of a signed integer (-32768..[+]32767). }



function ibuns(g: integer): byte;
{ Input Byte Unsigned.
  Read unsigned byte with base g. }

function ibubin: byte;
{ Input Byte Unsigned Binary.
  Read binary representation of an unsigned byte (0..11111111). }

function ibuoct: byte;
{ Input Byte Unsigned Octal.
  Read octal representation of an unsigned byte (0..377). }

function ibuhex: byte;
{ Input Byte Unsigned Hexadecimal.
  Read hexadecimal representation of an unsigned byte (0..FF). }

function ibudec: byte;
{ Input Byte Unsigned Decimal.
  Read decimal representation of an unsigned byte (0..255). }

function ibsdec: byte;
{ Input Byte Signed Decimal.
  Read decimal representation of a signed byte (-128..127). }


IMPLEMENTATION

var NioBuf: StpTyp; { global I/O buffer }

procedure owuns(n: integer; g,l: integer);
  begin if l>MaxStp then l:= MaxStp; itoabl(n,NioBuf,g,l); write(NioBuf) end;
procedure owubin(n: integer); begin owuns(n,2,16) end;
procedure owuoct(n: integer); begin owuns(n,8,6) end;
procedure owuhex(n: integer); begin owuns(n,16,4) end;
procedure owudec(n: integer); begin ItoAB(n,NioBuf,10); write(NioBuf) end;
procedure owsdec(n: integer); begin ItoA(n,NioBuf); write(NioBuf) end;

procedure obuns(n: byte; g,l: integer); begin owuns(n,g,l) end;
procedure obubin(n: byte); begin owuns(n,2,8) end;
procedure obuoct(n: byte); begin owuns(n,8,3) end;
procedure obuhex(n: byte); begin owuns(n,16,2) end;
procedure obudec(n: byte); begin owudec(n) end;
procedure obsdec(n: byte);
  function sgnext(b: byte): integer;
  begin if b>127 then sgnext:= b-256 else sgnext:= b end;
begin owsdec(sgnext(n)) end;

function iwuns(g: integer): integer;
  begin readln(NioBuf); iwuns:= atoib(NioBuf,g) end;
function iwubin: integer; begin iwubin:= iwuns(2) end;
function iwuoct: integer; begin iwuoct:= iwuns(8) end;
function iwuhex: integer; begin iwuhex:= iwuns(16) end;
function iwudec: integer; begin iwudec:= iwuns(10) end;
function iwsdec: integer; begin readln(NioBuf); iwsdec:= atoi(NioBuf) end;

function ibuns(g: integer): byte; begin ibuns:= byte(iwuns(g)) end;
function ibubin: byte; begin ibubin:= byte(iwuns(2))  end;
function ibuoct: byte; begin ibuoct:= byte(iwuns(8))  end;
function ibuhex: byte; begin ibuhex:= byte(iwuns(16)) end;
function ibudec: byte; begin ibudec:= byte(iwuns(10)) end;
function ibsdec: byte; begin ibsdec:= byte(iwsdec)    end;

END.
