{ DEFLIB.PAS : General definition library

  Title   : DEFLIB
  Version : 4.4
  Language: Borland (Turbo) Pascal v4.0 through 7.0 (all targets)
            Borland Delphi 1.0 for Windows
  Date    : Nov 09,1996
  Author  : J.R. Ferguson
  Usage   : Unit

}

UNIT DefLib;

INTERFACE


const

{ ASCII character codes }
  AsciiNUL = 000;  AsciiBS  = 008;  AsciiDLE = 016;  AsciiCAN = 024;
  AsciiSOH = 001;  AsciiHT  = 009;  AsciiDC1 = 017;  AsciiEM  = 025;
  AsciiSTX = 002;  AsciiLF  = 010;  AsciiDC2 = 018;  AsciiSUB = 026;
  AsciiETX = 003;  AsciiVT  = 011;  AsciiDC3 = 019;  AsciiESC = 027;
  AsciiEOT = 004;  AsciiFF  = 012;  AsciiDC4 = 020;  AsciiFS  = 028;
  AsciiENQ = 005;  AsciiCR  = 013;  AsciiNAK = 021;  AsciiGS  = 029;
  AsciiACK = 006;  AsciiSO  = 014;  AsciiSYN = 022;  AsciiRS  = 030;
  AsciiBEL = 007;  AsciiSI  = 015;  AsciiETB = 023;  AsciiUS  = 031;
  AsciiDEL = 127;

{ Keyboard scan codes }
  kbCtrlA = $1E01;  kbCtrlH = $2308;  kbCtrlO = $180F;  kbCtrlV = $2F16;
  kbCtrlB = $3002;  kbCtrlI = $1709;  kbCtrlP = $1910;  kbCtrlW = $1117;
  kbCtrlC = $2E03;  kbCtrlJ = $240A;  kbCtrlQ = $1011;  kbCtrlX = $2D18;
  kbCtrlD = $2004;  kbCtrlK = $250B;  kbCtrlR = $1312;  kbCtrlY = $1519;
  kbCtrlE = $1205;  kbCtrlL = $260C;  kbCtrlS = $1F13;  kbCtrlZ = $2C1A;
  kbCtrlF = $2106;  kbCtrlM = $320D;  kbCtrlT = $1414;
  kbCtrlG = $2207;  kbCtrlN = $310E;  kbCtrlU = $1615;
  kbGrayEnter  = $E00D;


  MaxRow   = 25; { Maximum row number for screen display, when the first
                   row has number 1. }
  MaxCol   = 79; { Maximum column number for screen display, when the
                   leftmost column has number 1. }
  { Remark: It is assumed that writing characters on all coordinates from
  (1,1) up through (MaxRow,MaxCol) will not cause the screen to scroll. }

  MinReal  = -9.9E37;
  MaxReal  = +9.9E37;  { Maximum value for a type real number. }
  EpsReal  = +1.0E12;  { Precision for type real numbers. }
  MaxStp   = 255;      { Maximum number of characters in a StpTyp string. }

type
  StpInd   = 0..MaxStp;
  StpTyp   = string[MaxStp];
  StpPtr   = ^StpTyp;

  StzInd   = word;
  StzPtr   = PChar;

  RowInd   = 0..MaxRow;      { screen row index }
  ColInd   = 0..MaxCol;      { screen column index }
  ColStp   = string[MaxCol]; { Stringtype that can contain a screen row }
  { Remark: Although the smallest usable value for RowInd and ColInd is 1
    and not 0, the value 0 is included in the range as a convenient initial
    value for while-loop algorithms. }


  bit        = 0..1;           { 1-bit  unsigned integer }
  nibble     = 0..16;          { 4-bit  unsigned integer }
{ byte       = 0..255;           8-bit  unsigned integer }
{ word       = 0..65535;         16-bit unsigned integer }


IMPLEMENTATION

END.
