{ SRTTST.PAS : Test SRTLIB unit

  Title    : SRTTST
  Version  : 3.0
  Date     : Nov 14,1996
  Author   : J R Ferguson
  Language : Borland Pascal v7.0 (DOS real and protected modes)
  Usage    : Refer procedure Help
}

{$UNDEF  TIME}
{$UNDEF  DEBUG}
{$UNDEF  OUTBUFHEAP}  { UNDEF to avoid a BP 7.0 bug resulting in
                        erroneous file output }

{$V-}
{$R+}


program SRTTST;


uses
{$IFDEF TIME}
 Elaps,
{$ENDIF}
 DefLib, ArgLib, StpLib, ChrLib, SrtLib;


const
  MAXLINE   = 1000;   { Max number of text lines in input }
  MAXFNM    = 79;     { Max filespec length (integrated environment) }
  DFLMSG    = 'CON';  { Default message output destination }
  INPBUFSIZ = 1024;   { Input buffer size in bytes }
  OUTBUFSIZ = 1024;   { Output buffer size in bytes }

  { Error codes and messages: }
  ERROK     = 0;
  ERRARG    = 1;
  ERRFNF    = 2;
  ERRCRE    = 3;
  ERRREA    = 4;
  ERRWRI    = 5;
  ERRMAX    = 6;

  ERRMSG    : array[ERRFNF..ERRMAX] of StpTyp =
 ('File not found',
  'File creation error',
  'Read error',
  'Write error',
  'Too many lines'
 );

type
  InpBufTyp = array[1..INPBUFSIZ] of char; InpBufPtr = ^InpBufTyp;
  OutBufTyp = array[1..OUTBUFSIZ] of char; OutBufPtr = ^OutBufTyp;

  StpPtr    = ^StpTyp;
  PtrBufTyp = array[1..MAXLINE] of StpPtr; { we will sort pointers }
  PtrBufInd = 0..MAXLINE;
  PtrBufPtr = ^StpPtr;

var
  ErrCod    : integer;
  InpFnm,
  OutFnm    : StpTyp;
  Msg,
  Inp,
  Out       : Text;
  InpBuf    : InpBufPtr;
{$IFDEF OUTBUFHEAP}
  OutBuf    : OutBufPtr;
{$ELSE}
  OutBuf    : OutBufTyp;
{$ENDIF}
  InpOpn,
  OutOpn    : boolean;
  OptSrt    : (NoSort,BinInsSort,SelectSort,QuickSort);
  OptKeyBeg : StpInd;
  OptKeyLen : StpInd;
  OptHlp    : boolean;

  PtrBuf    : PtrBufTyp;
  PtrCnt    : PtrBufInd;


{--- General routines ---}

procedure Help;
  procedure wr(s: StpTyp);  begin write  (Msg,s) end;
  procedure wi(i: integer); begin write  (Msg,i) end;
  procedure wl(s: StpTyp);  begin writeln(Msg,s) end;
begin
wl('SRTTST v3.0 (Test SrtLib) : text sort filter');
wl('Usage  : SRTTST [<in] [>out] [/option[...] [...]]');
wl('Options: I           Binary insertion sort');
wl('         S           Selection sort');
wl('         Q           Quicksort');
wr('         K[c1][,c2]  Define key first col c1 [1], last col c2 [');
  wi(MaxStp); wl('].');
wr('         K[c1][,+c2] Define key first col c1 [1], nr of cols c2 [');
  wi(MaxStp); wl('].');
wl('         H           Send this help text to (redirected) output.');
wl('');
wr('Remarks: - If no option is provided, input is copied to output ');
           wl('without sorting.');
wr('         - Max number of input lines is '); wi(MAXLINE); wl('.');
wr('         - Max number of characters per line is '); wi(MaxStp); wl('.');
end;


{--- Command line parsing routines ---}

function ReadUns(var arg: StpTyp): integer;
var n: integer; c: char;
begin
  n:= 0; c:= StpcRet(arg,1);
  while (ErrCod=ERROK) and IsDigit(c) do begin
    StpDel(arg,1,1);
    n:= 10 * n + (ord(c) - ord('0'));
    c:= StpcRet(arg,1);
  end;
  ReadUns:= n;
end;


procedure ReadKeyDesc(var arg: StpTyp);
var n: integer;
begin
  if IsDigit(StpcRet(arg,1)) then OptKeyBeg:= ReadUns(arg) mod MaxStp;
  if StpcRet(arg,1) = ',' then begin
    StpDel(arg,1,1);
    if StpcRet(arg,1) = '+' then begin
      StpDel(arg,1,1);
      if IsDigit(StpcRet(arg,1)) then OptKeyLen:= ReadUns(arg) mod MaxStp
      else ErrCod:= ERRARG;
    end
    else begin
      if IsDigit(StpcRet(arg,1)) then begin
        n:= (ReadUns(arg) mod MaxStp) - OptKeyBeg + 1;
        if n < 0 then ErrCod:= ERRARG else OptKeyLen:= n;
      end
      else ErrCod:= ERRARG;
    end;
  end;
end;


procedure ReadOpt(var arg: StpTyp);
var nextopt: boolean;
begin
  StpDel(arg,1,1);
  repeat
    if StpEmpty(arg) or (StpcRet(arg,1) = '/') then ErrCod:= ERRARG
    else begin
      nextopt:= false;
      while (ErrCod=ERROK) and not nextopt and not StpEmpty(arg) do
      case StpcGet(arg) of
        'I': if (OptSrt = NoSort) or (OptSrt = BinInsSort)
             then OptSrt:= BinInsSort else ErrCod:= ERRARG;
        'S': if (OptSrt = NoSort) or (OptSrt = SelectSort)
             then OptSrt:= SelectSort else ErrCod:= ERRARG;
        'Q': if (OptSrt = NoSort) or (OptSrt = QuickSort)
             then OptSrt:= QuickSort  else ErrCod:= ERRARG;
        'K': ReadKeyDesc(arg);
        'H': OptHlp:= true;
        '/': nextopt:= true;
        else ErrCod:= ERRARG;
      end;
    end;
  until (ErrCod <> ERROK) or not nextopt;
end;


procedure ReadArgs;
var i   : ArgInd;
    arg : StpTyp;
begin
  GetArgs; i:= 0;
  while (ErrCod = ERROK) and (i < ArgC) do begin
    Inc(i); StpCpy(arg,ArgV[i]); StpUpp(arg);
    case StpcRet(arg,1) of
      '/' : ReadOpt(arg);
      '<' : StpSub(InpFnm,arg,2,MAXFNM); {simulate MS-DOS in Integrated Env}
      '>' : StpSub(OutFnm,arg,2,MAXFNM); {simulate MS-DOS in Integrated Env}
      else  ErrCod:= ERRARG;
    end;
  end;
  if OptHlp then if ErrCod = ERROK then ErrCod:= ERRARG else OptHlp:= false; 
end;



{--- Low-level I/O routines ---}

procedure OpenMsg;
begin
  if OptHlp then Assign(Msg,OutFnm) else Assign(Msg,DFLMSG);
  rewrite(Msg);
end;


procedure CloseMsg;
begin Close(Msg) end;


procedure OpenInp;
begin
  Assign(Inp,InpFnm); new(InpBuf); SetTextBuf(Inp,InpBuf^);
  {$I-} reset(Inp); {$I+}
  if IOresult <> 0 then ErrCod:= ERRFNF else InpOpn:= true;
end;


procedure CloseInp;
begin
  dispose(InpBuf);
  {$I-} Close(Inp); {$I+}
  if IOresult = 0 then InpOpn:= false;
end;


procedure ReadInp(var line: StpTyp);
begin
  {$I-} readln(Inp,line); {$I+}
  if IOresult <> 0 then ErrCod:= ERRREA;
end;


procedure OpenOut;
begin
  Assign(Out,OutFnm);
{$IFDEF OUTBUFHEAP}
  new(OutBuf); SetTextBuf(Out,OutBuf^);
{$ELSE}
  SetTextBuf(Out,OutBuf);
{$ENDIF}
  {$I-} rewrite(Out); {$I+}
  if IOresult <> 0 then ErrCod:= ERRCRE else OutOpn:= true;
end;


procedure CloseOut;
begin
{$IFDEF OUTBUFHEAP}
  dispose(OutBuf);
{$ENDIF}
  {$I-} Close(Out); {$I+}
  if IOresult = 0 then OutOpn:= false else begin
    if ErrCod = ERROK then ErrCod:= ERRWRI;
  end
end;


procedure WriteOut(line: StpTyp);
begin
  {$I-} writeln(Out,line); {$I+}
  if IOresult <> 0 then ErrCod:= ERRWRI;
end;


{--- High level I/O and sorting ---}

procedure ReadBuffer;
begin
  PtrCnt:= 0;
  while (ErrCod=ERROK) and not eof(Inp) do begin
    if PtrCnt >= MAXLINE then ErrCod:= ERRMAX
    else begin
      Inc(PtrCnt); new(PtrBuf[PtrCnt]);
      ReadInp(PtrBuf[PtrCnt]^);
    end;
  end;
end;


procedure WriteBuffer;
var i: PtrBufInd;
begin
  i:= 0;
  while (ErrCod=ERROK) and (i<PtrCnt) do begin
    Inc(i);
    WriteOut(PtrBuf[i]^);
    dispose(PtrBuf[i]);
  end;
end;


{$F+}
function SortOrder(e1,e2: SrtElmPtr): integer;
{$IFDEF DEBUG}
var s1,s2: StpTyp; result: integer;
begin
  StpSub(s1, StpPtr(PtrBufPtr(e1)^)^, OptKeyBeg, OptKeyLen);
  StpSub(s2, StpPtr(PtrBufPtr(e2)^)^, OptKeyBeg, OptKeyLen);
  result:= StpCmp(s1,s2);
  SortOrder:= result;
end;
{$ELSE}
begin
  SortOrder:=
  StpCmp( Copy(StpPtr(PtrBufPtr(e1)^)^,OptKeyBeg,OptKeyLen),
          Copy(StpPtr(PtrBufPtr(e2)^)^,OptKeyBeg,OptKeyLen) )
end;
{$ENDIF}
{$F-}


procedure SortBuffer;
begin
  case OptSrt of
    NoSort     : {do nothing} ;
    BinInsSort : SrtBinIns(@PtrBuf, PtrCnt, SizeOf(StpPtr), SortOrder);
    SelectSort : SrtSelect(@PtrBuf, PtrCnt, SizeOf(StpPtr), SortOrder);
    QuickSort  : SrtQuick (@PtrBuf, PtrCnt, SizeOf(StpPtr), SortOrder);
  end;
end;


{--- Main line ---}

procedure MainProcess;
begin
  ReadBuffer;
  if ErrCod=ERROK then begin
    SortBuffer;
    if ErrCod=ERROK then WriteBuffer;
  end;
end;


procedure MainInit;
begin
  ErrCod:= ERROK;
  StpCreate(InpFnm); InpOpn:= false;
  StpCreate(OutFnm); OutOpn:= false;
  OptSrt:= NoSort;
  OptKeyBeg:= 1; OptKeyLen:= MaxStp;
  OptHlp:= false;
  ReadArgs;
  if ErrCod = ERROK then OpenInp;
  if ErrCod = ERROK then OpenOut;
end;


procedure MainExit;
begin
  if InpOpn then CloseInp;
  if OutOpn then CloseOut;
  if ErrCod <> ERROK then begin
    OpenMsg;
    if (ErrCod=ERRARG) then Help
    else writeln(Msg,'SRTTST: ',ERRMSG[ErrCod]);
    CloseMsg;
  end;
end;


begin { Main program }
  MainInit;
  if ErrCod = ERROK then MainProcess;
  MainExit;
end.
